/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ClasspathExtension;
import org.openqa.selenium.firefox.internal.Extension;
import org.openqa.selenium.firefox.internal.FileExtension;
import org.openqa.selenium.remote.service.DriverService;

public class XpiDriverService
extends DriverService {
    private final Lock lock = new ReentrantLock();
    private final int port;
    private final FirefoxBinary binary;
    private final FirefoxProfile profile;
    private File profileDir;

    private XpiDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment, FirefoxBinary binary, FirefoxProfile profile) throws IOException {
        super(executable, port, args, environment);
        Preconditions.checkState((port > 0 ? 1 : 0) != 0, (Object)"Port must be set");
        this.port = port;
        this.binary = binary;
        this.profile = profile;
        String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
        if (firefoxLogFile != null) {
            if ("/dev/stdout".equals(firefoxLogFile)) {
                this.sendOutputTo(System.out);
            } else {
                this.sendOutputTo(new FileOutputStream(firefoxLogFile));
            }
        }
    }

    @Override
    protected URL getUrl(int port) throws IOException {
        return new URL("http", "localhost", port, "/hub");
    }

    @Override
    public void start() throws IOException {
        this.lock.lock();
        try {
            this.profile.setPreference("webdriver_firefox_port", this.port);
            this.addWebDriverExtension(this.profile);
            this.profileDir = this.profile.layoutOnDisk();
            this.binary.setOutputWatcher(this.getOutputStream());
            this.binary.startProfile(this.profile, this.profileDir, "-foreground");
            this.waitUntilAvailable();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.binary.quit();
            this.profile.cleanTemporaryModel();
            this.profile.clean(this.profileDir);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addWebDriverExtension(FirefoxProfile profile) {
        if (profile.containsWebDriverExtension()) {
            return;
        }
        profile.addExtension("webdriver", this.loadCustomExtension().orElse(XpiDriverService.loadDefaultExtension()));
    }

    private Optional<Extension> loadCustomExtension() {
        String xpiProperty = System.getProperty("webdriver.firefox.driver");
        if (xpiProperty != null) {
            File xpi = new File(xpiProperty);
            return Optional.of(new FileExtension(xpi));
        }
        return Optional.empty();
    }

    private static Extension loadDefaultExtension() {
        return new ClasspathExtension(FirefoxProfile.class, "/" + FirefoxProfile.class.getPackage().getName().replace(".", "/") + "/webdriver.xpi");
    }

    public static XpiDriverService createDefaultService() {
        try {
            return (XpiDriverService)((Builder)new Builder().usingAnyFreePort()).build();
        }
        catch (WebDriverException e) {
            throw new IllegalStateException(e.getMessage(), e.getCause());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DriverService.Builder<XpiDriverService, Builder> {
        private FirefoxBinary binary = null;
        private FirefoxProfile profile = null;

        private Builder() {
        }

        public Builder withBinary(FirefoxBinary binary) {
            this.binary = (FirefoxBinary)Preconditions.checkNotNull((Object)binary);
            return this;
        }

        public Builder withProfile(FirefoxProfile profile) {
            this.profile = (FirefoxProfile)Preconditions.checkNotNull((Object)profile);
            return this;
        }

        @Override
        protected File findDefaultExecutable() {
            return new FirefoxBinary().getFile();
        }

        @Override
        protected ImmutableList<String> createArgs() {
            return ImmutableList.of((Object)"-foreground");
        }

        @Override
        protected XpiDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new XpiDriverService(exe, port, args, environment, this.binary == null ? new FirefoxBinary() : this.binary, this.profile == null ? new FirefoxProfile() : this.profile);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

