/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.internal.ElementScrollBehavior;

@Beta
public class InternetExplorerOptions {
    private static final String IE_OPTIONS = "se:ieOptions";
    private static final String FULL_PAGE_SCREENSHOT = "ie.enableFullPageScreenshot";
    private static final String UPLOAD_DIALOG_TIMEOUT = "ie.fileUploadDialogTimeout";
    private static final String FORCE_WINDOW_SHELL_API = "ie.forceShellWindowsApi";
    private static final String VALIDATE_COOKIE_DOCUMENT_TYPE = "ie.validateCookieDocumentType";
    private static final Set<String> CAPABILIITY_NAMES = ImmutableSortedSet.naturalOrder().add((Object)"browserAttachTimeout").add((Object)"elementScrollBehavior").add((Object)"enablePersistentHover").add((Object)"ie.enableFullPageScreenshot").add((Object)"ie.forceCreateProcessApi").add((Object)"ie.forceShellWindowsApi").add((Object)"ie.ensureCleanSession").add((Object)"ie.browserCommandLineSwitches").add((Object)"ie.usePerProcessProxy").add((Object)"ignoreZoomSetting").add((Object)"initialBrowserUrl").add((Object)"ignoreProtectedModeSettings").add((Object)"requireWindowFocus").add((Object)"ie.fileUploadDialogTimeout").add((Object)"ie.validateCookieDocumentType").build();
    private final Map<String, Object> renderedView;
    private final Map<String, Object> options;

    public InternetExplorerOptions() {
        this(new ImmutableCapabilities(new HashMap()));
    }

    public InternetExplorerOptions(Capabilities source) {
        HashMap existing;
        Preconditions.checkNotNull((Object)source, (Object)"Source capabilities must not be null");
        this.renderedView = new HashMap(source.asMap());
        Object raw = source.getCapability(IE_OPTIONS);
        if (raw instanceof Map) {
            existing = (HashMap)raw;
        } else if (raw == null) {
            existing = new HashMap();
        } else {
            throw new IllegalArgumentException("Existing options are not of expected type: " + raw);
        }
        Map<String, ?> originalCapabilities = source.asMap();
        this.options = CAPABILIITY_NAMES.stream().filter(originalCapabilities::containsKey).filter(key -> originalCapabilities.get(key) != null).collect(Collectors.toMap(key -> key, originalCapabilities::get));
        this.options.putAll(CAPABILIITY_NAMES.stream().filter(existing::containsKey).filter(name -> existing.get(name) != null).collect(Collectors.toMap(key -> key, existing::get)));
        this.renderedView.putAll(this.options);
        this.renderedView.put(IE_OPTIONS, this.options);
    }

    public InternetExplorerOptions withAttachTimeout(long duration, TimeUnit unit) {
        return this.withAttachTimeout(Duration.ofMillis(unit.toMillis(duration)));
    }

    public InternetExplorerOptions withAttachTimeout(Duration duration) {
        return this.amend("browserAttachTimeout", duration.toMillis());
    }

    public InternetExplorerOptions elementScrollTo(ElementScrollBehavior behavior) {
        return this.amend("elementScrollBehavior", behavior.getValue());
    }

    public InternetExplorerOptions enablePersistentHovering() {
        return this.amend("enablePersistentHover", true);
    }

    public InternetExplorerOptions useCreateProcessApiToLaunchIe() {
        return this.amend("ie.forceCreateProcessApi", true);
    }

    public InternetExplorerOptions useShellWindowsApiToAttachToIe() {
        return this.amend(FORCE_WINDOW_SHELL_API, true);
    }

    public InternetExplorerOptions destructivelyEnsureCleanSession() {
        return this.amend("ie.ensureCleanSession", true);
    }

    public InternetExplorerOptions addCommandSwitches(String ... switches) {
        List flags = this.options.getOrDefault("ie.browserCommandLineSwitches", new ArrayList());
        flags.addAll(Arrays.asList(switches));
        return this.amend("ie.browserCommandLineSwitches", flags);
    }

    public InternetExplorerOptions usePerProcessProxy() {
        return this.amend("ie.usePerProcessProxy", true);
    }

    public InternetExplorerOptions withInitialBrowserUrl(String url) {
        return this.amend("initialBrowserUrl", Preconditions.checkNotNull((Object)url));
    }

    public InternetExplorerOptions requireWindowFocus() {
        return this.amend("requireWindowFocus", true);
    }

    public InternetExplorerOptions waitForUploadDialogUpTo(long duration, TimeUnit unit) {
        return this.waitForUploadDialogUpTo(Duration.ofMillis(unit.toMillis(duration)));
    }

    public InternetExplorerOptions waitForUploadDialogUpTo(Duration duration) {
        return this.amend(UPLOAD_DIALOG_TIMEOUT, duration.toMillis());
    }

    public InternetExplorerOptions introduceFlakinessByIgnoringSecurityDomains() {
        return this.amend("ignoreProtectedModeSettings", true);
    }

    public InternetExplorerOptions enableNativeEvents() {
        return this.amend("nativeEvents", true);
    }

    public InternetExplorerOptions ignoreZoomSettings() {
        return this.amend("ignoreZoomSetting", true);
    }

    public InternetExplorerOptions takeFullPageScreenshot() {
        return this.amend(FULL_PAGE_SCREENSHOT, true);
    }

    private InternetExplorerOptions amend(String optionName, Object value) {
        this.renderedView.put(optionName, value);
        this.options.put(optionName, value);
        return this;
    }

    public Capabilities merge(Capabilities other) {
        HashMap caps = new HashMap(other.asMap());
        caps.putAll(this.renderedView);
        return new ImmutableCapabilities(caps);
    }

    public Map<String, ?> asMap() {
        return this.options;
    }
}

