/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Encodable;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.SourceType;

public class PointerInput
implements InputSource,
Encodable {
    private final Kind kind;
    private final String name;

    public PointerInput(Kind kind, String name) {
        this.kind = (Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind), (Object)"Must set kind of pointer device"));
        this.name = Optional.ofNullable(name).orElse(UUID.randomUUID().toString());
    }

    @Override
    public SourceType getInputType() {
        return SourceType.POINTER;
    }

    @Override
    public Map<String, Object> encode() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("type", "pointer");
        toReturn.put("id", this.name);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("pointerType", this.kind.getWireName());
        toReturn.put("parameters", parameters);
        return toReturn;
    }

    public Interaction createPointerMove(Duration duration, Origin origin, int x, int y) {
        return new Move(this, duration, origin, x, y);
    }

    public Interaction createPointerDown(int button) {
        return new PointerPress(this, PointerPress.Direction.DOWN, button);
    }

    public Interaction createPointerUp(int button) {
        return new PointerPress(this, PointerPress.Direction.UP, button);
    }

    public static final class Origin {
        private final Object originObject;

        public Object asArg() {
            return this.originObject;
        }

        private Origin(Object originObject) {
            this.originObject = originObject;
        }

        public static Origin pointer() {
            return new Origin("pointer");
        }

        public static Origin viewport() {
            return new Origin("viewport");
        }

        public static Origin fromElement(WebElement element) {
            return new Origin(Preconditions.checkNotNull((Object)element));
        }
    }

    public static enum MouseButton {
        LEFT(0),
        MIDDLE(1),
        RIGHT(2);

        private final int button;

        private MouseButton(int button) {
            this.button = button;
        }

        public int asArg() {
            return this.button;
        }
    }

    public static enum Kind {
        MOUSE("mouse"),
        PEN("pen"),
        TOUCH("touch");

        private final String wireName;

        private Kind(String pointerSubType) {
            this.wireName = pointerSubType;
        }

        public String getWireName() {
            return this.wireName;
        }
    }

    private static class Move
    extends Interaction
    implements Encodable {
        private final Origin origin;
        private final int x;
        private final int y;
        private final Duration duration;

        protected Move(InputSource source, Duration duration, Origin origin, int x, int y) {
            super(source);
            Preconditions.checkState((!duration.isNegative() ? 1 : 0) != 0, (String)"Duration value must be 0 or greater: %s", (Object)duration);
            this.origin = (Origin)Preconditions.checkNotNull((Object)origin, (Object)"Origin of move must be set");
            this.x = x;
            this.y = y;
            this.duration = duration;
        }

        @Override
        protected boolean isValidFor(SourceType sourceType) {
            return SourceType.POINTER == sourceType;
        }

        @Override
        public Map<String, Object> encode() {
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            toReturn.put("type", "pointerMove");
            toReturn.put("duration", this.duration.toMillis());
            toReturn.put("origin", this.origin.asArg());
            toReturn.put("x", this.x);
            toReturn.put("y", this.y);
            return toReturn;
        }
    }

    private static class PointerPress
    extends Interaction
    implements Encodable {
        private final Direction direction;
        private final int button;

        public PointerPress(InputSource source, Direction direction, int button) {
            super(source);
            Preconditions.checkState((button >= 0 ? 1 : 0) != 0, (String)"Button must be greater than or equal to 0: %d", (int)button);
            this.direction = (Direction)((Object)Preconditions.checkNotNull((Object)((Object)direction)));
            this.button = button;
        }

        @Override
        public Map<String, Object> encode() {
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            toReturn.put("type", this.direction.getType());
            toReturn.put("button", this.button);
            return toReturn;
        }

        static enum Direction {
            DOWN("pointerDown"),
            UP("pointerUp");

            private final String type;

            private Direction(String type) {
                this.type = type;
            }

            public String getType() {
                return this.type;
            }
        }
    }
}

