/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.phantomjs;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.ConnectException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;

class PhantomJSCommandExecutor
extends HttpCommandExecutor {
    private final PhantomJSDriverService service;

    PhantomJSCommandExecutor(PhantomJSDriverService service) {
        super(PhantomJSDriver.getCustomCommands(), service.getUrl());
        this.service = service;
    }

    @Override
    public Response execute(Command command) throws IOException {
        if ("newSession".equals(command.getName())) {
            this.service.start();
        }
        try {
            Response response = super.execute(command);
            return response;
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof ConnectException && "Connection refused".equals(rootCause.getMessage()) && !this.service.isRunning()) {
                throw new WebDriverException("The PhantomJS/GhostDriver server has unexpectedly died!", t);
            }
            Throwables.propagateIfPossible((Throwable)t);
            throw new WebDriverException(t);
        }
        finally {
            if ("quit".equals(command.getName())) {
                this.service.stop();
            }
        }
    }
}

