/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.Gecko013ProtocolResponse;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.JsonWireProtocolResponse;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.W3CHandshakeResponse;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ProtocolHandshake {
    private static final Logger LOG = Logger.getLogger(ProtocolHandshake.class.getName());
    private final Predicate<String> ACCEPTED_W3C_PATTERNS = Stream.of("^[\\w-]+:.*$", "^acceptInsecureCerts$", "^browserName$", "^browserVersion$", "^platformName$", "^pageLoadStrategy$", "^proxy$", "^setWindowRect$", "^timeouts$", "^unhandledPromptBehavior$").map(Pattern::compile).map(Pattern::asPredicate).reduce(identity -> false, Predicate::or);
    private static final Type MAP_TYPE = new TypeToken<Map<?, ?>>(){}.getType();
    private Function<HttpResponse, ResponseCodeAndJson> ensureJson = res -> {
        try {
            Map blob = (Map)new Gson().fromJson(res.getContentString(), MAP_TYPE);
            return new ResponseCodeAndJson(0L, res.getStatus(), blob);
        }
        catch (JsonParseException e) {
            throw new WebDriverException("Unable to parse remote response: " + res.getContentString());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result createSession(HttpClient client, Command command) throws IOException {
        Capabilities desired = (Capabilities)command.getParameters().get("desiredCapabilities");
        desired = desired == null ? new DesiredCapabilities() : desired;
        Capabilities required = (Capabilities)command.getParameters().get("requiredCapabilities");
        required = required == null ? new DesiredCapabilities() : required;
        BeanToJsonConverter converter = new BeanToJsonConverter();
        JsonObject des = (JsonObject)converter.convertObject(desired);
        JsonObject req = (JsonObject)converter.convertObject(required);
        Path jsonFile = Files.createTempFile("new-session", ".json", new FileAttribute[0]);
        try (BufferedWriter fileWriter = Files.newBufferedWriter(jsonFile, Charsets.UTF_8, new OpenOption[0]);
             JsonWriter out = new JsonWriter(fileWriter);){
            out.setHtmlSafe(true);
            out.setIndent("  ");
            Gson gson = new Gson();
            out.beginObject();
            this.streamJsonWireProtocolParameters(out, gson, des, req);
            out.name("capabilities");
            out.beginObject();
            this.streamGeckoDriver013Parameters(out, gson, des, req);
            this.streamW3CProtocolParameters(out, gson, des, req);
            out.endObject();
            out.endObject();
            out.flush();
            long size = Files.size(jsonFile);
            try (InputStream rawIn = Files.newInputStream(jsonFile, new OpenOption[0]);
                 BufferedInputStream contentStream = new BufferedInputStream(rawIn);){
                LOG.fine("Attempting multi-dialect session, assuming Postel's Law holds true on the remote end");
                Optional<Result> result = this.createSession(client, contentStream, size);
                if (result.isPresent()) {
                    Result toReturn = result.get();
                    LOG.info(String.format("Detected dialect: %s", new Object[]{toReturn.dialect}));
                    Result result2 = toReturn;
                    return result2;
                }
            }
        }
        finally {
            Files.deleteIfExists(jsonFile);
        }
        throw new SessionNotCreatedException(String.format("Unable to create new remote session. desired capabilities = %s, required capabilities = %s", desired, required));
    }

    private void streamJsonWireProtocolParameters(JsonWriter out, Gson gson, JsonObject des, JsonObject req) throws IOException {
        out.name("desiredCapabilities");
        gson.toJson((JsonElement)des, out);
        out.name("requiredCapabilities");
        gson.toJson((JsonElement)req, out);
    }

    private void streamW3CProtocolParameters(JsonWriter out, Gson gson, JsonObject des, JsonObject req) throws IOException {
        Map<String, JsonElement> chrome = Stream.of(des, req).map(JsonObject::entrySet).flatMap(Collection::stream).filter(entry -> "browserName".equals(entry.getKey()) && "chrome".equals(((JsonElement)entry.getValue()).getAsString()) || "chromeOptions".equals(entry.getKey())).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> right));
        Map<String, JsonElement> edge = Stream.of(des, req).map(JsonObject::entrySet).flatMap(Collection::stream).filter(entry -> "browserName".equals(entry.getKey()) && "MicrosoftEdge".equals(((JsonElement)entry.getValue()).getAsString())).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> right));
        Map<String, JsonElement> firefox = Stream.of(des, req).map(JsonObject::entrySet).flatMap(Collection::stream).filter(entry -> "browserName".equals(entry.getKey()) && "firefox".equals(((JsonElement)entry.getValue()).getAsString()) || ((String)entry.getKey()).startsWith("firefox_") || ((String)entry.getKey()).startsWith("moz:")).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> right));
        Map<String, JsonElement> ie = Stream.of(req, des).map(JsonObject::entrySet).flatMap(Collection::stream).filter(entry -> "browserName".equals(entry.getKey()) && "internet explorer".equals(((JsonElement)entry.getValue()).getAsString()) || "browserAttachTimeout".equals(entry.getKey()) || "enableElementCacheCleanup".equals(entry.getKey()) || "enablePersistentHover".equals(entry.getKey()) || "extractPath".equals(entry.getKey()) || "host".equals(entry.getKey()) || "ignoreZoomSetting".equals(entry.getKey()) || "initialBrowserZoom".equals(entry.getKey()) || "logFile".equals(entry.getKey()) || "logLevel".equals(entry.getKey()) || "requireWindowFocus".equals(entry.getKey()) || "silent".equals(entry.getKey()) || ((String)entry.getKey()).startsWith("ie.")).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> right));
        Map<String, JsonElement> opera = Stream.of(des, req).map(JsonObject::entrySet).flatMap(Collection::stream).filter(entry -> "browserName".equals(entry.getKey()) && "operablink".equals(((JsonElement)entry.getValue()).getAsString()) || "browserName".equals(entry.getKey()) && "opera".equals(((JsonElement)entry.getValue()).getAsString()) || "operaOptions".equals(entry.getKey())).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> right));
        Map<String, JsonElement> safari = Stream.of(des, req).map(JsonObject::entrySet).flatMap(Collection::stream).filter(entry -> "browserName".equals(entry.getKey()) && "safari".equals(((JsonElement)entry.getValue()).getAsString()) || "safari.options".equals(entry.getKey())).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> right));
        Set excludedKeys = (Set)Stream.of(chrome, edge, firefox, ie, opera, safari).map(Map::keySet).flatMap(Collection::stream).distinct().collect(ImmutableSet.toImmutableSet());
        JsonObject alwaysMatch = Stream.of(des, req).map(JsonObject::entrySet).flatMap(Collection::stream).filter(entry -> !excludedKeys.contains(entry.getKey())).filter(entry -> entry.getValue() != null).filter(entry -> this.ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())).distinct().collect(Collector.of(JsonObject::new, (obj, e) -> obj.add((String)e.getKey(), (JsonElement)e.getValue()), (left, right) -> {
            for (Map.Entry<String, JsonElement> entry : right.entrySet()) {
                left.add(entry.getKey(), entry.getValue());
            }
            return left;
        }, new Collector.Characteristics[0]));
        JsonArray firstMatch = Stream.of(chrome, edge, firefox, ie, opera, safari).filter(map -> !map.isEmpty()).map(map -> {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                if (!this.ACCEPTED_W3C_PATTERNS.test((String)entry.getKey())) continue;
                json.add((String)entry.getKey(), gson.toJsonTree(entry.getValue()));
            }
            return json;
        }).collect(Collector.of(JsonArray::new, JsonArray::add, (left, right) -> {
            for (JsonElement element : right) {
                left.add(element);
            }
            return left;
        }, new Collector.Characteristics[0]));
        out.name("alwaysMatch");
        gson.toJson((JsonElement)alwaysMatch, out);
        out.name("firstMatch");
        gson.toJson((JsonElement)firstMatch, out);
    }

    private Optional<Result> createSession(HttpClient client, InputStream newSessionBlob, long size) throws IOException {
        Map blob;
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/session");
        request.setHeader("Content-Length", String.valueOf(size));
        request.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        request.setContent(newSessionBlob);
        long start = System.currentTimeMillis();
        HttpResponse response = client.execute(request, true);
        long time = System.currentTimeMillis() - start;
        try {
            blob = (Map)new Gson().fromJson(response.getContentString(), MAP_TYPE);
        }
        catch (JsonParseException e) {
            throw new WebDriverException("Unable to parse remote response: " + response.getContentString());
        }
        InitialHandshakeResponse initialResponse = new InitialHandshakeResponse(time, response.getStatus(), blob);
        return Stream.of(new JsonWireProtocolResponse().getResponseFunction(), new Gecko013ProtocolResponse().getResponseFunction(), new W3CHandshakeResponse().getResponseFunction()).map(func -> (Optional)func.apply(initialResponse)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private void streamGeckoDriver013Parameters(JsonWriter out, Gson gson, JsonObject des, JsonObject req) throws IOException {
        out.name("desiredCapabilities");
        gson.toJson((JsonElement)des, out);
        out.name("requiredCapabilities");
        gson.toJson((JsonElement)req, out);
    }

    public static class Result {
        private static Function<Object, Proxy> massageProxy = obj -> {
            if (obj instanceof Proxy) {
                return (Proxy)obj;
            }
            if (!(obj instanceof Map)) {
                return null;
            }
            Map rawMap = (Map)obj;
            for (Object key : rawMap.keySet()) {
                if (key instanceof String) continue;
                return null;
            }
            return new Proxy((Map)obj);
        };
        private final Dialect dialect;
        private final Map<String, ?> capabilities;
        private final SessionId sessionId;

        Result(Dialect dialect, String sessionId, Map<String, ?> capabilities) {
            this.dialect = dialect;
            this.sessionId = new SessionId((String)Preconditions.checkNotNull((Object)sessionId));
            this.capabilities = capabilities;
            if (capabilities.containsKey("proxy")) {
                capabilities.put("proxy", massageProxy.apply(capabilities.get("proxy")));
            }
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public Response createResponse() {
            Response response = new Response(this.sessionId);
            response.setValue(this.capabilities);
            response.setStatus(0);
            response.setState("success");
            return response;
        }

        public String toString() {
            return String.format("%s: %s", new Object[]{this.dialect, this.capabilities});
        }
    }

    private static class ResponseCodeAndJson {
        public final Duration duration;
        public final int statusCode;
        public final Map<?, ?> blob;

        public ResponseCodeAndJson(long timeInMillis, int statusCode, Map<?, ?> blob) {
            this.duration = Duration.ofMillis(timeInMillis);
            this.statusCode = statusCode;
            this.blob = blob;
        }
    }
}

