/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.HasIdentity;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

public class RemoteWebElement
implements WebElement,
FindsByLinkText,
FindsById,
FindsByName,
FindsByTagName,
FindsByClassName,
FindsByCssSelector,
FindsByXPath,
WrapsDriver,
Locatable,
HasIdentity,
TakesScreenshot {
    private String foundBy;
    protected String id;
    protected RemoteWebDriver parent;
    protected FileDetector fileDetector;

    protected void setFoundBy(SearchContext foundFrom, String locator, String term) {
        this.foundBy = String.format("[%s] -> %s: %s", foundFrom, locator, term);
    }

    public void setParent(RemoteWebDriver parent) {
        this.parent = parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFileDetector(FileDetector detector) {
        this.fileDetector = detector;
    }

    @Override
    public void click() {
        this.execute("clickElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    @Override
    public void submit() {
        this.execute("submitElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    @Override
    public void sendKeys(CharSequence ... keysToSend) {
        File localFile = this.fileDetector.getLocalFile(keysToSend);
        if (localFile != null) {
            String remotePath = this.upload(localFile);
            keysToSend = new CharSequence[]{remotePath};
        }
        this.execute("sendKeysToElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"value", (Object)keysToSend));
    }

    private String upload(File localFile) {
        if (!localFile.isFile()) {
            throw new WebDriverException("You may only upload files: " + localFile);
        }
        try {
            String zip = Zip.zip(localFile);
            Response response = this.execute("uploadFile", (Map<String, ?>)ImmutableMap.of((Object)"file", (Object)zip));
            return (String)response.getValue();
        }
        catch (IOException e) {
            throw new WebDriverException("Cannot upload " + localFile, e);
        }
    }

    @Override
    public void clear() {
        this.execute("clearElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    @Override
    public String getTagName() {
        return (String)this.execute("getElementTagName", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    @Override
    public String getAttribute(String name) {
        return RemoteWebElement.stringValueOf(this.execute("getElementAttribute", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"name", (Object)name)).getValue());
    }

    private static String stringValueOf(Object o) {
        if (o == null) {
            return null;
        }
        return String.valueOf(o);
    }

    @Override
    public boolean isSelected() {
        Object value = this.execute("isElementSelected", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
        try {
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to Boolean: " + value, ex);
        }
    }

    @Override
    public boolean isEnabled() {
        Object value = this.execute("isElementEnabled", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
        try {
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to Boolean: " + value, ex);
        }
    }

    @Override
    public String getText() {
        Response response = this.execute("getElementText", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        return (String)response.getValue();
    }

    @Override
    public String getCssValue(String propertyName) {
        Response response = this.execute("getElementValueOfCssProperty", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"propertyName", (Object)propertyName));
        return (String)response.getValue();
    }

    @Override
    public List<WebElement> findElements(By by) {
        return by.findElements(this);
    }

    @Override
    public WebElement findElement(By by) {
        return by.findElement(this);
    }

    protected WebElement findElement(String using, String value) {
        WebElement element;
        Response response = this.execute("findChildElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)using, (Object)"value", (Object)value));
        Object responseValue = response.getValue();
        try {
            element = (WebElement)responseValue;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to WebElement: " + value, ex);
        }
        this.parent.setFoundBy(this, element, using, value);
        return element;
    }

    protected List<WebElement> findElements(String using, String value) {
        List allElements;
        Response response = this.execute("findChildElements", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)using, (Object)"value", (Object)value));
        Object responseValue = response.getValue();
        try {
            allElements = (List)responseValue;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<WebElement>: " + responseValue, ex);
        }
        for (WebElement element : allElements) {
            this.parent.setFoundBy(this, element, using, value);
        }
        return allElements;
    }

    @Override
    public WebElement findElementById(String using) {
        return this.findElement("id", using);
    }

    @Override
    public List<WebElement> findElementsById(String using) {
        return this.findElements("id", using);
    }

    @Override
    public WebElement findElementByLinkText(String using) {
        return this.findElement("link text", using);
    }

    @Override
    public List<WebElement> findElementsByLinkText(String using) {
        return this.findElements("link text", using);
    }

    @Override
    public WebElement findElementByName(String using) {
        return this.findElement("name", using);
    }

    @Override
    public List<WebElement> findElementsByName(String using) {
        return this.findElements("name", using);
    }

    @Override
    public WebElement findElementByClassName(String using) {
        return this.findElement("class name", using);
    }

    @Override
    public List<WebElement> findElementsByClassName(String using) {
        return this.findElements("class name", using);
    }

    @Override
    public WebElement findElementByCssSelector(String using) {
        return this.findElement("css selector", using);
    }

    @Override
    public List<WebElement> findElementsByCssSelector(String using) {
        return this.findElements("css selector", using);
    }

    @Override
    public WebElement findElementByXPath(String using) {
        return this.findElement("xpath", using);
    }

    @Override
    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("xpath", using);
    }

    @Override
    public WebElement findElementByPartialLinkText(String using) {
        return this.findElement("partial link text", using);
    }

    @Override
    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.findElements("partial link text", using);
    }

    @Override
    public WebElement findElementByTagName(String using) {
        return this.findElement("tag name", using);
    }

    @Override
    public List<WebElement> findElementsByTagName(String using) {
        return this.findElements("tag name", using);
    }

    protected Response execute(String command, Map<String, ?> parameters) {
        return this.parent.execute(command, parameters);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        while (other instanceof WrapsElement) {
            other = ((WrapsElement)((Object)other)).getWrappedElement();
        }
        if (!(other instanceof RemoteWebElement)) {
            return false;
        }
        RemoteWebElement otherRemoteWebElement = (RemoteWebElement)other;
        return this.id.equals(otherRemoteWebElement.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    @Override
    public boolean isDisplayed() {
        Object value = this.execute("isElementDisplayed", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
        try {
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to Boolean: " + value, ex);
        }
    }

    @Override
    public Point getLocation() {
        Response response = this.execute("getElementLocation", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawPoint = (Map)response.getValue();
        int x = ((Number)rawPoint.get("x")).intValue();
        int y = ((Number)rawPoint.get("y")).intValue();
        return new Point(x, y);
    }

    @Override
    public Dimension getSize() {
        Response response = this.execute("getElementSize", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawSize = (Map)response.getValue();
        int width = ((Number)rawSize.get("width")).intValue();
        int height = ((Number)rawSize.get("height")).intValue();
        return new Dimension(width, height);
    }

    @Override
    public Rectangle getRect() {
        Response response = this.execute("getElementRect", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawRect = (Map)response.getValue();
        int x = ((Number)rawRect.get("x")).intValue();
        int y = ((Number)rawRect.get("y")).intValue();
        int width = ((Number)rawRect.get("width")).intValue();
        int height = ((Number)rawRect.get("height")).intValue();
        return new Rectangle(x, y, height, width);
    }

    @Override
    public Coordinates getCoordinates() {
        return new Coordinates(){

            @Override
            public Point onScreen() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Point inViewPort() {
                Response response = RemoteWebElement.this.execute("getElementLocationOnceScrolledIntoView", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)RemoteWebElement.this.getId()));
                Map mapped = (Map)response.getValue();
                return new Point(((Number)mapped.get("x")).intValue(), ((Number)mapped.get("y")).intValue());
            }

            @Override
            public Point onPage() {
                return RemoteWebElement.this.getLocation();
            }

            @Override
            public Object getAuxiliary() {
                return RemoteWebElement.this.getId();
            }
        };
    }

    @Override
    @Beta
    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Response response = this.execute("elementScreenshot", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Object result = response.getValue();
        if (result instanceof String) {
            String base64EncodedPng = (String)result;
            return outputType.convertFromBase64Png(base64EncodedPng);
        }
        if (result instanceof byte[]) {
            String base64EncodedPng = new String((byte[])result);
            return outputType.convertFromBase64Png(base64EncodedPng);
        }
        throw new RuntimeException(String.format("Unexpected result for %s command: %s", "elementScreenshot", result == null ? "null" : result.getClass().getName() + " instance"));
    }

    public String toString() {
        if (this.foundBy == null) {
            return String.format("[%s -> unknown locator]", super.toString());
        }
        return String.format("[%s]", this.foundBy);
    }

    public Map<String, Object> toJson() {
        return ImmutableMap.of((Object)Dialect.OSS.getEncodedElementKey(), (Object)this.getId(), (Object)Dialect.W3C.getEncodedElementKey(), (Object)this.getId());
    }
}

