/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class ExpectedConditions {
    private static final Logger log = Logger.getLogger(ExpectedConditions.class.getName());

    private ExpectedConditions() {
    }

    public static ExpectedCondition<Boolean> titleIs(final String title) {
        return new ExpectedCondition<Boolean>(){
            private String currentTitle = "";

            public Boolean apply(WebDriver driver) {
                this.currentTitle = driver.getTitle();
                return title.equals(this.currentTitle);
            }

            public String toString() {
                return String.format("title to be \"%s\". Current title: \"%s\"", title, this.currentTitle);
            }
        };
    }

    public static ExpectedCondition<Boolean> titleContains(final String title) {
        return new ExpectedCondition<Boolean>(){
            private String currentTitle = "";

            public Boolean apply(WebDriver driver) {
                this.currentTitle = driver.getTitle();
                return this.currentTitle != null && this.currentTitle.contains(title);
            }

            public String toString() {
                return String.format("title to contain \"%s\". Current title: \"%s\"", title, this.currentTitle);
            }
        };
    }

    public static ExpectedCondition<Boolean> urlToBe(final String url) {
        return new ExpectedCondition<Boolean>(){
            private String currentUrl = "";

            public Boolean apply(WebDriver driver) {
                this.currentUrl = driver.getCurrentUrl();
                return this.currentUrl != null && this.currentUrl.equals(url);
            }

            public String toString() {
                return String.format("url to be \"%s\". Current url: \"%s\"", url, this.currentUrl);
            }
        };
    }

    public static ExpectedCondition<Boolean> urlContains(final String fraction) {
        return new ExpectedCondition<Boolean>(){
            private String currentUrl = "";

            public Boolean apply(WebDriver driver) {
                this.currentUrl = driver.getCurrentUrl();
                return this.currentUrl != null && this.currentUrl.contains(fraction);
            }

            public String toString() {
                return String.format("url to contain \"%s\". Current url: \"%s\"", fraction, this.currentUrl);
            }
        };
    }

    public static ExpectedCondition<Boolean> urlMatches(final String regex) {
        return new ExpectedCondition<Boolean>(){
            private String currentUrl;
            private Pattern pattern;
            private Matcher matcher;

            public Boolean apply(WebDriver driver) {
                this.currentUrl = driver.getCurrentUrl();
                this.pattern = Pattern.compile(regex);
                this.matcher = this.pattern.matcher(this.currentUrl);
                return this.matcher.find();
            }

            public String toString() {
                return String.format("url to match the regex \"%s\". Current url: \"%s\"", regex, this.currentUrl);
            }
        };
    }

    public static ExpectedCondition<WebElement> presenceOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                return ExpectedConditions.findElement(locator, driver);
            }

            public String toString() {
                return "presence of element located by: " + locator;
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                try {
                    return ExpectedConditions.elementIfVisible(ExpectedConditions.findElement(locator, driver));
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return "visibility of element located by " + locator;
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfAllElementsLocatedBy(final By locator) {
        return new ExpectedCondition<List<WebElement>>(){

            public List<WebElement> apply(WebDriver driver) {
                List elements = ExpectedConditions.findElements(locator, driver);
                for (WebElement element : elements) {
                    if (element.isDisplayed()) continue;
                    return null;
                }
                return elements.size() > 0 ? elements : null;
            }

            public String toString() {
                return "visibility of all elements located by " + locator;
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfAllElements(final List<WebElement> elements) {
        return new ExpectedCondition<List<WebElement>>(){

            public List<WebElement> apply(WebDriver driver) {
                for (WebElement element : elements) {
                    if (element.isDisplayed()) continue;
                    return null;
                }
                return elements.size() > 0 ? elements : null;
            }

            public String toString() {
                return "visibility of all " + elements;
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOf(final WebElement element) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                return ExpectedConditions.elementIfVisible(element);
            }

            public String toString() {
                return "visibility of " + element;
            }
        };
    }

    private static WebElement elementIfVisible(WebElement element) {
        return element.isDisplayed() ? element : null;
    }

    public static ExpectedCondition<List<WebElement>> presenceOfAllElementsLocatedBy(final By locator) {
        return new ExpectedCondition<List<WebElement>>(){

            public List<WebElement> apply(WebDriver driver) {
                List elements = ExpectedConditions.findElements(locator, driver);
                return elements.size() > 0 ? elements : null;
            }

            public String toString() {
                return "presence of any elements located by " + locator;
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElement(final WebElement element, final String text) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = element.getText();
                    return elementText.contains(text);
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("text ('%s') to be present in element %s", text, element);
            }
        };
    }

    @Deprecated
    public static ExpectedCondition<Boolean> textToBePresentInElement(By locator, String text) {
        return ExpectedConditions.textToBePresentInElementLocated(locator, text);
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementLocated(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = ExpectedConditions.findElement(locator, driver).getText();
                    return elementText.contains(text);
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("text ('%s') to be present in element found by %s", text, locator);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementValue(final WebElement element, final String text) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = element.getAttribute("value");
                    if (elementText != null) {
                        return elementText.contains(text);
                    }
                    return false;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("text ('%s') to be the value of element %s", text, element);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementValue(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    String elementText = ExpectedConditions.findElement(locator, driver).getAttribute("value");
                    if (elementText != null) {
                        return elementText.contains(text);
                    }
                    return false;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("text ('%s') to be the value of element located by %s", text, locator);
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final String frameLocator) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(frameLocator);
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
            }

            public String toString() {
                return "frame to be available: " + frameLocator;
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final By locator) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(ExpectedConditions.findElement(locator, driver));
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
            }

            public String toString() {
                return "frame to be available: " + locator;
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final int frameLocator) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(frameLocator);
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
            }

            public String toString() {
                return "frame to be available: " + frameLocator;
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final WebElement frameLocator) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(frameLocator);
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
            }

            public String toString() {
                return "frame to be available: " + frameLocator;
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return !ExpectedConditions.findElement(locator, driver).isDisplayed();
                }
                catch (NoSuchElementException e) {
                    return true;
                }
                catch (StaleElementReferenceException e) {
                    return true;
                }
            }

            public String toString() {
                return "element to no longer be visible: " + locator;
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfElementWithText(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return !ExpectedConditions.findElement(locator, driver).getText().equals(text);
                }
                catch (NoSuchElementException e) {
                    return true;
                }
                catch (StaleElementReferenceException e) {
                    return true;
                }
            }

            public String toString() {
                return String.format("element containing '%s' to no longer be visible: %s", text, locator);
            }
        };
    }

    public static ExpectedCondition<WebElement> elementToBeClickable(final By locator) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement element = (WebElement)ExpectedConditions.visibilityOfElementLocated(locator).apply(driver);
                try {
                    if (element != null && element.isEnabled()) {
                        return element;
                    }
                    return null;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return "element to be clickable: " + locator;
            }
        };
    }

    public static ExpectedCondition<WebElement> elementToBeClickable(final WebElement element) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement visibleElement = (WebElement)ExpectedConditions.visibilityOf(element).apply(driver);
                try {
                    if (visibleElement != null && visibleElement.isEnabled()) {
                        return visibleElement;
                    }
                    return null;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return "element to be clickable: " + element;
            }
        };
    }

    public static ExpectedCondition<Boolean> stalenessOf(final WebElement element) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver ignored) {
                try {
                    element.isEnabled();
                    return false;
                }
                catch (StaleElementReferenceException expected) {
                    return true;
                }
            }

            public String toString() {
                return String.format("element (%s) to become stale", element);
            }
        };
    }

    public static <T> ExpectedCondition<T> refreshed(final ExpectedCondition<T> condition) {
        return new ExpectedCondition<T>(){

            public T apply(WebDriver driver) {
                try {
                    return condition.apply(driver);
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("condition (%s) to be refreshed", condition);
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(WebElement element) {
        return ExpectedConditions.elementSelectionStateToBe(element, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final WebElement element, final boolean selected) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return element.isSelected() == selected;
            }

            public String toString() {
                return String.format("element (%s) to %sbe selected", element, selected ? "" : "not ");
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(By locator) {
        return ExpectedConditions.elementSelectionStateToBe(locator, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final By locator, final boolean selected) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    WebElement element = ExpectedConditions.findElement(locator, driver);
                    return element.isSelected() == selected;
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("element found by %s to %sbe selected", locator, selected ? "" : "not ");
            }
        };
    }

    public static ExpectedCondition<Alert> alertIsPresent() {
        return new ExpectedCondition<Alert>(){

            public Alert apply(WebDriver driver) {
                try {
                    return driver.switchTo().alert();
                }
                catch (NoAlertPresentException e) {
                    return null;
                }
            }

            public String toString() {
                return "alert to be present";
            }
        };
    }

    @Deprecated
    public static ExpectedCondition<Boolean> numberOfwindowsToBe(int expectedNumberOfWindows) {
        return ExpectedConditions.numberOfWindowsToBe(expectedNumberOfWindows);
    }

    public static ExpectedCondition<Boolean> numberOfWindowsToBe(final int expectedNumberOfWindows) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return driver.getWindowHandles().size() == expectedNumberOfWindows;
                }
                catch (WebDriverException e) {
                    return null;
                }
            }

            public String toString() {
                return "number of open windows to be " + expectedNumberOfWindows;
            }
        };
    }

    public static ExpectedCondition<Boolean> not(final ExpectedCondition<?> condition) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                Object result = condition.apply(driver);
                return result == null || result == Boolean.FALSE;
            }

            public String toString() {
                return "condition to not be valid: " + condition;
            }
        };
    }

    private static WebElement findElement(By by, WebDriver driver) {
        try {
            return (WebElement)driver.findElements(by).stream().findFirst().orElseThrow(() -> new NoSuchElementException("Cannot locate an element using " + by));
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (WebDriverException e) {
            log.log(Level.WARNING, String.format("WebDriverException thrown by findElement(%s)", by), e);
            throw e;
        }
    }

    private static List<WebElement> findElements(By by, WebDriver driver) {
        try {
            return driver.findElements(by);
        }
        catch (WebDriverException e) {
            log.log(Level.WARNING, String.format("WebDriverException thrown by findElements(%s)", by), e);
            throw e;
        }
    }

    public static ExpectedCondition<Boolean> attributeToBe(final By locator, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            public Boolean apply(WebDriver driver) {
                WebElement element = ExpectedConditions.findElement(locator, driver);
                this.currentValue = element.getAttribute(attribute);
                if (this.currentValue == null || this.currentValue.isEmpty()) {
                    this.currentValue = element.getCssValue(attribute);
                }
                return value.equals(this.currentValue);
            }

            public String toString() {
                return String.format("value to be \"%s\". Current value: \"%s\"", value, this.currentValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBe(final By locator, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            public Boolean apply(WebDriver driver) {
                try {
                    this.currentValue = ExpectedConditions.findElement(locator, driver).getText();
                    return this.currentValue.equals(value);
                }
                catch (Exception e) {
                    return false;
                }
            }

            public String toString() {
                return String.format("text to be \"%s\". Current text: \"%s\"", value, this.currentValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> textMatches(final By locator, final Pattern pattern) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            public Boolean apply(WebDriver driver) {
                try {
                    this.currentValue = ExpectedConditions.findElement(locator, driver).getText();
                    return pattern.matcher(this.currentValue).find();
                }
                catch (Exception e) {
                    return false;
                }
            }

            public String toString() {
                return String.format("text to match pattern \"%s\". Current text: \"%s\"", pattern.pattern(), this.currentValue);
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> numberOfElementsToBeMoreThan(final By locator, final Integer number) {
        return new ExpectedCondition<List<WebElement>>(){
            private Integer currentNumber = 0;

            public List<WebElement> apply(WebDriver webDriver) {
                List elements = ExpectedConditions.findElements(locator, webDriver);
                this.currentNumber = elements.size();
                return this.currentNumber > number ? elements : null;
            }

            public String toString() {
                return String.format("number to be more than \"%s\". Current number: \"%s\"", number, this.currentNumber);
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> numberOfElementsToBeLessThan(final By locator, final Integer number) {
        return new ExpectedCondition<List<WebElement>>(){
            private Integer currentNumber = 0;

            public List<WebElement> apply(WebDriver webDriver) {
                List elements = ExpectedConditions.findElements(locator, webDriver);
                this.currentNumber = elements.size();
                return this.currentNumber < number ? elements : null;
            }

            public String toString() {
                return String.format("number to be less than \"%s\". Current number: \"%s\"", number, this.currentNumber);
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> numberOfElementsToBe(final By locator, final Integer number) {
        return new ExpectedCondition<List<WebElement>>(){
            private Integer currentNumber = 0;

            public List<WebElement> apply(WebDriver webDriver) {
                List elements = ExpectedConditions.findElements(locator, webDriver);
                this.currentNumber = elements.size();
                return this.currentNumber.equals(number) ? elements : null;
            }

            public String toString() {
                return String.format("number to be \"%s\". Current number: \"%s\"", number, this.currentNumber);
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeToBe(final WebElement element, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            public Boolean apply(WebDriver driver) {
                this.currentValue = element.getAttribute(attribute);
                if (this.currentValue == null || this.currentValue.isEmpty()) {
                    this.currentValue = element.getCssValue(attribute);
                }
                return value.equals(this.currentValue);
            }

            public String toString() {
                return String.format(attribute + " to be \"%s\". Current " + attribute + ": \"%s\"", value, this.currentValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeContains(final WebElement element, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            public Boolean apply(WebDriver driver) {
                return ExpectedConditions.getAttributeOrCssValue(element, attribute).map(seen -> seen.contains(value)).orElse(false);
            }

            public String toString() {
                return String.format("value to contain \"%s\". Current value: \"%s\"", value, this.currentValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeContains(final By locator, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){
            private String currentValue = null;

            public Boolean apply(WebDriver driver) {
                return ExpectedConditions.getAttributeOrCssValue(ExpectedConditions.findElement(locator, driver), attribute).map(seen -> seen.contains(value)).orElse(false);
            }

            public String toString() {
                return String.format("value to contain \"%s\". Current value: \"%s\"", value, this.currentValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeToBeNotEmpty(WebElement element, String attribute) {
        return driver -> ExpectedConditions.getAttributeOrCssValue(element, attribute).isPresent();
    }

    private static Optional<String> getAttributeOrCssValue(WebElement element, String name) {
        String value = element.getAttribute(name);
        if (value == null || value.isEmpty()) {
            value = element.getCssValue(name);
        }
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfNestedElementsLocatedBy(final By parent, final By childLocator) {
        return new ExpectedCondition<List<WebElement>>(){

            public List<WebElement> apply(WebDriver driver) {
                WebElement current = ExpectedConditions.findElement(parent, driver);
                List<WebElement> allChildren = current.findElements(childLocator);
                if (!allChildren.isEmpty() && allChildren.get(0).isDisplayed()) {
                    return allChildren;
                }
                return null;
            }

            public String toString() {
                return String.format("visibility of elements located by %s -> %s", parent, childLocator);
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> visibilityOfNestedElementsLocatedBy(final WebElement element, final By childLocator) {
        return new ExpectedCondition<List<WebElement>>(){

            public List<WebElement> apply(WebDriver webDriver) {
                List<WebElement> allChildren = element.findElements(childLocator);
                if (!allChildren.isEmpty() && allChildren.get(0).isDisplayed()) {
                    return allChildren;
                }
                return null;
            }

            public String toString() {
                return String.format("visibility of element located by %s -> %s", element, childLocator);
            }
        };
    }

    public static ExpectedCondition<WebElement> presenceOfNestedElementLocatedBy(final By locator, final By childLocator) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver webDriver) {
                return webDriver.findElement(locator).findElement(childLocator);
            }

            public String toString() {
                return String.format("visibility of element located by %s -> %s", locator, childLocator);
            }
        };
    }

    public static ExpectedCondition<WebElement> presenceOfNestedElementLocatedBy(final WebElement element, final By childLocator) {
        return new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver webDriver) {
                return element.findElement(childLocator);
            }

            public String toString() {
                return String.format("visibility of element located by %s", childLocator);
            }
        };
    }

    public static ExpectedCondition<List<WebElement>> presenceOfNestedElementsLocatedBy(final By parent, final By childLocator) {
        return new ExpectedCondition<List<WebElement>>(){

            public List<WebElement> apply(WebDriver driver) {
                List<WebElement> allChildren = ExpectedConditions.findElement(parent, driver).findElements(childLocator);
                return allChildren.isEmpty() ? null : allChildren;
            }

            public String toString() {
                return String.format("visibility of element located by %s -> %s", parent, childLocator);
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfAllElements(final List<WebElement> elements) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver webDriver) {
                return elements.stream().allMatch(x$0 -> ExpectedConditions.isInvisible(x$0));
            }

            public String toString() {
                return "invisibility of all elements " + elements;
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOf(final WebElement element) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver webDriver) {
                return ExpectedConditions.isInvisible(element);
            }

            public String toString() {
                return "invisibility of " + element;
            }
        };
    }

    private static boolean isInvisible(WebElement element) {
        try {
            return !element.isDisplayed();
        }
        catch (StaleElementReferenceException ignored) {
            return true;
        }
    }

    public static ExpectedCondition<Boolean> or(final ExpectedCondition<?> ... conditions) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                RuntimeException lastException = null;
                for (ExpectedCondition condition : conditions) {
                    try {
                        Object result = condition.apply(driver);
                        if (result == null) continue;
                        if (result instanceof Boolean) {
                            if (!Boolean.TRUE.equals(result)) continue;
                            return true;
                        }
                        return true;
                    }
                    catch (RuntimeException e) {
                        lastException = e;
                    }
                }
                if (lastException != null) {
                    throw lastException;
                }
                return false;
            }

            public String toString() {
                StringBuilder message = new StringBuilder("at least one condition to be valid: ");
                Joiner.on((String)" || ").appendTo(message, (Object[])conditions);
                return message.toString();
            }
        };
    }

    public static ExpectedCondition<Boolean> and(final ExpectedCondition<?> ... conditions) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                for (ExpectedCondition condition : conditions) {
                    Object result = condition.apply(driver);
                    if (result instanceof Boolean && Boolean.FALSE.equals(result)) {
                        return false;
                    }
                    if (result != null) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                StringBuilder message = new StringBuilder("all conditions to be valid: ");
                Joiner.on((String)" && ").appendTo(message, (Object[])conditions);
                return message.toString();
            }
        };
    }

    public static ExpectedCondition<Boolean> javaScriptThrowsNoExceptions(final String javaScript) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    ((JavascriptExecutor)((Object)driver)).executeScript(javaScript, new Object[0]);
                    return true;
                }
                catch (WebDriverException e) {
                    return false;
                }
            }

            public String toString() {
                return String.format("js %s to be executable", javaScript);
            }
        };
    }

    public static ExpectedCondition<Object> jsReturnsValue(final String javaScript) {
        return new ExpectedCondition<Object>(){

            public Object apply(WebDriver driver) {
                try {
                    Object value = ((JavascriptExecutor)((Object)driver)).executeScript(javaScript, new Object[0]);
                    if (value instanceof List) {
                        return ((List)value).isEmpty() ? null : value;
                    }
                    if (value instanceof String) {
                        return ((String)value).isEmpty() ? null : value;
                    }
                    return value;
                }
                catch (WebDriverException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("js %s to be executable", javaScript);
            }
        };
    }
}

