/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import org.seleniumhq.jetty9.jmx.MBeanContainer;
import org.seleniumhq.jetty9.util.Loader;
import org.seleniumhq.jetty9.util.TypeUtil;
import org.seleniumhq.jetty9.util.annotation.ManagedAttribute;
import org.seleniumhq.jetty9.util.annotation.ManagedObject;
import org.seleniumhq.jetty9.util.annotation.ManagedOperation;
import org.seleniumhq.jetty9.util.annotation.Name;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;

public class ObjectMBean
implements DynamicMBean {
    private static final Logger LOG = Log.getLogger(ObjectMBean.class);
    private static Class<?>[] OBJ_ARG = new Class[]{Object.class};
    protected Object _managed;
    private MBeanInfo _info;
    private Map<String, Method> _getters = new HashMap<String, Method>();
    private Map<String, Method> _setters = new HashMap<String, Method>();
    private Map<String, Method> _methods = new HashMap<String, Method>();
    private Set<String> _attributes = new HashSet<String>();
    private Set<String> _convert = new HashSet<String>();
    private ClassLoader _loader;
    private MBeanContainer _mbeanContainer;
    private static String OBJECT_NAME_CLASS = ObjectName.class.getName();
    private static String OBJECT_NAME_ARRAY_CLASS = ObjectName[].class.getName();

    public static Object mbeanFor(Object o) {
        try {
            Object mbean = null;
            for (Class<Object> oClass = o.getClass(); mbean == null && oClass != null; oClass = oClass.getSuperclass()) {
                String pName = oClass.getPackage().getName();
                String cName = oClass.getName().substring(pName.length() + 1);
                String mName = pName + ".jmx." + cName + "MBean";
                try {
                    block15: {
                        Class<Object> mClass;
                        try {
                            mClass = Object.class.equals(oClass) ? (oClass = ObjectMBean.class) : Loader.loadClass(oClass, mName);
                        }
                        catch (ClassNotFoundException e) {
                            if (Thread.currentThread().getContextClassLoader() == oClass.getClassLoader()) {
                                throw e;
                            }
                            LOG.ignore(e);
                            mClass = Loader.loadClass(oClass, mName);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("ObjectMbean: mbeanFor {} mClass={}", o, mClass);
                        }
                        try {
                            Constructor constructor = mClass.getConstructor(OBJ_ARG);
                            mbean = constructor.newInstance(o);
                        }
                        catch (Exception e) {
                            LOG.ignore(e);
                            if (!ModelMBean.class.isAssignableFrom(mClass)) break block15;
                            mbean = mClass.newInstance();
                            ((ModelMBean)mbean).setManagedResource(o, "objectReference");
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("mbeanFor {} is {}", o, mbean);
                    }
                    return mbean;
                }
                catch (ClassNotFoundException e) {
                    if (e.getMessage().contains(mName)) {
                        LOG.ignore(e);
                        continue;
                    }
                    LOG.warn(e);
                    continue;
                }
                catch (Error e) {
                    LOG.warn(e);
                    mbean = null;
                    continue;
                }
                catch (Exception e) {
                    LOG.warn(e);
                    mbean = null;
                }
            }
        }
        catch (Exception e) {
            LOG.ignore(e);
        }
        return null;
    }

    public ObjectMBean(Object managedObject) {
        this._managed = managedObject;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public Object getManagedObject() {
        return this._managed;
    }

    public ObjectName getObjectName() {
        return null;
    }

    public String getObjectContextBasis() {
        return null;
    }

    public String getObjectNameBasis() {
        return null;
    }

    protected void setMBeanContainer(MBeanContainer container) {
        this._mbeanContainer = container;
    }

    public MBeanContainer getMBeanContainer() {
        return this._mbeanContainer;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            if (this._info == null) {
                ManagedObject primary;
                String desc = null;
                ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
                ArrayList constructors = new ArrayList();
                ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
                ArrayList notifications = new ArrayList();
                Class<?> o_class = this._managed.getClass();
                List<Class<?>> influences = new ArrayList();
                influences.add(this.getClass());
                influences = ObjectMBean.findInfluences(influences, this._managed.getClass());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Influence Count: {}", influences.size());
                }
                if ((primary = o_class.getAnnotation(ManagedObject.class)) != null) {
                    desc = primary.value();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("No @ManagedObject declared on {}", this._managed.getClass());
                }
                for (int i = 0; i < influences.size(); ++i) {
                    Class<?> oClass = influences.get(i);
                    ManagedObject typeAnnotation = oClass.getAnnotation(ManagedObject.class);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Influenced by: " + oClass.getCanonicalName(), new Object[0]);
                    }
                    if (typeAnnotation == null) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Annotations not found for: {}", oClass.getCanonicalName());
                        continue;
                    }
                    for (Method method : oClass.getDeclaredMethods()) {
                        MBeanOperationInfo oi;
                        ManagedOperation methodOperationAnnotation;
                        ManagedAttribute methodAttributeAnnotation = method.getAnnotation(ManagedAttribute.class);
                        if (methodAttributeAnnotation != null) {
                            MBeanAttributeInfo mai;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Attribute Annotation found for: {}", method.getName());
                            }
                            if ((mai = this.defineAttribute(method, methodAttributeAnnotation)) != null) {
                                attributes.add(mai);
                            }
                        }
                        if ((methodOperationAnnotation = method.getAnnotation(ManagedOperation.class)) == null) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Method Annotation found for: {}", method.getName());
                        }
                        if ((oi = this.defineOperation(method, methodOperationAnnotation)) == null) continue;
                        operations.add(oi);
                    }
                }
                this._info = new MBeanInfo(o_class.getName(), desc, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), constructors.toArray(new MBeanConstructorInfo[constructors.size()]), operations.toArray(new MBeanOperationInfo[operations.size()]), notifications.toArray(new MBeanNotificationInfo[notifications.size()]));
            }
        }
        catch (RuntimeException e) {
            LOG.warn(e);
            throw e;
        }
        return this._info;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method getter = this._getters.get(name);
        if (getter == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            ObjectName[] r;
            Object o = this._managed;
            if (getter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((r = getter.invoke(o, (Object[])null)) != null) {
                if (r.getClass().isArray()) {
                    if (r.getClass().getComponentType().isAnnotationPresent(ManagedObject.class)) {
                        ObjectName[] on = new ObjectName[Array.getLength(r)];
                        for (int i = 0; i < on.length; ++i) {
                            on[i] = this._mbeanContainer.findMBean(Array.get(r, i));
                        }
                        r = on;
                    }
                } else if (r instanceof Collection) {
                    Collection c = (Collection)r;
                    if (!c.isEmpty() && c.iterator().next().getClass().isAnnotationPresent(ManagedObject.class)) {
                        ObjectName[] on = new ObjectName[c.size()];
                        int i = 0;
                        for (Object obj : c) {
                            on[i++] = this._mbeanContainer.findMBean(obj);
                        }
                        r = on;
                    }
                } else {
                    for (Class<?> clazz = r.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                        if (!clazz.isAnnotationPresent(ManagedObject.class)) continue;
                        ObjectName mbean = this._mbeanContainer.findMBean(r);
                        if (mbean != null) {
                            return mbean;
                        }
                        return null;
                    }
                }
            }
            return r;
        }
        catch (IllegalAccessException e) {
            LOG.warn("EXCEPTION ", e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            LOG.warn("EXCEPTION ", e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList results = new AttributeList(names.length);
        for (int i = 0; i < names.length; ++i) {
            try {
                results.add(new Attribute(names[i], this.getAttribute(names[i])));
                continue;
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", e);
            }
        }
        return results;
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method setter;
        if (attr == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setAttribute " + this._managed + ":" + attr.getName() + "=" + attr.getValue(), new Object[0]);
        }
        if ((setter = this._setters.get(attr.getName())) == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        try {
            Object value;
            Object o = this._managed;
            if (setter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((value = attr.getValue()) != null && this._convert.contains(attr.getName())) {
                if (value.getClass().isArray()) {
                    Class<?> t = setter.getParameterTypes()[0].getComponentType();
                    Object na = Array.newInstance(t, Array.getLength(value));
                    int i = Array.getLength(value);
                    while (i-- > 0) {
                        Array.set(na, i, this._mbeanContainer.findBean((ObjectName)Array.get(value, i)));
                    }
                    value = na;
                } else {
                    value = this._mbeanContainer.findBean((ObjectName)value);
                }
            }
            setter.invoke(o, value);
        }
        catch (IllegalAccessException e) {
            LOG.warn("EXCEPTION ", e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            LOG.warn("EXCEPTION ", e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attrs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setAttributes", new Object[0]);
        }
        AttributeList results = new AttributeList(attrs.size());
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            try {
                Attribute attr = (Attribute)iter.next();
                this.setAttribute(attr);
                results.add(new Attribute(attr.getName(), this.getAttribute(attr.getName())));
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", e);
            }
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ObjectMBean:invoke " + name, new Object[0]);
        }
        String methodKey = name + "(";
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                methodKey = methodKey + (i > 0 ? "," : "") + signature[i];
            }
        }
        methodKey = methodKey + ")";
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._loader);
            Method method = this._methods.get(methodKey);
            if (method == null) {
                throw new NoSuchMethodException(methodKey);
            }
            Object o = this._managed;
            if (method.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            Object object = method.invoke(o, params);
            return object;
        }
        catch (NoSuchMethodException e) {
            LOG.warn("EXCEPTION ", e);
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            LOG.warn("EXCEPTION ", e);
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            LOG.warn("EXCEPTION ", e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    private static List<Class<?>> findInfluences(List<Class<?>> influences, Class<?> aClass) {
        if (aClass != null) {
            if (!influences.contains(aClass)) {
                influences.add(aClass);
            }
            influences = ObjectMBean.findInfluences(influences, aClass.getSuperclass());
            Class<?>[] ifs = aClass.getInterfaces();
            for (int i = 0; ifs != null && i < ifs.length; ++i) {
                influences = ObjectMBean.findInfluences(influences, ifs[i]);
            }
        }
        return influences;
    }

    public MBeanAttributeInfo defineAttribute(Method method, ManagedAttribute attributeAnnotation) {
        Class<?> oClass;
        Class<?> return_type;
        String name = attributeAnnotation.name();
        if ("".equals(name)) {
            name = this.toVariableName(method.getName());
        }
        if (this._attributes.contains(name)) {
            return null;
        }
        String description = attributeAnnotation.value();
        boolean readonly = attributeAnnotation.readonly();
        boolean onMBean = attributeAnnotation.proxied();
        boolean convert = false;
        Class<?> component_type = return_type = method.getReturnType();
        while (component_type.isArray()) {
            component_type = component_type.getComponentType();
        }
        convert = this.isAnnotationPresent(component_type, ManagedObject.class);
        String uName = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        Class<?> clazz = oClass = onMBean ? this.getClass() : this._managed.getClass();
        if (LOG.isDebugEnabled()) {
            LOG.debug("defineAttribute {} {}:{}:{}:{}", name, onMBean, readonly, oClass, description);
        }
        Method setter = null;
        if (!readonly) {
            String declaredSetter = attributeAnnotation.setter();
            if (LOG.isDebugEnabled()) {
                LOG.debug("DeclaredSetter: {}", declaredSetter);
            }
            Method[] methods = oClass.getMethods();
            for (int m = 0; m < methods.length; ++m) {
                if ((methods[m].getModifiers() & 1) == 0) continue;
                if (!"".equals(declaredSetter) && methods[m].getName().equals(declaredSetter) && methods[m].getParameterCount() == 1) {
                    if (setter != null) {
                        LOG.warn("Multiple setters for mbean attr {} in {}", name, oClass);
                        continue;
                    }
                    setter = methods[m];
                    if (!component_type.equals(methods[m].getParameterTypes()[0])) {
                        LOG.warn("Type conflict for mbean attr {} in {}", name, oClass);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Declared Setter: " + declaredSetter, new Object[0]);
                    }
                }
                if (!methods[m].getName().equals("set" + uName) || methods[m].getParameterCount() != 1) continue;
                if (setter != null) {
                    LOG.warn("Multiple setters for mbean attr {} in {}", name, oClass);
                    continue;
                }
                setter = methods[m];
                if (return_type.equals(methods[m].getParameterTypes()[0])) continue;
                LOG.warn("Type conflict for mbean attr {} in {}", name, oClass);
            }
        }
        if (convert) {
            if (component_type == null) {
                LOG.warn("No mbean type for {} on {}", name, this._managed.getClass());
                return null;
            }
            if (component_type.isPrimitive() && !component_type.isArray()) {
                LOG.warn("Cannot convert mbean primative {}", name);
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("passed convert checks {} for type {}", name, component_type);
            }
        }
        try {
            this._getters.put(name, method);
            this._setters.put(name, setter);
            MBeanAttributeInfo info = null;
            if (convert) {
                this._convert.add(name);
                info = component_type.isArray() ? new MBeanAttributeInfo(name, OBJECT_NAME_ARRAY_CLASS, description, true, setter != null, method.getName().startsWith("is")) : new MBeanAttributeInfo(name, OBJECT_NAME_CLASS, description, true, setter != null, method.getName().startsWith("is"));
            } else {
                info = new MBeanAttributeInfo(name, description, method, setter);
            }
            this._attributes.add(name);
            return info;
        }
        catch (Exception e) {
            LOG.warn(e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    private MBeanOperationInfo defineOperation(Method method, ManagedOperation methodAnnotation) {
        String description = methodAnnotation.value();
        boolean onMBean = methodAnnotation.proxied();
        boolean convert = false;
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("returnType is array, get component type", new Object[0]);
            }
            returnType = returnType.getComponentType();
        }
        if (returnType.isAnnotationPresent(ManagedObject.class)) {
            convert = true;
        }
        String impactName = methodAnnotation.impact();
        if (LOG.isDebugEnabled()) {
            LOG.debug("defineOperation {} {}:{}:{}", method.getName(), onMBean, impactName, description);
        }
        String signature = method.getName();
        try {
            int i;
            int impact = 3;
            if (impactName == null || impactName.equals("UNKNOWN")) {
                impact = 3;
            } else if (impactName.equals("ACTION")) {
                impact = 1;
            } else if (impactName.equals("INFO")) {
                impact = 0;
            } else if (impactName.equals("ACTION_INFO")) {
                impact = 2;
            } else {
                LOG.warn("Unknown impact '" + impactName + "' for " + signature, new Object[0]);
            }
            Annotation[][] allParameterAnnotations = method.getParameterAnnotations();
            Class<?>[] methodTypes = method.getParameterTypes();
            MBeanParameterInfo[] pInfo = new MBeanParameterInfo[allParameterAnnotations.length];
            for (i = 0; i < allParameterAnnotations.length; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation anno : parameterAnnotations = allParameterAnnotations[i]) {
                    if (!(anno instanceof Name)) continue;
                    Name nameAnnotation = (Name)anno;
                    pInfo[i] = new MBeanParameterInfo(nameAnnotation.value(), methodTypes[i].getName(), nameAnnotation.description());
                }
            }
            signature = signature + "(";
            for (i = 0; i < methodTypes.length; ++i) {
                signature = signature + methodTypes[i].getName();
                if (i == methodTypes.length - 1) continue;
                signature = signature + ",";
            }
            signature = signature + ")";
            Class<?> returnClass = method.getReturnType();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method Cache: " + signature, new Object[0]);
            }
            if (this._methods.containsKey(signature)) {
                return null;
            }
            this._methods.put(signature, method);
            if (convert) {
                this._convert.add(signature);
            }
            return new MBeanOperationInfo(method.getName(), description, pInfo, returnClass.isPrimitive() ? TypeUtil.toName(returnClass) : returnClass.getName(), impact);
        }
        catch (Exception e) {
            LOG.warn("Operation '" + signature + "'", e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    protected String toVariableName(String methodName) {
        String variableName = methodName;
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            variableName = variableName.substring(3);
        } else if (methodName.startsWith("is")) {
            variableName = variableName.substring(2);
        }
        variableName = variableName.substring(0, 1).toLowerCase(Locale.ENGLISH) + variableName.substring(1);
        return variableName;
    }

    protected boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
        for (Class<?> test2 = clazz; test2 != null; test2 = test2.getSuperclass()) {
            if (!test2.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }
}

