/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.bili.live.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import top.mrxiaom.bili.live.client.BApi;
import top.mrxiaom.bili.live.client.BApiClient;
import top.mrxiaom.bili.live.client.data.EmptyInfo;
import top.mrxiaom.bili.live.runtime.data.Dm;
import top.mrxiaom.bili.live.runtime.data.Guard;
import top.mrxiaom.bili.live.runtime.data.Like;
import top.mrxiaom.bili.live.runtime.data.Packet;
import top.mrxiaom.bili.live.runtime.data.PacketHeader;
import top.mrxiaom.bili.live.runtime.data.SendGift;
import top.mrxiaom.bili.live.runtime.data.SuperChat;
import top.mrxiaom.bili.live.runtime.data.SuperChatDel;

public abstract class BLiveClient {
    protected final Logger logger;
    protected Timer projectTimer = null;
    protected Timer timer = null;
    protected long heartbeatTimeWs = 30000L;
    protected long heartbeatTime = 20000L;
    protected String token;
    public final String gameId;

    public BLiveClient(Logger logger, String gameId) {
        this.logger = logger;
        this.gameId = gameId;
    }

    public abstract boolean getStatus();

    public abstract void onOpen();

    public abstract void onReceivedDanmaku(Dm var1);

    public abstract void onReceivedGift(SendGift var1);

    public abstract void onReceivedGuardBuy(Guard var1);

    public abstract void onReceivedSuperChat(SuperChat var1);

    public abstract void onReceivedSuperChatDel(SuperChatDel var1);

    public abstract void onReceivedLike(Like var1);

    public abstract void onReceivedRawNotice(String var1, JsonObject var2);

    public abstract void onPopularityUpdate(int var1);

    public void connect() {
        if (this.projectTimer != null) {
            this.projectTimer.cancel();
        }
        this.projectTimer = new Timer();
        this.projectTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BLiveClient.this.sendProjectHeartbeat();
            }
        }, 0L, this.heartbeatTime);
    }

    public void disconnect() {
        if (this.projectTimer != null) {
            this.projectTimer.cancel();
            this.projectTimer = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public abstract void close();

    public abstract void send(byte[] var1);

    public abstract void send(Packet var1);

    public void onOpenConnection() {
        this.send(Packet.authority(this.token));
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (BLiveClient.this.getStatus()) {
                    BLiveClient.this.send(Packet.heartbeat());
                    BLiveClient.this.logger.info("\u957f\u8fde\u5fc3\u8df3\u6210\u529f");
                }
            }
        }, 0L, this.heartbeatTimeWs);
    }

    protected void sendProjectHeartbeat() {
        EmptyInfo result = BApiClient.heartBeatInteractivePlay(this.gameId);
        if (result.code != 0) {
            this.logger.warning("\u9879\u76ee\u5fc3\u8df3\u5931\u8d25, code=" + result.code + ", message=" + result.message);
        } else {
            this.logger.info("\u9879\u76ee\u5fc3\u8df3\u6210\u529f");
        }
    }

    protected void processPacket(Packet packet) {
        PacketHeader header = packet.header;
        switch (header.protocolVersion) {
            case UnCompressed: 
            case HeartBeat: {
                break;
            }
            case Zlib: {
                return;
            }
            case Brotli: {
                return;
            }
            default: {
                throw new UnsupportedOperationException("New bilibili danmaku protocol appears, please contact the author if you see this Exception.");
            }
        }
        switch (header.operation) {
            case AuthorityResponse: {
                this.onOpen();
                break;
            }
            case HeartBeatResponse: {
                int i = 0;
                for (int j = packet.packetBody.length - 1; i < j; ++i, --j) {
                    byte tmp = packet.packetBody[i];
                    packet.packetBody[i] = packet.packetBody[j];
                    packet.packetBody[j] = tmp;
                }
                int popularity = BLiveClient.bytesToInt(packet.packetBody, 0);
                this.onPopularityUpdate(popularity);
                break;
            }
            case ServerNotify: {
                this.processNotice(new String(packet.packetBody, StandardCharsets.UTF_8));
            }
        }
    }

    protected void processNotice(String rawMessage) {
        JsonObject json = new JsonParser().parse(rawMessage).getAsJsonObject();
        this.onReceivedRawNotice(rawMessage, json);
        JsonElement data = json.get("data");
        if (data == null) {
            return;
        }
        try {
            switch (json.get("cmd").getAsString()) {
                case "LIVE_OPEN_PLATFORM_DM": {
                    Dm dm = BApi.gson.fromJson(data, Dm.class);
                    this.onReceivedDanmaku(dm);
                    break;
                }
                case "LIVE_OPEN_PLATFORM_SUPER_CHAT": {
                    SuperChat superChat = BApi.gson.fromJson(data, SuperChat.class);
                    this.onReceivedSuperChat(superChat);
                    break;
                }
                case "LIVE_OPEN_PLATFORM_SUPER_CHAT_DEL": {
                    SuperChatDel superChatDel = BApi.gson.fromJson(data, SuperChatDel.class);
                    this.onReceivedSuperChatDel(superChatDel);
                    break;
                }
                case "LIVE_OPEN_PLATFORM_SEND_GIFT": {
                    SendGift gift = BApi.gson.fromJson(data, SendGift.class);
                    this.onReceivedGift(gift);
                    break;
                }
                case "LIVE_OPEN_PLATFORM_GUARD": {
                    Guard guard = BApi.gson.fromJson(data, Guard.class);
                    this.onReceivedGuardBuy(guard);
                    break;
                }
                case "LIVE_OPEN_PLATFORM_LIKE": {
                    Like like = BApi.gson.fromJson(data, Like.class);
                    this.onReceivedLike(like);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.printStackTrace(e);
        }
    }

    protected void printStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
        }
        this.logger.warning(sw.toString());
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }
}

