/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.bili.live.client;

import com.google.gson.JsonObject;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import top.mrxiaom.bili.live.client.BLiveClient;
import top.mrxiaom.bili.live.runtime.data.Dm;
import top.mrxiaom.bili.live.runtime.data.Guard;
import top.mrxiaom.bili.live.runtime.data.Like;
import top.mrxiaom.bili.live.runtime.data.Packet;
import top.mrxiaom.bili.live.runtime.data.SendGift;
import top.mrxiaom.bili.live.runtime.data.SuperChat;
import top.mrxiaom.bili.live.runtime.data.SuperChatDel;

public abstract class WebSocketBLiveClient
extends BLiveClient {
    private static final Map<Integer, String> codes = new HashMap<Integer, String>(){
        {
            this.put(1000, "NORMAL");
            this.put(1001, "GOING_AWAY");
            this.put(1002, "PROTOCOL_ERROR");
            this.put(1003, "REFUSE");
            this.put(1005, "NOCODE");
            this.put(1006, "ABNORMAL_CLOSE");
            this.put(1007, "NO_UTF8");
            this.put(1008, "POLICY_VALIDATION");
            this.put(1009, "TOOBIG");
            this.put(1010, "EXTENSION");
            this.put(1011, "UNEXPECTED_CONDITION");
            this.put(1012, "SERVICE_RESTART");
            this.put(1013, "TRY_AGAIN_LATER");
            this.put(1014, "BAD_GATEWAY");
            this.put(1015, "TLS_ERROR");
            this.put(-1, "NEVER_CONNECTED");
            this.put(-2, "BUGGYCLOSE");
            this.put(-3, "FLASHPOLICY");
        }
    };
    List<String> wssLink;
    WebSocketClient webSocketClient;

    public WebSocketBLiveClient(Logger logger, String gameId, List<String> wssLink, String token) {
        super(logger, gameId);
        this.wssLink = wssLink;
        this.token = token;
    }

    @Override
    public void connect() {
        String url = this.wssLink.get(0);
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalStateException("wsslink is invalid");
        }
        this.disconnect();
        super.connect();
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (Throwable t) {
            this.printStackTrace(t);
        }
        if (uri == null) {
            throw new IllegalStateException("Can't parse URI " + url);
        }
        this.webSocketClient = new WebSocketClient(uri){

            @Override
            public void onOpen(ServerHandshake ignored) {
                WebSocketBLiveClient.this.onOpenConnection();
            }

            @Override
            public void onMessage(ByteBuffer buffer) {
                WebSocketBLiveClient.this.processPacket(new Packet(buffer.array()));
            }

            @Override
            public void onMessage(String message) {
                WebSocketBLiveClient.this.logger.info(message);
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                if (code == 1000) {
                    WebSocketBLiveClient.this.logger.info("WS CLOSED" + (remote ? " (remote)" : "") + " " + reason);
                } else {
                    WebSocketBLiveClient.this.logger.warning("WS ERROR: " + (remote ? "(remote) " : "") + codes.getOrDefault(code, "UNKNOWN(" + code + ")") + " " + reason);
                }
            }

            @Override
            public void onError(Exception ex) {
                WebSocketBLiveClient.this.printStackTrace(ex);
            }
        };
        this.webSocketClient.connect();
    }

    @Override
    public boolean getStatus() {
        return this.webSocketClient != null && this.webSocketClient.isOpen();
    }

    @Override
    public void disconnect() {
        if (this.webSocketClient != null) {
            this.webSocketClient.close();
        }
        super.disconnect();
    }

    @Override
    public void close() {
        this.disconnect();
        System.gc();
    }

    @Override
    public void send(byte[] packet) {
        if (this.webSocketClient != null) {
            this.webSocketClient.send(packet);
        }
    }

    @Override
    public void send(Packet packet) {
        this.send(packet.toBytes());
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onReceivedDanmaku(Dm data) {
    }

    @Override
    public void onReceivedGift(SendGift data) {
    }

    @Override
    public void onReceivedGuardBuy(Guard data) {
    }

    @Override
    public void onReceivedSuperChat(SuperChat data) {
    }

    @Override
    public void onReceivedSuperChatDel(SuperChatDel data) {
    }

    @Override
    public void onReceivedLike(Like data) {
    }

    @Override
    public void onReceivedRawNotice(String raw, JsonObject json) {
    }

    @Override
    public void onPopularityUpdate(int popularity) {
    }
}

