/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.bili.live.runtime.data;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import top.mrxiaom.bili.live.runtime.data.PacketHeader;

public class Packet {
    private static final Packet s_NoBodyHeartBeatPacket = new Packet(PacketHeader.Operation.HeartBeat);
    public PacketHeader header;
    public byte[] packetBody;

    public int length() {
        return this.header.packetLength;
    }

    public Packet() {
        this.header = new PacketHeader();
    }

    public Packet(byte[] bytes) {
        byte[] headerArr = Arrays.copyOfRange(bytes, 0, 16);
        this.header = new PacketHeader(headerArr);
        this.packetBody = Arrays.copyOfRange(bytes, 16, bytes.length);
    }

    public Packet(PacketHeader.Operation operation) {
        this(operation, null);
    }

    public Packet(PacketHeader.Operation operation, byte[] body) {
        this.header = new PacketHeader();
        this.header.operation = operation;
        this.header.protocolVersion = PacketHeader.ProtocolVersion.UnCompressed;
        this.header.packetLength = 16 + (body != null ? body.length : 0);
        this.packetBody = body;
    }

    public byte[] toBytes() {
        this.header.packetLength = this.packetBody != null ? this.header.headerLength + this.packetBody.length : (int)this.header.headerLength;
        byte[] arr = new byte[this.header.packetLength];
        byte[] headerArr = this.header.toBytes();
        for (int i = 0; i < headerArr.length && i < this.header.headerLength; ++i) {
            arr[i] = headerArr[i];
        }
        if (this.packetBody != null) {
            int total = this.header.headerLength + this.packetBody.length;
            int i = this.header.headerLength;
            for (int j = 0; i < total && j < this.packetBody.length; ++i, ++j) {
                arr[i] = this.packetBody[j];
            }
        }
        return arr;
    }

    public static Packet heartbeat() {
        return Packet.heartbeat((byte[])null);
    }

    public static Packet heartbeat(String msg) {
        return Packet.heartbeat(msg.getBytes(StandardCharsets.UTF_8));
    }

    public static Packet heartbeat(byte[] msg) {
        if (msg == null) {
            return s_NoBodyHeartBeatPacket;
        }
        Packet packet = new Packet();
        packet.header.packetLength = 16 + msg.length;
        packet.header.protocolVersion = PacketHeader.ProtocolVersion.HeartBeat;
        packet.header.operation = PacketHeader.Operation.HeartBeat;
        packet.header.sequenceId = 1;
        packet.header.headerLength = (short)16;
        packet.packetBody = msg;
        return packet;
    }

    public static Packet authority(String token) {
        return Packet.authority(token, PacketHeader.ProtocolVersion.HeartBeat);
    }

    public static Packet authority(String token, PacketHeader.ProtocolVersion protocolVersion) {
        byte[] obj = token.getBytes(StandardCharsets.UTF_8);
        Packet packet = new Packet();
        packet.header.operation = PacketHeader.Operation.Authority;
        packet.header.protocolVersion = protocolVersion;
        packet.header.sequenceId = 1;
        packet.header.headerLength = (short)16;
        packet.header.packetLength = 16 + obj.length;
        packet.packetBody = obj;
        return packet;
    }

    static {
        Packet.s_NoBodyHeartBeatPacket.header = new PacketHeader();
        Packet.s_NoBodyHeartBeatPacket.header.headerLength = (short)16;
        Packet.s_NoBodyHeartBeatPacket.header.sequenceId = 1;
        Packet.s_NoBodyHeartBeatPacket.header.protocolVersion = PacketHeader.ProtocolVersion.HeartBeat;
        Packet.s_NoBodyHeartBeatPacket.header.operation = PacketHeader.Operation.HeartBeat;
    }
}

