/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.bili.live.runtime.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class PacketHeader {
    public static final int KPacketHeaderLength = 16;
    public int packetLength;
    public short headerLength;
    public ProtocolVersion protocolVersion;
    public Operation operation;
    public int sequenceId;

    public int getBodyLength() {
        return this.packetLength - this.headerLength;
    }

    public PacketHeader() {
    }

    public PacketHeader(byte[] b) {
        this.packetLength = PacketHeader.readInt32BigEndian(b, 0, 4);
        this.headerLength = PacketHeader.readInt16BigEndian(b, 4, 6);
        this.protocolVersion = ProtocolVersion.valueOf(PacketHeader.readInt16BigEndian(b, 6, 8));
        this.operation = Operation.valueOf(PacketHeader.readInt32BigEndian(b, 8, 12));
        this.sequenceId = PacketHeader.readInt32BigEndian(b, 12, 16);
    }

    public byte[] toBytes() {
        return PacketHeader.getBytes(this.packetLength, this.headerLength, this.protocolVersion, this.operation, this.sequenceId);
    }

    public static byte[] getBytes(int packetLength, short headerLength, ProtocolVersion protocolVersion, Operation operation) {
        return PacketHeader.getBytes(packetLength, headerLength, protocolVersion, operation, 1);
    }

    public static byte[] getBytes(int packetLength, short headerLength, ProtocolVersion protocolVersion, Operation operation, int sequenceId) {
        byte[] bytes = new byte[16];
        PacketHeader.writeInt32BigEndian(bytes, 0, 4, packetLength);
        PacketHeader.writeInt16BigEndian(bytes, 4, 6, headerLength);
        PacketHeader.writeInt16BigEndian(bytes, 6, 8, (short)protocolVersion.value);
        PacketHeader.writeInt32BigEndian(bytes, 8, 12, operation.value);
        PacketHeader.writeInt32BigEndian(bytes, 12, 16, sequenceId);
        return bytes;
    }

    public static short readInt16BigEndian(byte[] bytes, int start, int end) {
        byte[] fin = Arrays.copyOfRange(bytes, start, end);
        ByteBuffer wrap = ByteBuffer.wrap(fin);
        wrap.order(ByteOrder.BIG_ENDIAN);
        return wrap.getShort();
    }

    public static int readInt32BigEndian(byte[] bytes, int start, int end) {
        byte[] fin = Arrays.copyOfRange(bytes, start, end);
        ByteBuffer wrap = ByteBuffer.wrap(fin);
        wrap.order(ByteOrder.BIG_ENDIAN);
        return wrap.getInt();
    }

    public static void writeInt16BigEndian(byte[] bytes, int start, int end, short value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort(value);
        byte[] fin = buffer.array();
        int i = start;
        for (int j = 0; i < bytes.length && i < end && j < fin.length; ++i, ++j) {
            bytes[i] = fin[j];
        }
    }

    public static void writeInt32BigEndian(byte[] bytes, int start, int end, int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(value);
        byte[] fin = buffer.array();
        int i = start;
        for (int j = 0; i < bytes.length && i < end && j < fin.length; ++i, ++j) {
            bytes[i] = fin[j];
        }
    }

    public static enum ProtocolVersion {
        UnCompressed(0),
        HeartBeat(1),
        Zlib(2),
        Brotli(3);

        public final int value;

        private ProtocolVersion(int value) {
            this.value = value;
        }

        public static ProtocolVersion valueOf(int value) {
            for (ProtocolVersion p : ProtocolVersion.values()) {
                if (p.value != value) continue;
                return p;
            }
            return null;
        }
    }

    public static enum Operation {
        HeartBeat(2),
        HeartBeatResponse(3),
        ServerNotify(5),
        Authority(7),
        AuthorityResponse(8);

        public final int value;

        private Operation(int value) {
            this.value = value;
        }

        public static Operation valueOf(int value) {
            for (Operation o : Operation.values()) {
                if (o.value != value) continue;
                return o;
            }
            return null;
        }
    }
}

