/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.perf;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.spongepowered.asm.util.PrettyPrinter;

public final class Profiler {
    private boolean active;
    private final List<String> phases;
    private final Deque<Section> stack;
    public static final int FINE = 2;
    private final Map<String, Section> sections = new TreeMap<String, Section>();
    public static final int ROOT = 1;

    public PrettyPrinter printer(boolean includeFine, boolean group) {
        PrettyPrinter printer = new PrettyPrinter();
        int colCount = this.phases.size() + 4;
        int[] columns = new int[]{0, 1, 2, colCount - 2, colCount - 1};
        Object[] headers = new Object[colCount * 2];
        int col = 0;
        int pos = 0;
        while (col < colCount) {
            headers[pos + 1] = PrettyPrinter.Alignment.RIGHT;
            if (col == columns[0]) {
                headers[pos] = (group ? "" : "  ") + "Section";
                headers[pos + 1] = PrettyPrinter.Alignment.LEFT;
            } else {
                headers[pos] = col == columns[1] ? "    TOTAL" : (col == columns[3] ? "    Count" : (col == columns[4] ? "Avg. " : (col - columns[2] < this.phases.size() ? this.phases.get(col - columns[2]) : "")));
            }
            pos = ++col * 2;
        }
        printer.table(headers).th().hr().add();
        for (Section section : this.sections.values()) {
            if (section.isFine() && !includeFine || group && section.getDelegate() != section) continue;
            this.printSectionRow(printer, colCount, columns, section, group);
            if (!group) continue;
            for (Section subSection : this.sections.values()) {
                Section delegate = subSection.getDelegate();
                if (subSection.isFine() && !includeFine || delegate != section || delegate == subSection) continue;
                this.printSectionRow(printer, colCount, columns, subSection, group);
            }
        }
        return printer.add();
    }

    public void setActive(boolean active) {
        if (!this.active && active || !active) {
            this.reset();
        }
        this.active = active;
    }

    public Section begin(String name) {
        return this.begin(0, name);
    }

    public void reset() {
        for (Section section : this.sections.values()) {
            section.invalidate();
        }
        this.sections.clear();
        this.phases.clear();
        this.phases.add("Initial");
        this.stack.clear();
    }

    void end(Section section) {
        block5: {
            try {
                Section head;
                Section next = head = this.stack.pop();
                while (next != section) {
                    if (next == null && this.active) {
                        if (head == null) {
                            throw new IllegalStateException("Attempted to pop " + section + " but the stack is empty");
                        }
                        throw new IllegalStateException("Attempted to pop " + section + " which was not in the stack, head was " + head);
                    }
                    next = this.stack.pop();
                }
            }
            catch (NoSuchElementException ex) {
                if (!this.active) break block5;
                throw new IllegalStateException("Attempted to pop " + section + " but the stack is empty");
            }
        }
    }

    public Section get(String name) {
        Section section = this.sections.get(name);
        if (section == null) {
            section = this.active ? new LiveSection(name, this.phases.size() - 1) : new Section(name);
            this.sections.put(name, section);
        }
        return section;
    }

    private Section getSubSection(String name, String baseName, Section root) {
        Section section = this.sections.get(name);
        if (section == null) {
            section = new SubSection(name, this.phases.size() - 1, baseName, root);
            this.sections.put(name, section);
        }
        return section;
    }

    public void mark(String phase) {
        long currentPhaseTime = 0L;
        for (Section section : this.sections.values()) {
            currentPhaseTime += section.getTime();
        }
        if (currentPhaseTime == 0L) {
            int size = this.phases.size();
            this.phases.set(size - 1, phase);
            return;
        }
        this.phases.add(phase);
        for (Section section : this.sections.values()) {
            section.mark();
        }
    }

    public Section begin(int flags, String name) {
        boolean root = (flags & 1) != 0;
        boolean fine = (flags & 2) != 0;
        String path = name;
        Section head = this.stack.peek();
        if (head != null) {
            path = head.getName() + (root ? " -> " : ".") + path;
            if (head.isRoot() && !root) {
                int pos = head.getName().lastIndexOf(" -> ");
                name = (pos > -1 ? head.getName().substring(pos + 4) : head.getName()) + "." + name;
                root = true;
            }
        }
        Section section = this.get(root ? name : path);
        if (root && head != null && this.active) {
            section = this.getSubSection(path, head.getName(), section);
        }
        section.setFine(fine).setRoot(root);
        this.stack.push(section);
        return section.start();
    }

    public Section begin(String ... path) {
        return this.begin(0, path);
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    private void printSectionRow(PrettyPrinter printer, int colCount, int[] columns, Section section, boolean group) {
        long[] times;
        boolean isDelegate = section.getDelegate() != section;
        Object[] values = new Object[colCount];
        int col = 1;
        values[0] = group ? (isDelegate ? "  > " + section.getBaseName() : section.getName()) : (isDelegate ? "+ " : "  ") + section.getName();
        for (long time : times = section.getTimes()) {
            if (col == columns[1]) {
                values[col++] = section.getTotalTime() + " ms";
            }
            if (col < columns[2] || col >= values.length) continue;
            values[col++] = time + " ms";
        }
        values[columns[3]] = section.getTotalCount();
        values[columns[4]] = new DecimalFormat("   ###0.000 ms").format(section.getTotalAverageTime());
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            values[i] = "-";
        }
        printer.tr(values);
    }

    boolean isHead(Section section) {
        return this.stack.peek() == section;
    }

    public Section begin(int flags, String ... path) {
        return this.begin(flags, Joiner.on((char)'.').join((Object[])path));
    }

    public Profiler() {
        this.phases = new ArrayList<String>();
        this.stack = new LinkedList<Section>();
        this.phases.add("Initial");
    }

    class SubSection
    extends LiveSection {
        private final String baseName;
        private final Section root;

        @Override
        Section invalidate() {
            this.root.invalidate();
            return super.invalidate();
        }

        SubSection(String name, int cursor, String baseName, Section root) {
            super(name, cursor);
            this.baseName = baseName;
            this.root = root;
        }

        @Override
        public Section next(String name) {
            super.stop();
            return this.root.next(name);
        }

        @Override
        Section getDelegate() {
            return this.root;
        }

        @Override
        public void setInfo(String info) {
            this.root.setInfo(info);
            super.setInfo(info);
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public Section end() {
            this.root.stop();
            return super.end();
        }

        @Override
        Section start() {
            this.root.start();
            return super.start();
        }
    }

    class LiveSection
    extends Section {
        private long[] times;
        private int markedCount;
        private long start;
        private int count;
        private long markedTime;
        private int cursor;
        private long time;

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        Section start() {
            this.start = System.currentTimeMillis();
            return this;
        }

        LiveSection(String name, int cursor) {
            super(name);
            this.cursor = 0;
            this.times = new long[0];
            this.start = 0L;
            this.cursor = cursor;
        }

        @Override
        public double getTotalAverageTime() {
            return this.count > 0 ? (double)(this.time + this.markedTime) / (double)(this.count + this.markedCount) : 0.0;
        }

        @Override
        public double getTotalSeconds() {
            return (double)(this.time + this.markedTime) * 0.001;
        }

        @Override
        public double getSeconds() {
            return (double)this.time * 0.001;
        }

        @Override
        protected Section stop() {
            if (this.start > 0L) {
                this.time += System.currentTimeMillis() - this.start;
            }
            this.start = 0L;
            ++this.count;
            return this;
        }

        @Override
        public long[] getTimes() {
            long[] times = new long[this.cursor + 1];
            System.arraycopy(this.times, 0, times, 0, Math.min(this.times.length, this.cursor));
            times[this.cursor] = this.time;
            return times;
        }

        @Override
        public long getTotalTime() {
            return this.time + this.markedTime;
        }

        @Override
        void mark() {
            if (this.cursor >= this.times.length) {
                this.times = Arrays.copyOf(this.times, this.cursor + 4);
            }
            this.times[this.cursor] = this.time;
            this.markedTime += this.time;
            this.markedCount += this.count;
            this.time = 0L;
            this.count = 0;
            ++this.cursor;
        }

        @Override
        public int getTotalCount() {
            return this.count + this.markedCount;
        }

        @Override
        public double getAverageTime() {
            return this.count > 0 ? (double)this.time / (double)this.count : 0.0;
        }

        @Override
        public Section end() {
            this.stop();
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        @Override
        public long getTime() {
            return this.time;
        }
    }

    public class Section {
        static final String SEPARATOR_ROOT = " -> ";
        private final String name;
        private boolean fine;
        private boolean root;
        private String info;
        static final String SEPARATOR_CHILD = ".";
        protected boolean invalidated;

        public boolean isRoot() {
            return this.root;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public long getTime() {
            return 0L;
        }

        public Section next(String name) {
            this.end();
            return Profiler.this.begin(name);
        }

        public final String toString() {
            return this.name;
        }

        public double getTotalSeconds() {
            return 0.0;
        }

        public String getBaseName() {
            return this.name;
        }

        public long getTotalTime() {
            return 0L;
        }

        Section setFine(boolean fine) {
            this.fine = fine;
            return this;
        }

        protected Section stop() {
            return this;
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return 0;
        }

        public int getTotalCount() {
            return 0;
        }

        Section invalidate() {
            this.invalidated = true;
            return this;
        }

        public double getSeconds() {
            return 0.0;
        }

        public Section end() {
            if (!this.invalidated) {
                Profiler.this.end(this);
            }
            return this;
        }

        public double getTotalAverageTime() {
            return 0.0;
        }

        Section getDelegate() {
            return this;
        }

        Section(String name) {
            this.name = name;
            this.info = name;
        }

        Section start() {
            return this;
        }

        public long[] getTimes() {
            return new long[1];
        }

        public boolean isFine() {
            return this.fine;
        }

        public double getAverageTime() {
            return 0.0;
        }

        Section setRoot(boolean root) {
            this.root = root;
            return this;
        }

        public String getInfo() {
            return this.info;
        }

        void mark() {
        }
    }
}

