let guide = new Book("FishingUtils Guide")
    .addPage("&6Welcome to &3Fishing&9Utils&6!&0\n\n&8The following is a guide for how to use the mod. Turn to the next page for a table of contents. Click any line in the table of contents to jump to that page.")
    .addPage(new Message("&3&lTABLE OF CONTENTS\n",
        new TextComponent("&3Setup Guide\n").setHover("show_text", "&9Click to go to Setup Guide").setClick("change_page", 5),
        new TextComponent("&9Loading stats\n").setHover("show_text", "&9Click to go to Loading stats").setClick("change_page", 6),
        new TextComponent("&9Customizing the mod\n").setHover("show_text", "&9Click to go to Customizing the mod").setClick("change_page", 7),
        new TextComponent("&9Troubleshooting\n").setHover("show_text", "&9Click to go to Troubleshooting").setClick("change_page", 8),
        new TextComponent("&3Feature List\n").setHover("show_text", "&9Click to go to Feature List").setClick("change_page", 9),
        new TextComponent("&9Fishing Display\n").setHover("show_text", "&9Click to go to Fishing Display").setClick("change_page", 10),
        new TextComponent("&9Orb Display\n").setHover("show_text", "&9Click to go to Orb Display").setClick("change_page", 11),
        new TextComponent("&9Orb Alarm\n").setHover("show_text", "&9Click to go to Orb Alarm").setClick("change_page", 12),
        new TextComponent("&9Orb Timer\n").setHover("show_text", "&9Click to go to Orb Timer").setClick("change_page", 13),
        new TextComponent("&9Thousand Announcer\n").setHover("show_text", "&9Click to go to Thousand Announcer").setClick("change_page", 14),
        new TextComponent("&9One Treasure Announcer\n").setHover("show_text", "&9Click to go to One Treasure Announcer").setClick("change_page", 15),
        "&8&ocont. on next page"
    ))
    .addPage(new Message(
        new TextComponent("&9Goals\n").setHover("show_text", "&9Click to go to Goals").setClick("change_page", 16),
        new TextComponent("&9Auto GC\n").setHover("show_text", "&9Click to go to Auto GC").setClick("change_page", 17),
        new TextComponent("&9Custom Trails\n").setHover("show_text", "&9Click to go to Custom Trails").setClick("change_page", 18),
        new TextComponent("&9Dockmaster Waypoint\n").setHover("show_text", "&9Click to go to Dockmaster Waypoint").setClick("change_page", 19),
        new TextComponent("&9Hide Leaderboard Switch Messages\n").setHover("show_text", "&9Click to go to Hide Leaderboard Switch Messages").setClick("change_page", 20),
        new TextComponent("&9Basic Mode\n").setHover("show_text", "&9Click to go to Basic Mode").setClick("change_page", 21),
        new TextComponent("&9Thousand Separator Character\n").setHover("show_text", "&9Click to go to Thousand Separator Character").setClick("change_page", 22),
        new TextComponent("&9Decimal Separator Character\n").setHover("show_text", "&9Click to go to Decimal Separator Character").setClick("change_page", 23),
        new TextComponent("&9Orb Messages in Chat\n").setHover("show_text", "&9Click to go to Orb Messages in Chat").setClick("change_page", 24),
        new TextComponent("&9Resource List\n").setHover("show_text", "&9Click to go to Resource List").setClick("change_page", 25),
        "&8&ocont. on next page"
    ))
    .addPage(new Message(new TextComponent("&3Commands\n").setHover("show_text", "&9Click to go to Commands").setClick("change_page", 26),
        new TextComponent("&9/fu\n").setHover("show_text", "&9Click to go to /fu").setClick("change_page", 27),
        new TextComponent("&9/fs\n").setHover("show_text", "&9Click to go to /fs").setClick("change_page", 28),
        new TextComponent("&9/hfs\n").setHover("show_text", "&9Click to go to /hfs").setClick("change_page", 30),
        new TextComponent("&9/fsguild\n").setHover("show_text", "&9Click to go to /fsguild").setClick("change_page", 31),
        new TextComponent("&9/orbs\n").setHover("show_text", "&9Click to go to /orbs").setClick("change_page", 32),
        new TextComponent("&9/selfstats\n").setHover("show_text", "&9Click to go to /selfstats").setClick("change_page", 33),
        new TextComponent("&9/getenchants\n").setHover("show_text", "&9Click to go to /getenchants").setClick("change_page", 34),
        new TextComponent("&9Fun Commands\n").setHover("show_text", "&9Click to go to Fun Commands").setClick("change_page", 35),
        new TextComponent("&3Credits").setHover("show_text", "&9Click to go to Credits").setClick("change_page", 36)
    ))
    .addPage("&3&lSETUP GUIDE\n\n&8Read this if you are new to the mod. It will help you get started.")
    .addPage("&9Loading stats\n\n&8In order to track your stats, you must first load them. You can do this by speaking with the Dock Master NPC and opening the Orb Collection menu (bottom middle).")
    .addPage("&9Customizing the mod\n\n&8Run &7/fu &8to open the settings menu. Run &7/fu key &8to set your Hypixel API key. If you don't know your key, you can run &7/api new &8to get a new key.")
    .addPage("&9Troubleshooting\n\n&8If you are having issues with settings, run &7/ct delete SettingsManager &8and then &7/ct load&8. FishingUtils is not compatible with OldAnimationsMod or LabyMod. Your Hypixel language must be set to English.")
    .addPage("&3&lFEATURE LIST\n\n&8The following is a list of all features in the mod.")
    .addPage("&9Fishing Display\n\n&8The fishing display is a customizable overlay that shows your fishing stats. This text display shows when you hold the fishing rod and can be customized in the settings menu.")
    .addPage("&9Orb Display\n\n&8The orb display will show your orb statistics and also appears when you hold the fishing rod. This display can be moved and customized in the settings menu.")
    .addPage("&9Orb Alarm\n\n&8The orb alarm will play a continuous sound when an orb spawns. The sound that plays can be customized in the settings menu.")
    .addPage("&9Orb Timer\n\n&8The orb timer will display a countdown above an orb till it attacks. You can customize the color in the settings menu.")
    .addPage("&9Thousand Announcer\n\n&8The thousand announcer will print a message in chat when you reach a milestone of a stat. You can change the increment at which it announces in the settings menu. Example:\n&4&l[!] &c&l1K Junk!")
    .addPage("&9One Treasure Announcer\n\n&8The one treasure announcer will print a message in chat when you catch one of a treasure. Example:\n&1&l[!] &9&l1 &b&lHypixel Experience!")
    .addPage("&9Goals\n\n&8Goals will track your progress towards goals that you set. You can choose a preset in the settings menu, or run &7/fu goals &8to set your own custom goals.")
    .addPage(new Message("&9Auto GC\n\n&8Auto GC will automatically say a message in chat when someone catches a special fish. This message is editable in the settings menu. You can use certain variables in your message, ",
        new TextComponent("&8&nhover over this text for a list").setHover("show_text", "&6&lList of variables\n&6%%name%% &7will be replaced with the name of the player\n&6%%fish%% &7will be replaced with the name of the special fish\n&6%%lore%% &7will be replaced with the lore of the special fish\n&6%%rod%% &7will be replaced with the rod used to catch the special fish"),
        "&8."))
    .addPage("&9Custom Trails\n\n&8Custom trails allow you to create a custom particle trail for your bobber. You can select a preset or make your own in the settings menu. Some settings will apply even if a preset is set depending on the preset.")
    .addPage("&9Dockmaster Waypoint\n\n&8The Dockmaster Waypoint will shine a beam on the Dockmaster NPC before you get the rod.")
    .addPage("&9Hide Leaderboard Switch Messages\n\n&8This setting will hide the messages that appear when you switch between the leaderboard modes. The messages that will be hidden look like this:\n&aShowing &b&lFish &apositions!")
    .addPage("&9Basic Mode\n\n&8Basic mode simplifies the catch messages that appear in chat. Example:\n&7You caught an &aenchanted fishing rod&7, that's a treasure!\n&8would become\n&aTreasure &7caught!")
    .addPage("&9Thousand Separator Character\n\n&8You can change what character is used to seperate thousands. For example, with default settings, 1000 would become 1,000.")
    .addPage("&9Decimal Separator Character\n\n&8You can change what character is used to seperate decimals. By default, this character is a period.")
    .addPage("&9Orb Messages in Chat\n\n&8You can choose whether to have messages appear in chat when you get an orb. These messages look like this:\n&7You summoned &aShadow of Nyx&7!\n&7You deactivated &aShadow of Nyx &7in &32.5 &7seconds!")
    .addPage("&9Resource List\n\n&8The resource list is a list of everything in fishing. You can access this list by running &7/fu resources&8.")
    .addPage("&3&lCOMMANDS\n\n&8All commands are tab-completable, meaning you can press tab to autofill parameters.")
    .addPage("&9/fu\n\n&8Running &7/fu &8will open the settings menu. Running &7/fu help &8will print a message with clickable buttons to run other commands.")
    .addPage("&9/fs\n\n&7/fs &8will print your fishing stats. &7/fs <player> &8will print the stats of the specified player. Your API key must be set in order to get the stats of other players. You can customize the command in the settings menu.\n&8&ocont. on next page")
    .addPage("&9/fs (cont)\n\n&8You can get stats from a specific environment by typing it after the player's name. You can hover over the lines in chat for more info.")
    .addPage("&9/hfs\n\n&7/hfs &8will print fishing stats from previous seasons. The syntax is &7/hfs <player> <year> <season> [environment]&8.")
    .addPage("&9/fsguild\n\n&7/fsguild &8will sum the stats of an entire guild. The syntax is &7/fsguild [guild name]&8. The guild name is case sensitive and you can use spaces. If the guild name is omitted your guild will be used.")
    .addPage("&9/orbs\n\n&7/orbs &8will print your orb stats.")
    .addPage("&9/selfstats\n\n&7/selfstats &8will open a menu to view your stats across all your accounts. This command is useful if you have multiple accounts, as your stats are saved separately for each account. You can skip the menu by running &7/selfstats <account>&8.")
    .addPage("&9/getenchants\n\n&7/getenchants <player> &8will print the enchants of the specified player. The specified player must be in your render distance and must be holding the fishing rod. The enchants will be in the language of whoever you're getting them from.")
    .addPage("&9Fun Commands\n\n&8There are a few simple, fun commands you can use. It is up to you to figure out what they are.")
    .addPage("&3&lCREDITS\n\n&8FishingUtils uses the following libraries:\n&6requestV2 &8by &3McPqndq\n&6BeaconBeam &8by &31ksd\n&6SettingsManager &8by &3kerbybit\n\n&8FishingUtils is created by sharkey300")
export { guide }