//&3Fishing&9Utils
//vars and imports
import { request } from '../requestV2'
import renderBeaconBeam from '../BeaconBeam'
import { FishingUtils } from './settings'
import { guide } from './guide'
import { resources } from './resources'
let simplerTimes = FishingUtils.getSetting("Miscellaneous", "Simpler Times")
const displayPos = new Gui()
displayPos.registerDraw(moveGuiRender)
const orbDisplayPos = new Gui()
orbDisplayPos.registerDraw(moveGuiRender)
let enabled = false
let new_account = false
let sub = (getSub() || "main")
let uuid = Player.getUUID()
const default_data = {
    player: {},
    config: {
        "displayPos": {
            "x": 10,
            "y": 10
        },
        "orbDisplayPos": {
            "x": 10,
            "y": 10
        },
        "key": "NONE",
        "goals": {},
        "reached_goals": []
    }
}
const default_stats = {
    fish: 0,
    junk: 0,
    treasure: 0,
    plant: 0,
    creature: 0,
    total: 0,
    seasonal_fish: 0,
    seasonal_junk: 0,
    seasonal_treasure: 0,
    seasonal_total: 0,
    caught: "",
    orbs: {
        helios: 0,
        selene: 0,
        nyx: 0,
        aphrodite: 0,
        zeus: 0,
        demeter: 0,
        archimedes: 0,
        hades: 0,
        total: -1,
        seasonal_total: -1,
        weight: {
            helios: -1,
            selene: -1,
            nyx: -1,
            aphrodite: -1,
            zeus: -1,
            archimedes: -1,
            hades: -1
        },
        last_ultra_rare: -1
    },
    special: 0,
    retroactive: false
}
if (!FileLib.exists("FishingUtils", "data.json")) FileLib.write("FishingUtils", "data.json", JSON.stringify(default_data))
let data = JSON.parse(FileLib.read("FishingUtils", "data.json"))
let stats
updateDataPath()
const fish_re = /^&r&7You caught(?: an?)? &r&e([^\d].+)&r&7!&r$/
const junk_re = /^&r&7Oh no, you caught(?: an?)? &r&c(.+)&r&7!&r$/
const treasure_re = /^&r&7You caught(?: an?)? &r&a(.+)&r&7, that's a treasure!&r$/
const treasure_re2 = /^&r&7You caught &r&.((\d{1,3}) .+)&r&7!&r$/
const plant_re = /^&r&7You caught(?: an?)? &r&2([^\d].+)&r&7!&r$/
const creature_re = /^&r&7You caught(?: an?)? &r&b([^\d].+)&r&7!&r$/
const gc_re = /^(?:\[\w*\+?\+?\] )?(?!You)(\w{1,16}) caught(?: an?)? ((?:.)+?)! (.+)$/
const orb_chat_re = /^&r&7You caught a &r&f(\d+)kg &r(&\w)(.*)&r&7!&r$/
const lb_re = /Showing (?:(?:Fish)|(?:Junk)|(?:Treasure)) positions!/
const name_re = /^\w{1,16}$/
const tab_re = /^§[^8](?:\[[\w§+]+?\] )?(\w{1,16})(?: §.\[.+?\])?$/
const metadata = JSON.parse(FileLib.read("FishingUtils", "metadata.json"))
let catsnfish = false
let crabMode = false
let disconnect = false
let API_KEY = data.config.key
const ap_tiers = [10, 25, 50, 100, 500, 1000]
const master_tiers = [500, 1250, 2500, 5000]
const seasonal_tiers = [1, 10, 25, 50, 100]
const default_progress = {
    fish: "",
    junk: "",
    treasure: "",
    plant: "",
    creature: "",
    mythical_fish: "",
    total: "",
    seasonal_fish: "",
    seasonal_junk: "",
    seasonal_treasure: "",
    seasonal_mythical_fish: "",
    seasonal_total: ""
}
const fu_subs = ["help", "guide", "resources", "key", "goals", "reset"]
const goal_keys = ["list", "reset", "fish", "junk", "treasure", "plant", "creature", "mythical_fish", "total", "seasonal_fish", "seasonal_junk", "seasonal_treasure", "seasonal_mythical_fish", "seasonal_total"]
const dev_stat = ["fish", "junk", "treasure", "plant", "creature", "total", "seasonal_fish", "seasonal_junk", "seasonal_treasure", "seasonal_total", "special"]
const dev_subs = ["setlastultrarare", "setstat", "setseason", "removeseason", "setorb", "setretroactive", "setsub", "generatefakeaccount", "removefakeaccounts"]
const seasons = ["christmas", "easter", "summer", "halloween"]
const text = new Text("Click anywhere to move the Display, press ESC to close", 0, 0).setColor(Renderer.GREEN).setShadow(true)
const display = new Display().hide().setRenderLoc(data.config.displayPos.x, data.config.displayPos.y)
updateDisplay()
const plus_dictionary = {
    "RED": "§c",
    "GOLD": "§6",
    "GREEN": "§a",
    "YELLOW": "§e",
    "LIGHT_PURPLE": "§d",
    "WHITE": "§f",
    "BLUE": "§9",
    "DARK_GREEN": "§2",
    "DARK_RED": "§4",
    "DARK_AQUA": "§3",
    "DARK_PURPLE": "§5",
    "DARK_GRAY": "§8",
    "BLACK": "§0",
    "DARK_BLUE": "§1",
    "GRAY": "§7"
}
const fish = new Item(349)
let bobber
let bobber_needed = false
const fishhook = Java.type("net.minecraft.entity.projectile.EntityFishHook").class
const nocolor_list = ["VILLAGER_HAPPY", "HEART", "WATER_WAKE", "FLAME", "VILLAGER_ANGRY"]
const particle_dictionary = {
    "Emerald": "VILLAGER_HAPPY",
    "Hearts": "HEART",
    "Water": "WATER_WAKE",
    "Fire": "FLAME",
    "Storm": "VILLAGER_ANGRY",
    "Dust": "REDSTONE",
    "Small Dust": "TOWN_AURA",
    "Large Dust": "SMOKE_LARGE",
    "Rising Dust": "SMOKE_NORMAL",
    "Falling Dust": "SNOW_SHOVEL",
    "Magic Dust": "PORTAL",
    "Cloud": "CLOUD",
    "Large Cloud": "EXPLOSION_NORMAL",
    "Crit": "CRIT",
    "Magic Crit": "CRIT_MAGIC",
    "Runes": "ENCHANTMENT_TABLE",
    "Stars": "FIREWORKS_SPARK",
    "Music Notes": "NOTE"
}
const orb_dictionary = {
    "Ember of Helios": "helios",
    "Dust of Selene": "selene",
    "Shadow of Nyx": "nyx",
    "Heart of Aphrodite": "aphrodite",
    "Spark of Zeus": "zeus",
    "Spirit of Demeter": "demeter",
    "Automaton of Daedalus": "archimedes",
    "Wrath of Hades": "hades"
}
const trail_dictionary = {
    "none": "None",
    "mainlobby_fishing_gold_particles": "Emerald",
    "mainlobby_fishing_sparkle": "Sparkle",
    "mainlobby_fishing_treasure_sheen": "Treasure's Sheen",
    "mainlobby_fishing_beloved_junk": "Beloved Junk",
    "mainlobby_fishing_archimedes": "Archimedes' Trail",
    "mainlobby_fishing_hades_hook": "Hades' Hook",
    "mainlobby_fishing_helios_breath": "Helios' Breath",
    "mainlobby_fishing_organic_material": "Organic Material",
    "mainlobby_fishing_creature_catch": "Creature Catch",
    "mainlobby_fishing_neptune_grace": "Neptune's Grace",
    "mainlobby_fishing_ominous_rain": "Ominous Rain"
}
const enchant_dictionary = {
    "lure": "Lure",
    "luck": "Luck of the Sea",
    "collector": "Collector",
    "dumpster_diver": "Dumpster Diver",
    "vulcans_blessing": "Vulcan's Blessing",
    "neptunes_fury": "Neptune's Fury",
    "mythical_hook": "Mythical Hook",
    "herbivore": "Herbivore"
}
const rod_dictionary = {
    "fishing_rod_3000": "&6Fishing Rod &l3000",
    "inaugural_ice_fishing_rod": "&bInaugural Ice Fishing Rod",
    "fishing_rod_springtime": "&eSpringtime Fishing Rod",
    "fishing_rod_haunted": "&5Haunted Fishing Rod",
    "fishing_rod_festive": "&cFestive Fishing Rod",
    "fishing_rod_solar": "&6Solar Fishing Rod",
    "fishing_rod_overgrown": "&2Overgrown Fishing Rod",
    "fishing_rod_zoologist": "&bZoologist Fishing Rod"
}
const settings_dictionary = {
    "fishCollectorShowCaught": "Uncaught Fish",
    "simplifiedIcons": "Menu Icons"
}
const settings_value_dictionary = {
    "fishCollectorShowCaught": {
        "true": "&cHidden",
        "false": "&aShown"
    },
    "simplifiedIcons": {
        "true": "&eSimplified",
        "false": "&aNormal"
    }
}
const maximumWeightValues = {
    "helios": 15,
    "selene": 15,
    "nyx": 25,
    "aphrodite": 25,
    "zeus": 40,
    "demeter": 40,
    "archimedes": 50,
    "hades": 50
}
const specialFish = {
    "regular": ["Puffer Emoji", "Nemo", "Knockback Slimeball", "Hot Potato", "Fish Monger Suit Helmet", "Fish Monger Suit Chestplate", "Fish Monger Suit Leggings", "Fish Monger Suit Boots", "Barnacle", "Leviathan", "Star-Eater Scales", "Rubber Duck"],
    "summer": ["Oops the Fish", "Shark", "Sea Bass", "Sunscreen", "Pile of Sand", "Mahi Mahi", "Lucent Bee Hive"],
    "halloween": ["Spook the Fish", "Chocolate Bar", "Pumpkin Spice Latte", "Angler", "Eyeball", "Wayfinder's Compass", "Molten Iron", "Regular Fish", "Lava Shark"],
    "holiday": ["Chill the Fish 3", "Frozen Fish", "Festival Pufferfish Hat", "Eggnog", "Dawning Snowball", "Frozen Meal", "Festive Lights"],
    "easter": ["Egg the Fish", "Cracked Egg", "Raw Ham", "Carrot", "Soggy Hot Cross Bun", "Clay Ball", "Rose", "Cherry Blossom"],
    "event": ["Poisonous Potato", "Golden Apple", "Burnt Plant"]
}
const specialCounts = {
    "water": 39,
    "lava": 4,
    "ice": 4,
    "total": 47
}
const cosmeticNames = {
    "cloak_school": "&6School Cloak",
    "cloak_aquarium": "&6Aquarium Cloak",
    "gadget_hot_potato": "&bHot Potato Gadget",
    "gadget_portable_pond": "&5Portable Pond Gadget",
    "gadget_spooky_fish": "&6Spooky Fish Gadget",
    "hat_golden_pufferfish": "&6Golden Pufferfish Hat",
    "hat_spooked_pufferfish": "&6Spooked Pufferfish Hat",
    "hat_festive_pufferfish": "&6Festive Pufferfish Hat",
    "hat_seasoned_fisher_banner": "&6Seasoned Fisher Banner",
    "hat_legendary_fisher_banner": "&6Legendary Fisher Banner",
    "hat_spooky_fisher_banner": "&6Spooky Fisher Banner",
    "hat_festive_fisher_banner": "&6Festive Fisher Banner",
    "pet_pufferfish": "&6Pufferfish Pet",
    "punchmessage_fished": "&aFished Punch Message",
    "status_legendary_fisher": "&6Legendary Fisher Status",
    "suit_fish_monger_helmet": "&6Fish Monger Suit Helmet",
    "suit_fish_monger_chestplate": "&5Fish Monger Suit Chestplate",
    "suit_fish_monger_leggings": "&9Fish Monger Suit Leggings",
    "suit_fish_monger_boots": "&aFish Monger Suit Boots"
}
const enchantTiers = {
    "lure": [0, 0, 0, 500, 1500, 3000],
    "luck": [0, 0, 100, 250, 750, 1000],
    "collector": [250, 500, 1000, 2500],
    "dumpster_diver": [1, 2, 3, 4, 5]
}
const enchantUnlockItems = {
    "lure": "Fish",
    "luck": "Treasure",
    "collector": "Junk",
    "dumpster_diver": "Special Fish"
}
const achievement_dictionary = {
    general_hot_potato: "Hot Potato",
    general_fishing_hobbyist: "Main Lobby: Fishing Hobbyist",
    general_doing_my_part: "Main Lobby: Doing My Part",
    general_tips_and_tricks: "Main Lobby: Tips and Tricks",
    general_deep_sea_expert: "Main Lobby: Deep Sea Expert",
    general_old_farmers_almanac: "Main Lobby: Old Farmer's Almanac",
    general_master_lure: "Main Lobby: Master Lure",
    general_trashiest_diver: "Main Lobby: Trashiest Diver",
    general_luckiest_of_the_sea: "Main Lobby: Luckiest of the Sea",
    summer_collectors_edition: "Collector's Edition",
    summer_gone_fishing: "Gone Fishing",
    easter_spring_fishing: "Spring Fishing",
    easter_spring_water: "Spring Water"
}
const achievement_tiers = {
    general_luckiest_of_the_sea: [10, 25, 50, 100, 500],
    general_master_lure: [25, 50, 100, 500, 1000],
    general_trashiest_diver: [10, 25, 50, 100, 500],
    summer_gone_fishing: [10, 50, 100]
}
const margin = 14
let orbDisplayToggle = false
const orb_names = ["helios", "selene", "nyx", "aphrodite", "zeus", "demeter", "archimedes", "hades"]
const type_list = ["fish", "junk", "treasure", "plant", "creature", "orb"]
const env_list = ["water", "lava", "ice"]
let images = []
let top_text = []
let bottom_text = []
const mythicToOrbNames = {
    "Ember of Helios": "Orb of Helios",
    "Dust of Selene": "Orb of Selene",
    "Shadow of Nyx": "Shadow of Nyx",
    "Heart of Aphrodite": "Heart of Aphrodite",
    "Spark of Zeus": "Spark of Zeus",
    "Spirit of Demeter": "Spirit of Demeter",
    "Automaton of Daedalus": "Archimedes' Sphere",
    "Wrath of Hades": "Hades' Wrath"
}
const orbTextures = {
    "helios": "c3d14561bbd063f70424a8afcc37bfe9c74562ea36f7bfa3f23206830c64faf1",
    "selene": "fadc4a024718d401eeae9e95b3c92767f916f323c9e83649ad15c9265ee5092f",
    "nyx": "5879ed2b39fa0462c74292f5ca3d188420128b4a63ac75db8c97a094d1ac63f4",
    "aphrodite": "190253c49e13cc2de00090ee65809da617c53f59e35f09a7c6e35011d19acb3d",
    "zeus": "77400ea19dbd84f75c39ad6823ac4ef786f39f48fc6f84602366ac29b837422",
    "demeter": "967a2f218a6e6e38f2b545f6c17733f4ef9bbb288e75402949c052189ee",
    "archimedes": "4fa1ef47daecfbda7e5505a1ba657926f621247c8761cd46c907736661bbe",
    "hades": "9c2e9d8395cacd9922869c15373cf7cb16da0a5ce5f3c632b19ceb3929c9a11"
}
let orbGameProfiles = {
    "helios": null,
    "selene": null,
    "nyx": null,
    "aphrodite": null,
    "zeus": null,
    "demeter": null,
    "archimedes": null,
    "hades": null,
    "initialized": false
}
const simplerTimesSettingObject = FishingUtils.getSettingObject("Miscellaneous", "Simpler Times")
if (!simplerTimes) simplerTimesSettingObject.setHidden(true)
else initializeGameProfiles(orbTextures, orbGameProfiles)
const transTextures = {
    "helios": "eb40964542b1b73f8c30569822705f023a6341703aa83613d60cfffc0a9c1106",
    "selene": "54fc7c34cee2ef68f30384157c1808c7e690a6575dd42c71044165fd9e1c29f5",
    "nyx": "b0205ae90006c1d7a0004a62be53a2a15eb18443578ec4bc9a9d1a515ad521d8",
    "aphrodite": "c4d1179b7f2223b331cc28edf78da93ab0c49e76a9387a3b0a7a4b21abc1dfd4",
    "zeus": "4057f4a77a48f0c6f32f89f0be7451ca6934ff0f1331ec3c256a486630376d73",
    "demeter": "",
    "archimedes": "9330f0e617dce7dfbb6e18bae6e6e98120e89a05b5eef8e07fe3f27d5c5cd2ce",
    "hades": "ebeaa209fb4be6e4edeab0abb64b10d599e092e9762754d2dc8fe796ffc69c8"
}
let transGameProfiles = {
    "helios": null,
    "selene": null,
    "nyx": null,
    "aphrodite": null,
    "zeus": null,
    "demeter": null,
    "archimedes": null,
    "hades": null,
    "initialized": false
}
for (let i = 0; i < orb_names.length; i++) {
    if (simplerTimes) images.push(Image.fromAsset("orb_" + orb_names[i] + ".png"))
    else images.push(Image.fromAsset(orb_names[i] + ".png"))
    top_text.push(new Text(stats.orbs[orb_names[i]].toString(), data.config.orbDisplayPos.x + 16 + (30 + margin) * i - 0.5, data.config.orbDisplayPos.y).setShadow(true).setAlign("center").setColor(Renderer.RED))
    bottom_text.push(new Text(orbPercentage(stats.orbs[orb_names[i]], stats.orbs.total).replace(/[()]/g, ""), data.config.orbDisplayPos.x + 16 + (30 + margin) * i - 0.5, data.config.orbDisplayPos.y + 40).setShadow(true).setAlign("center").setColor(Renderer.GRAY))
}

function updateOrbImages() {
    images = []
    orb_names.forEach(el => {
        if (simplerTimes) images.push(Image.fromAsset("orb_" + el + ".png"))
        else images.push(Image.fromAsset(el + ".png"))
    })
}
let debug = false

//Debug
function debugLog(message) {
    if (debug) console.log(`[Fishing Utils] ${message}`)
}

//Auto Enabler
register("worldLoad", () => {
    enabled = false
    debugLog("Auto Disabled")
    setTimeout(() => {
        if (!enabled) ChatLib.command("locraw")
    }, 1000)
})
register("chat", (event) => {
    if (enabled) return
    let msg = ChatLib.getChatMessage(event)
    let locraw
    try {
        locraw = JSON.parse(msg)
    } catch (e) {
        return
    }
    cancel(event)
    if (locraw.gametype === "MAIN") {
        enabled = true
        let subdomain = "MC"
        if (sub === "alpha") subdomain = "ALPHA"
        if (FishingUtils.getSetting("Miscellaneous", "Secret")) TabList.setHeader(`&r&r&bYou are fishing on &r&e&l${subdomain}.HYPIXEL.NET&r&r`)
        debugLog("Auto Enabled")
    }
}).setPriority(Priority.LOWEST)

//Display Loader
register("renderOverlay", () => {
    if (displayPos.isOpen()) {
        display.show()
        orbDisplayToggle = false
        return
    }
    if (orbDisplayPos.isOpen()) {
        display.hide()
        orbDisplayToggle = true
        return
    }
    let displayToggle = FishingUtils.getSetting("Fishing Display", "Display Fishing Stats")
    let orbToggle = FishingUtils.getSetting("Mythic Display", "Mythical Fish Display")
    const heldItemIndex = Player.getHeldItemIndex()
    const heldItem = Player.getHeldItem()
    const holdingRod = heldItem !== null && (heldItem.getID() === 346 && heldItemIndex === 3)
    if (displayToggle && enabled && holdingRod) {
        display.show()
        let toggle = FishingUtils.getSetting("Fishing Display", "Background")
        let custom = FishingUtils.getSetting("Fishing Display", "Background Color")
        let alpha = FishingUtils.getSetting("Fishing Display", "Background Opacity")
        let color = Renderer.color(custom[0], custom[1], custom[2], alpha)
        if (toggle) {
            display.setBackground(DisplayHandler.Background.FULL)
            display.setBackgroundColor(color)
        } else {
            display.setBackground(DisplayHandler.Background.NONE)
        }
        let align = FishingUtils.getSetting("Fishing Display", "Text Align").toLowerCase()
        let order = (FishingUtils.getSetting("Fishing Display", "Line Order") === "Top to Bottom") ? "down" : "up"
        display.setAlign(align)
        display.setOrder(order)
    } else display.hide()
    if (orbToggle && enabled && holdingRod) orbDisplayToggle = true
    else orbDisplayToggle = false
})

//Update Display on Settings
register("step", () => {
    if (!FishingUtils.gui.isOpen()) return
    if (!FishingUtils.getSetting("Miscellaneous", "Continuously Refresh Display on Settings Menu")) return
    updateDisplay()
    updateOrbDisplay()

})

//Display Updater
function updateDisplay() {
    display.clearLines()
    if (!stats.retroactive) {
        display.addLine("&eSpeak to the &6Dockmaster &eto display your stats!")
        return
    }
    let progress = goalProgress()
    let caught = (FishingUtils.getSetting("Fishing Display", "Shorten Text")) ? "" : " Caught"
    let orbText = simplerTimes ? "Orbs" : "Mythical Fish"
    if (stats.season !== undefined && FishingUtils.getSetting("Fishing Display", "Show Seasonal Stats")) {
        display.addLine(`&8${stats.season}`)
        display.addLine(`&7Fish${caught}: &e${thousandSeparator(stats.seasonal_fish)}${progress.seasonal_fish}`)
        display.addLine(`&7Junk${caught}: &c${thousandSeparator(stats.seasonal_junk)}${progress.seasonal_junk}`)
        display.addLine(`&7Treasure${caught}: &a${thousandSeparator(stats.seasonal_treasure)}${progress.seasonal_treasure}`)
        let total;
        (stats.orbs.total < 0) ? total = "&cUnset": total = `${thousandSeparator(stats.orbs.seasonal_total)}${progress.seasonal_mythical_fish}`
        display.addLine(`&7${orbText}${caught}: &6${total}`)
        display.addLine(`&7Total${caught}: &d${thousandSeparator(stats.seasonal_total)}${progress.seasonal_total}`)
        display.addLine(`&8Total`)
    }
    if (hasHerbivore()) {
        display.addLine(`&7Plants${caught}: &2${thousandSeparator(stats.plant)}${progress.plant}`)
    } else {
        display.addLine(`&7Fish${caught}: &e${thousandSeparator(stats.fish)}${progress.fish}`)
    }
    display.addLine(`&7Junk${caught}: &c${thousandSeparator(stats.junk)}${progress.junk}`)
    display.addLine(`&7Treasure${caught}: &a${thousandSeparator(stats.treasure)}${progress.treasure}`)
    let total;
    (stats.orbs.total < 0) ? total = "&cUnset": total = `${thousandSeparator(stats.orbs.total)}${progress.mythical_fish}`
    display.addLine(`&7${orbText}${caught}: &6${total}`)
    if (FishingUtils.getSetting("Fishing Display", "Show Mythical Fish Since Last Ultra Rare")) {
        display.addLine(`&7Bad Luck Streak: &5${thousandSeparator(stats.orbs.total - stats.orbs.last_ultra_rare)}`)
    }
    display.addLine(`&7Total${caught}: &d${thousandSeparator(stats.total)}${progress.total}`)
    if (FishingUtils.getSetting("Fishing Display", "Show Last Caught")) display.addLine(`&7Last${caught}: &b${stats.caught}`)
    if (FishingUtils.getSetting("Fishing Display", "Text Shadow")) display.getLines().forEach(el => {
        el.setShadow(true)
    })
}


//Helper functions
//separates numbers into thousands
function thousandSeparator(num) {
    if (num === undefined) return "0"
    return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, FishingUtils.getSetting("Miscellaneous", "Thousand Separator Character"))
}
//edits the decimal character to whatever the user wants
function decimalSeparator(str) {
    if (!isNaN(str)) str = str.toString()
    return str.replace(".", FishingUtils.getSetting("Miscellaneous", "Decimal Separator Character"))
}
//generates a percentage from two numbers
function percentage(num, total) {
    let percent = num / total
    if (isNaN(percent)) return "&7(0%)"
    if (percent === Infinity) return "&7(0%)"
    if (percent === 0) return "&7(0%)"
    if (percent < 0.0001) return decimalSeparator("&7(<0.01%)")
    return decimalSeparator(`&7(${Math.floor(percent * 10000) / 100}%)`)
}
//parses lines to extract the stat
function parseStat(line) {
    return parseInt(line.split(/§[26abcde]/)[1].replace(/\D/g, ''))
}
//converts keys to title case
function titleCase(str) {
    return str.replace(/_/g, " ").replace(/\w\S*/g, (txt) => txt.charAt(0).toUpperCase() + txt.slice(1))
}
//converts a number to roman numeral
function romanize(num) {
    if (isNaN(num)) return NaN
    let digits = String(+num).split(""),
        key = ["", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM",
            "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC",
            "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"
        ],
        roman = "",
        i = 3
    while (i--) roman = (key[+digits.pop() + (i * 10)] || "") + roman
    return Array(+digits.join("") + 1).join("M") + roman
}
//returns if player has herbivore enchant
function hasHerbivore() {
    const inventory = Player.getInventory()
    if (inventory === null) return false
    const rod = inventory.getStackInSlot(3)
    if (rod === null) return false
    if (rod.getID() !== 346) return false
    let lore = rod.getLore()
    return lore.join().indexOf("Herbivore") > -1
}

let lastHerbivoreCheck = hasHerbivore()
register("tick", () => {
    const inventory = Player.getContainer()
    if (inventory === null) return
    if (inventory.getName() === "Fishing Rod Enchants" || inventory.getName() === "Herbivore Upgrades") {
        let herbivoreCheck = hasHerbivore()
        if (lastHerbivoreCheck !== herbivoreCheck) {
            lastHerbivoreCheck = herbivoreCheck
            updateDisplay()
        }
    }
})

function goalProgress() {
    if (!FishingUtils.getSetting("Goals", "Goals")) return default_progress
    let progress = JSON.parse(JSON.stringify(default_progress))
    let preset = FishingUtils.getSetting("Goals", "Goal Preset")
    if (preset === "Achievements") {
        let tiers
        types = ["fish", "junk", "treasure"]
        if (stats.season_name === "Summer") types.push("seasonal_treasure")
        types.forEach(type => {
            let color = ""
            if (FishingUtils.getSetting("Goals", "Darken Goal Denominator")) color = darkenColor(type)
            switch (type) {
                case "fish":
                    tiers = ap_tiers.slice(1)
                    break
                case "summer_treasure":
                    tiers = [ap_tiers[0], ap_tiers[2], ap_tiers[3]]
                    break
                default:
                    tiers = ap_tiers.slice(0, -1)
            }
            let i = 0
            for (i; i < tiers.length + 1; i++) {
                if (i === tiers.length) {
                    if (stats[type] == tiers[tiers.length - 1]) progress[type] = `${color}/${thousandSeparator(tiers[tiers.length - 1])} &e(100%)`
                    break
                }
                if (stats[type] < tiers[i]) {
                    progress[type] = `${color}/${thousandSeparator(tiers[i])} ${percentage(stats[type], tiers[i])}`
                    break
                }
            }
        })
    } else if (preset === "Fishing Rewards") {
        let color = ""
        if (FishingUtils.getSetting("Goals", "Darken Goal Denominator")) color = "&6"
        for (let i = 0; i < 5; i++) {
            if (i === 4) {
                if (stats.orbs.total === master_tiers[i]) progress.mythical_fish = `${color}/${thousandSeparator(master_tiers[i])} &e(100%)`
                break
            }
            if (stats.orbs.total < master_tiers[i]) {
                progress.mythical_fish = `${color}/${thousandSeparator(master_tiers[i])} ${percentage(stats.orbs.total, master_tiers[i])}`
                break
            }
        }
        for (let i = 0; i < 5; i++) {
            if (i === 5) {
                if (stats.orbs.seasonal_total === seasonal_tiers[i]) progress.seasonal_mythical_fish = `${color}/${thousandSeparator(seasonal_tiers[i])} &e(100%)`
                break
            }
            if (stats.orbs.seasonal_total < seasonal_tiers[i]) {
                progress.seasonal_mythical_fish = `${color}/${thousandSeparator(seasonal_tiers[i])} ${percentage(stats.orbs.seasonal_total, seasonal_tiers[i])}`
                break
            }
        }
    } else {
        for (let key in data.config.goals) {
            let color = ""
            if (FishingUtils.getSetting("Goals", "Darken Goal Denominator")) color = darkenColor(key)
            let goal = data.config.goals[key]
            let stat = stats[key]
            if (key === "mythical_fish") stat = stats.orbs.total
            else if (key === "seasonal_mythical_fish") stat = stats.orbs.seasonal_total
            if (stat === goal) {
                progress[key] = `${color}/${thousandSeparator(goal)} &e(100%)`
                if (!data.config.reached_goals.includes(key)) {
                    let name = titleCase(key)
                    if (name.startsWith("Seasonal")) name = name.replace("seasonal", stats.season_name)
                    ChatLib.chat(`&e&lCongrats! &eYou reached your goal of catching &6${thousandSeparator(goal)} &e${name}!`)
                    data.config.reached_goals.push(key)
                }
            } else if (stat < goal) {
                progress[key] = `${color}/${thousandSeparator(goal)} ${percentage(stat, goal)}`
            }
        }
    }
    return progress
}

function darkenColor(type) {
    switch (type) {
        case "fish":
            return "&6"
        case "junk":
            return "&4"
        case "treasure":
            return "&2"
        case "plant":
            return "&2" //again, cant go darker...
        case "creature":
            return "&3"
        case "mythical_fish":
            return "&6" //cant go darker than gold...
        case "total":
            return "&5"
        case "seasonal_fish":
            return "&6"
        case "seasonal_junk":
            return "&4"
        case "seasonal_treasure":
            return "&2"
        case "seasonal_mythical_fish":
            return "&6"
        case "seasonal_total":
            return "&5"
    }
}

//Stat Adder
register("chat", (event) => {
    if (!enabled) return
    let find
    let basic
    let nobasic = false
    let secret = false
    let msg = ChatLib.getChatMessage(event, true)
    if (fish_re.test(msg)) {
        stats.fish++;
        basic = "&eFish"
        thousandAnnouncer("fish", stats.fish)
        if (stats.season) {
            stats.seasonal_fish++;
            thousandAnnouncer("seasonal_fish", stats.seasonal_fish);
        }
        find = fish_re;
    } else if (junk_re.test(msg)) {
        stats.junk++;
        basic = "&cJunk"
        thousandAnnouncer("junk", stats.junk)
        if (stats.season) {
            stats.seasonal_junk++;
            thousandAnnouncer("seasonal_junk", stats.seasonal_junk);
        }
        find = junk_re;
    } else if (treasure_re.test(msg)) {
        stats.treasure++;
        basic = "&aTreasure"
        thousandAnnouncer("treasure", stats.treasure)
        if (stats.season) {
            stats.seasonal_treasure++;
            thousandAnnouncer("seasonal_treasure", stats.seasonal_treasure);
        }
        find = treasure_re;
    } else if (treasure_re2.test(msg)) {
        stats.treasure++;
        basic = "&aTreasure"
        thousandAnnouncer("treasure", stats.treasure)
        if (stats.season) {
            stats.seasonal_treasure++;
            thousandAnnouncer("seasonal_treasure", stats.seasonal_treasure);
        }
        find = treasure_re2;
    } else if (plant_re.test(msg)) {
        stats.plant++;
        basic = "&2Plant"
        thousandAnnouncer("plant", stats.plant)
        find = plant_re;
    } else if (creature_re.test(msg)) {
        stats.creature++;
        basic = "&bCreature"
        thousandAnnouncer("creature", stats.creature)
        find = creature_re;
    } else if (msg.removeFormatting() === "You caught a secret fish!") {
        secret = true;
        stats.fish++;
        thousandAnnouncer("fish", stats.fish)
        if (stats.season) {
            stats.seasonal_fish++;
            thousandAnnouncer("seasonal_fish", stats.seasonal_fish);
        }
        if (FishingUtils.getSetting("Miscellaneous", "Basic Mode")) {
            cancel(event)
            let hover = new Message(event).getMessageParts()[0].getHoverValue()
            let secret = new Message(new TextComponent("&e&lSecret &7caught!").setHover("show_text", hover))
            ChatLib.chat(secret)
            nobasic = true
        } else if (crabMode) {
            cancel(event)
            let hover = new Message(event).getMessageParts()[0].getHoverValue()
            let secret = new Message(new TextComponent("&7You caught a &e&lsecret crab&7!").setHover("show_text", hover))
            ChatLib.chat(secret)
            nobasic = true
        }
    } else return
    stats.total++;
    thousandAnnouncer("total", stats.total);
    if (stats.season && find !== plant_re && find !== creature_re) {
        stats.seasonal_total++;
        thousandAnnouncer("seasonal_total", stats.seasonal_total);
    }
    if (!secret) stats.caught = msg.match(find)[1]
    else stats.caught = "secret fish"
    updateDisplay()
    saveStats()
    let oneTreasureAnnouncer = FishingUtils.getSetting("Announcer", "One Treasure Announcer")
    if (oneTreasureAnnouncer)
        if (msg.match(find)[2] === "1") ChatLib.chat(`&1&l[!] &9&l1 &b&l${msg.removeFormatting().split("1 ")[1]}`)
    if (!nobasic) {
        if (FishingUtils.getSetting("Miscellaneous", "Basic Mode")) {
            cancel(event)
            ChatLib.chat(`${basic} &7caught!`)
            return
        }
        if (crabMode) {
            if (find === fish_re) {
                cancel(event)
                ChatLib.chat("&r&7You caught a &r&eyellow crab&r&7!")
            } else if (find === junk_re) {
                cancel(event)
                ChatLib.chat("&r&7Oh no, you caught a &r&cred crab&r&7!")
            } else if (find === treasure_re || find === treasure_re2) {
                cancel(event)
                ChatLib.chat("&r&7You caught a &r&agreen crab&r&7, that's a treasure!")
            } else if (find === plant_re) {
                cancel(event)
                ChatLib.chat("&r&7You caught a &r&2dark green crab&r&7!")
            } else if (find === creature_re) {
                cancel(event)
                ChatLib.chat("&r&7You caught a &r&bcyan crab&r&7!")
            }
            return
        }
        if (catsnfish) {
            if (find === fish_re) {
                cancel(event)
                ChatLib.chat("&7You caught a &r&epufferfish&r&7!")
            }
        }
    }
})

//Thousand Announcer
function thousandAnnouncer(type, num) {
    let thousandAnnouncer = FishingUtils.getSetting("Announcer", "Thousand Announcer")
    if (!enabled || !thousandAnnouncer) return
    let increment = Number.parseInt(FishingUtils.getSetting("Announcer", "Announcer Increment").split("K")[0]) * 1000
    if (num % increment !== 0) return
    num = num / 1000
    stats.season_name = stats.season ? stats.season.split(/\d/)[0].trim() : ""
    switch (type) {
        case "fish":
            ChatLib.chat(`&6&l[!] &e&l${num}K Fish!`)
            break
        case "junk":
            ChatLib.chat(`&4&l[!] &c&l${num}K Junk!`)
            break
        case "treasure":
            ChatLib.chat(`&2&l[!] &a&l${num}K Treasure!`)
            break
        case "plant":
            ChatLib.chat(`&8&l[!] &2&l${num}K Plants!`)
            break
        case "creature":
            ChatLib.chat(`&3&l[!] &b&l${num}K Creatures!`)
            break
        case "mythical_fish":
            ChatLib.chat(`&f&l[!] &6&l${num}K Mythical Fish!`)
            break
        case "total":
            ChatLib.chat(`&5&l[!] &d&l${num}K Total!`)
            break
        case "seasonal_fish":
            ChatLib.chat(`&6&l[!] &e&l${num}K ${stats.season_name} Fish!`)
            break
        case "seasonal_junk":
            ChatLib.chat(`&4&l[!] &c&l${num}K ${stats.season_name} Junk!`)
            break
        case "seasonal_treasure":
            ChatLib.chat(`&2&l[!] &a&l${num}K ${stats.season_name} Treasure!`)
            break
        case "seasonal_mythical_fish":
            ChatLib.chat(`&f&l[!] &6&l${num}K ${stats.season_name} Mythical Fish!`)
            break
        case "seasonal_total":
            ChatLib.chat(`&5&l[!] &d&l${num}K ${stats.season_name} Total!`)
            break
    }
}

//Auto GC
register("chat", (event) => {
    let autoGC = FishingUtils.getSetting("Auto GC", "Auto GC")
    if (!enabled || !autoGC) return
    let msg = ChatLib.getChatMessage(event).removeFormatting()
    if (gc_re.test(msg)) {
        let match = msg.match(gc_re)
        let rod = new Message(event).getMessageParts()[0].getHoverValue().removeFormatting().split("Fishing Rod: ")[1]
        console.log(rod)
        let message = FishingUtils.getSetting("Auto GC", "Message")
        message = message.replaceAll("%%name%%", match[1])
        message = message.replaceAll("%%fish%%", match[2])
        message = message.replaceAll("%%lore%%", match[3])
        message = message.replaceAll("%%rod%%", rod)
        ChatLib.command(`ac ${message}`)
        debugLog(`Auto GCed ${match[1]} with ${match[2]} (${match[3]}) using ${rod}`)
    }
})

//Stat Loader
register("tick", () => {
    const inventory = Player.getContainer()
    if (inventory === null) return
    if (inventory.getName() !== "Fishing Menu") return
    const tagIndex = inventory.indexOf(421)
    if (tagIndex === -1) return
    const lore = inventory.getStackInSlot(tagIndex).getLore();
    let season_line = lore[1].removeFormatting()
    if (season_line === "Total") {
        if (stats.season !== undefined) {
            /*
            The <season> event is over! During this event, you:
            Caught <season_fish> fish (<percent>% of your total fish)
            Caught <season_junk> junk (<percent>% of your total junk)
            Caught <season_treasure> treasure (<percent>% of your total treasure)
            Which sums to <season_total> total caught (<percent>% of your overall total)
            */
            let fish_percent = decimalSeparator(Math.floor((stats.seasonal_fish / stats.fish) * 10000) / 100)
            let junk_percent = decimalSeparator(Math.floor((stats.seasonal_junk / stats.junk) * 10000) / 100)
            let treasure_percent = decimalSeparator(Math.floor((stats.seasonal_treasure / stats.treasure) * 10000) / 100)
            let mythical_fish_percent = decimalSeparator(Math.floor((stats.orbs.seasonal_total / stats.orbs.total) * 10000) / 100)
            let total_percent = decimalSeparator(Math.floor((stats.seasonal_total / stats.total) * 10000) / 100)
            ChatLib.chat(`\n&bThe &l${stats.season} &bevent is over! During this event, you:\n&eCaught &l${thousandSeparator(stats.seasonal_fish)} &efish! (&l${fish_percent}% &eof your total fish)\n&cCaught &l${thousandSeparator(stats.seasonal_junk)} &cjunk! (&l${junk_percent}% &cof your total junk)\n&aCaught &l${thousandSeparator(stats.seasonal_treasure)} &atreasure! (&l${treasure_percent}% &aof your total treasure)\n&6Caught &l${thousandSeparator(stats.orbs.seasonal_total)} &6mythical fish! (&l${mythical_fish_percent}% &6of your total mythical fish)\n&dWhich sums to &l${thousandSeparator(stats.seasonal_total)} &dtotal caught! (&l${total_percent}% &dof your overall total)\n&9&lCongrats!\n`)
        }
        stats.season = undefined
    } else {
        stats.season = season_line
    }
    let season_diff = (stats.season === undefined) ? 0 : 6
    if (stats.season !== undefined) {
        stats.season_name = stats.season.split(/\d/)[0].trim()
        stats.season_year = stats.season.split(/\D+/)[1].trim()
        debugLog(`Season: ${stats.season_name}`)
        stats.seasonal_fish = parseStat(lore[2])
        stats.seasonal_junk = parseStat(lore[3])
        stats.seasonal_treasure = parseStat(lore[4])
        stats.orbs.seasonal_total = parseStat(lore[5])
        stats.seasonal_total = stats.seasonal_fish + stats.seasonal_junk + stats.seasonal_treasure + stats.orbs.seasonal_total
    }
    (stats.season) ? stats.season_name = stats.season.split(/\d/)[0].trim(): stats.season_name = undefined
    stats.fish = parseStat(lore[2 + season_diff])
    stats.junk = parseStat(lore[3 + season_diff])
    stats.treasure = parseStat(lore[4 + season_diff])
    stats.plant = parseStat(lore[5 + season_diff])
    stats.creature = parseStat(lore[6 + season_diff])
    stats.special = parseStat(lore[7 + season_diff])
    stats.orbs.total = parseStat(lore[8 + season_diff])
    stats.total = stats.fish + stats.junk + stats.treasure + stats.orbs.total + stats.plant + stats.creature
    stats.retroactive = true
    saveStats()
    updateDisplay()
});

//Stat Saver
function saveStats() {
    FileLib.write("FishingUtils", "data.json", JSON.stringify(data))
}

//Update Data Path
function updateDataPath(dev, name) {
    if (dev === undefined) dev = false
    if (!dev) {
        sub = getSub()
        uuid = Player.getUUID()
    }
    if (data.player[uuid] === undefined) {
        data.player[uuid] = {
            "name": Player.getName(),
            "main": default_stats,
            "alpha": default_stats
        }
        new_account = true
        saveStats()
    }
    if (!dev) {
        if (sub === "alpha") stats = data.player[uuid].alpha
        else stats = data.player[uuid].main
    }
    if (dev) {
        data.player[uuid].name = name
        saveStats()
    } else data.player[uuid].name = Player.getName()
}

//Dockmaster Waypoint
register("renderWorld", () => {
    let dockmasterWaypoint = FishingUtils.getSetting("Miscellaneous", "Dockmaster Waypoint")
    if (!enabled || !dockmasterWaypoint) return
    const item = Player.getInventory().getStackInSlot(3)
    if (item === null || item.getID() !== 346) {
        renderBeaconBeam(23, 62, -36, 1, 1, 0.33, 1, 1)
        return
    }
})

//Hide LB Switch Messages
register("chat", (event) => {
    let hideLB = FishingUtils.getSetting("Miscellaneous", "Hide Leaderboard Switch Messages")
    if (!enabled || !hideLB) return
    let msg = ChatLib.getChatMessage(event).removeFormatting()
    if (lb_re.test(msg)) {
        cancel(event)
    }
})


//Commands
register("command", (...args) => {
    let command
    if (args !== undefined) command = args[0]
    switch (command) {
        case "help":
            ChatLib.chat(new Message(`&3Fishing&9Utils &ev&6${metadata.version}`,
                "\n&eSettings: ",
                new TextComponent("&a&l[OPEN]").setHover("show_text", "&6Click to open the settings").setClick("run_command", "/fu"),
                " ",
                new TextComponent("&c&l[RESET]").setHover("show_text", "&6Click to reset your settings").setClick("run_command", "/fu reset"),
                "\n&eGuide: ",
                new TextComponent("&a&l[OPEN]").setHover("show_text", "&6Click to open the guide").setClick("run_command", "/fu guide"),
                "\n&eResources: ",
                new TextComponent("&a&l[OPEN]").setHover("show_text", "&6Click to open the resource list").setClick("run_command", "/fu resources"),
                "\n&eKeys: ",
                new TextComponent("&a&l[API]").setHover("show_text", "&6Click to set your Hypixel API Key").setClick("run_command", "/fu key")
            ))
            break
        case "reset":
            if (args[1] === "confirm") {
                data.config.displayPos.x = 10
                data.config.displayPos.y = 10
                display.setRenderLoc(10, 10)
                saveStats()
                FishingUtils.reset()
                ChatLib.chat("&aSettings reset!")
            } else ChatLib.chat(new Message("&cAre you sure you want to reset your settings?\n",
                new TextComponent("&a&l[CONFIRM]").setHover("show_text", "&6Click to reset your settings").setClick("run_command", "/fu reset confirm")))
            break
        case "move":
            if (args[1] === "mythic") {
                if (FishingUtils.getSetting("Mythic Display", "Lock Display to Top Right")) {
                    ChatLib.chat("&cYou must disable the &4Lock Display to Top Right &csetting to move the mythic display.")
                    return
                }
                orbDisplayPos.open()
            } else displayPos.open()
            break
        case "testautogc":
            new Message("&a&oIf the message was\n",
                new TextComponent("&b[MVP&c+&b] Steve &acaught &e&lNemo&a! Maybe he's lost again?").setHover("show_text", "&7Fishing Rod: &6Fishing Rod &l3000"),
                "\n&a&oyou'd say\n&dYou&f: ",
                FishingUtils.getSetting("Auto GC", "Message").replaceAll("%%name%%", "Steve").replaceAll("%%fish%%", "Nemo").replaceAll("%%lore%%", "Maybe he's lost again?").replaceAll("%%rod%%", "Fishing Rod 3000")).chat()
            break
        case "guide":
            ChatLib.chat(`&eOpening the guide...`)
            guide.display()
            break
        case "resources":
            ChatLib.chat(`&eOpening the resource list...`)
            resources.display()
            break
        case "key":
            if (args[1] === undefined) {
                ChatLib.chat(new Message("&eSet your Hypixel API Key to enable the Hypixel API features.\n&eRun ",
                    new TextComponent("&6/fu key <key>").setHover("show_text", "&6Click to put in chat").setClick("suggest_command", "/fu key "),
                    " &eto set your key."
                ))
                return
            }
            let key = args[1]
            ChatLib.chat("&aKey set!")
            data.config.key = key
            API_KEY = key
            saveStats()
            break
        case "goal":
        case "goals":
            if (args[1] === undefined) {
                let message = new Message(
                    new TextComponent("\n&eUse /fu goals <key> <value> to set a goal.\n").setHover("show_text", "&6Click to put in chat").setClick("suggest_command", "/fu goals "),
                    new TextComponent("&6Use /fu goals <key> to remove a goal.\n").setHover("show_text", "&6Click to put in chat").setClick("suggest_command", "/fu goals "),
                    new TextComponent("&eUse /fu goals list to list all goals.\n").setHover("show_text", "&6Click to list your goals").setClick("run_command", "/fu goals list"),
                    new TextComponent("&6Use /fu goals reset to reset all goals.\n").setHover("show_text", "&6Click to reset your goal").setClick("run_command", "/fu goals reset"),
                    new TextComponent("&e&lHover over this line for a list of keys.").setHover("show_text", "&eKeys:\n&6fish\n&ejunk\n&6treasure\n&eplant\n&6creature\n&emythical_fish\n&6total\n&eseasonal_fish\n&6seasonal_junk\n&eseasonal_treasure\n&6seasonal_mythical_fish\n&eseasonal_total"),
                )
                if (!FishingUtils.getSetting("Goals", "Goals")) message.addTextComponent(new TextComponent("\n&cGoals are currently disabled! Enable them in the settings menu."))
                ChatLib.chat(message)
                return
            }
            if (args[1] === "list") {
                if (Object.keys(data.config.goals).length === 0) {
                    ChatLib.chat("&cNo goals set! Use /fu goals <key> <value> to set a goal.")
                    return
                }
                let message = new Message("&e&lGoals:")
                let reached = false
                for (let key in data.config.goals) {
                    let goal = data.config.goals[key]
                    let prestige = ""
                    if (data.config.reached_goals.includes(key)) {
                        prestige = " &e(Reached)"
                        reached = true
                    }
                    message.addTextComponent(new TextComponent(`\n&e${titleCase(key)}: &6${thousandSeparator(goal)}${prestige}`).setHover("show_text", `&6Click to remove goal for ${key.replace("_", " ")}`).setClick("run_command", `/fu goals ${key}`))
                }
                if (reached) message.addTextComponent(new TextComponent("\n&6Click this line to remove all reached goals.").setClick("run_command", "/fu goals removereachedgoals").setHover("show_text", "&6Click to remove all reached goals."))
                ChatLib.chat(message)
                return
            }
            if (args[1] === "removereachedgoals") {
                let reached = false
                for (let key in data.config.goals) {
                    if (data.config.reached_goals.includes(key)) {
                        reached = true
                        delete data.config.goals[key]
                    }
                }
                if (reached) {
                    data.config.reached_goals = []
                    saveStats()
                    updateDisplay()
                    ChatLib.chat("&aReached goals removed!")
                } else ChatLib.chat("&cNo reached goals!")
                return
            }
            if (args[1] === "reset") {
                data.config.goals = {}
                data.config.reached_goals = []
                saveStats()
                updateDisplay()
                ChatLib.chat("&aGoals reset!")
                return
            }
            if (goal_keys.includes(args[1])) {
                if (args[2] === undefined) {
                    delete data.config.goals[args[1]]
                    ChatLib.chat(`&aRemoved goal for ${args[1].replace("_", " ")}`)
                    if (data.config.reached_goals.includes(args[1])) data.config.reached_goals = data.config.reached_goals.filter((e) => e !== args[1])
                    saveStats()
                    updateDisplay()
                    return
                }
                let value = Number.parseInt(args[2])
                if (isNaN(value) || value < 0) {
                    ChatLib.chat("&cInvalid value!")
                    return
                }
                data.config.goals[args[1]] = value
                ChatLib.chat(`&aSet goal for ${args[1]} to ${thousandSeparator(value)}`)
                if (data.config.reached_goals.includes(args[1])) data.config.reached_goals = data.config.reached_goals.filter((e) => e !== args[1])
                saveStats()
                updateDisplay()
                return
            }
            ChatLib.chat(`&cUnknown key "${args[1]}"!`)
            break
        case "enable":
            ChatLib.chat("&eForcefully enabling the mod.")
            enabled = true
            break
        case "dev":
            switch (args[1]) {
                case "setstat":
                    if (args[2] === undefined || args[3] === undefined) {
                        ChatLib.chat("&cUsage: /fu dev setstat <key> <value>")
                        return
                    }
                    if (!dev_stat.includes(args[2])) {
                        ChatLib.chat("&cInvalid stat!")
                        return
                    }
                    if (isNaN(Number.parseInt(args[3]))) {
                        ChatLib.chat("&cInvalid value!")
                        return
                    }
                    stats[args[2]] = Number.parseInt(args[3])
                    saveStats()
                    updateDisplay()
                    ChatLib.chat(`&aSet stat ${args[2]} to ${args[3]}`)
                    break
                case "setseason":
                    if (args[2] === undefined || args[3] === undefined) {
                        ChatLib.chat("&cUsage: /fu dev setseason <season_name> <year>")
                        return
                    }
                    if (!args[2].match(/^(\w+)$/) && !args[3].match(/^(\w+) (\d+)$/)) {
                        ChatLib.chat("&cInvalid season!")
                        return
                    }
                    stats.season = args[2] + " " + args[3]
                    stats.season_name = args[2]
                    saveStats()
                    updateDisplay()
                    ChatLib.chat(`&aSet season to ${args[2]} ${args[3]}`)
                    break
                case "removeseason":
                    stats.season = undefined
                    stats.season_name = undefined
                    saveStats()
                    updateDisplay()
                    ChatLib.chat(`&aRemoved season`)
                    break
                case "setorb":
                    if (args[2] === undefined || args[3] === undefined) {
                        ChatLib.chat("&cUsage: /fu dev setorb <orb_name> <amount>")
                        return
                    }
                    if (!(args[2] in stats.orbs)) {
                        ChatLib.chat("&cInvalid orb!")
                        return
                    }
                    if (isNaN(Number.parseInt(args[3]))) {
                        ChatLib.chat("&cInvalid value!")
                        return
                    }
                    stats.orbs[args[2]] = Number.parseInt(args[3])
                    saveStats()
                    updateDisplay()
                    updateOrbDisplay()
                    ChatLib.chat(`&aSet orb ${args[2]} to ${args[3]}`)
                    break
                case "setretroactive":
                    if (args[2] === undefined) {
                        ChatLib.chat("&cUsage: /fu dev setretroactive <true/false>")
                        return
                    }
                    if (args[2] === "true") {
                        stats.retroactive = true
                        ChatLib.chat("&aSet retroactive to true")
                    } else if (args[2] === "false") {
                        stats.retroactive = false
                        ChatLib.chat("&aSet retroactive to false")
                    } else {
                        stats.retroactive = !stats.retroactive
                        ChatLib.chat(`&eSet retroactive to ${stats.retroactive}`)
                    }
                    saveStats()
                    updateDisplay()
                    break
                case "setsub":
                    if (args[2] === undefined) {
                        ChatLib.chat("&cUsage: /fu dev setsub <main/alpha>")
                        return
                    }
                    if (args[2] === "main") {
                        stats = data.player[uuid].main
                        ChatLib.chat("&aSet sub to main")
                    } else if (args[2] === "alpha") {
                        stats = data.player[uuid].alpha
                        ChatLib.chat("&aSet sub to alpha")
                    } else {
                        ChatLib.chat("&cInvalid sub!")
                        return
                    }
                    saveStats()
                    updateDisplay()
                    updateOrbDisplay()
                    break
                case "generatefakeaccount":
                    uuid = "fakeaccount" + Math.floor(Math.random() * 10000)
                    updateDataPath(true, "Fake_" + Math.floor(Math.random() * 10000))
                    ChatLib.chat("&aGenerated fake account!")
                    break
                case "removefakeaccounts":
                    let removed = 0
                    for (let key in data.player) {
                        if (key.startsWith("fakeaccount")) {
                            delete data.player[key]
                            removed++
                        }
                    }
                    ChatLib.chat(`&aRemoved ${removed} fake account(s)!`)
                    saveStats()
                    break
                case "setlastultrarare":
                    if (args[2] === undefined) {
                        ChatLib.chat("&eCurrently set to " + stats.orbs.last_ultra_rare + "\n&cUsage: /fu dev setlastultrarare <number>")
                        return
                    }
                    if (args[2] === "current") {
                        args[2] = stats.orbs.total
                    }
                    if (isNaN(Number.parseInt(args[2]))) {
                        ChatLib.chat("&cInvalid value!")
                        return
                    }
                    stats.orbs.last_ultra_rare = Number.parseInt(args[2])
                    saveStats()
                    updateDisplay()
                    updateOrbDisplay()
                    ChatLib.chat("&aSet last ultra rare to " + stats.orbs.last_ultra_rare)
                    break
                default:
                    ChatLib.chat("&eThis is the dev command; use tab to see subcommands.\n&cThese commands can break your save file, use at your own risk!")
                    break
            }
            break
        default:
            FishingUtils.open()
    }
}).setTabCompletions((args) => {
    if (args.length === 1) return fu_subs.filter(sub => sub.startsWith(args[0].toLowerCase()))
    else if (args.length === 2) {
        if (args[0] === "reset") return ["confirm"]
        else if (args[0] === "goals") return goal_keys.filter(sub => sub.startsWith(args[1].toLowerCase()))
        else if (args[0] === "dev") return dev_subs.filter(sub => sub.startsWith(args[1].toLowerCase()))
        else return [""]
    } else return [""]
}).setName("fishingutils").setAliases("fu")

function createOrbArray(orbs) {
    return [
        ["&eEmber of Helios", orbs.helios, orbs.weight.helios],
        ["&eDust of Selene", orbs.selene, orbs.weight.selene],
        ["&aShadow of Nyx", orbs.nyx, orbs.weight.nyx],
        ["&aHeart of Aphrodite", orbs.aphrodite, orbs.weight.aphrodite],
        ["&bSpark of Zeus", orbs.zeus, orbs.weight.zeus],
        ["&bSpirit of Demeter", orbs.demeter, orbs.weight.demeter],
        ["&dAutomaton of Daedalus", orbs.archimedes, orbs.weight.archimedes],
        ["&dWrath of Hades", orbs.hades, orbs.weight.hades]
    ]
}

function colorRange(value, min, max) {
    if (!value) value = 0
    if (value <= min) return "&c✖"
    if (value >= max) return "&a✔"
    return "&e" + value
}

register("command", (username, modifier) => {
    if (username === undefined) {
        if (!stats.retroactive) {
            ChatLib.chat("&cYour stats haven't been loaded yet! Speak to the Dock Master to load them.")
            return
        }
        let message = new Message(new TextComponent(`&bYour Fishing Stats`).setHover("show_text", `&bClick to view your stats online`).setClick("open_url", `https://plancke.io/hypixel/player/stats/${Player.getName()}#Fishing:~:text=©`));
        if (stats.season !== undefined) {
            message.addTextComponent(`\n&8${stats.season} ${percentage(stats.seasonal_total, stats.total)}\n&7 - Fish Caught: &e${thousandSeparator(stats.seasonal_fish)}\n&7 - Junk Caught: &c${thousandSeparator(stats.seasonal_junk)}\n&7 - Treasure Caught: &a${thousandSeparator(stats.seasonal_treasure)}`)
            if (stats.orbs.seasonal_total < 0) message.addTextComponent("\n&7 - Mythical Fish Caught: &cUnset")
            else {
                message.addTextComponent(`\n&7 - Mythical Fish Caught: &6${thousandSeparator(stats.orbs.seasonal_total)} ${percentage(stats.orbs.seasonal_total, stats.orbs.total)}`)
            }
            message.addTextComponent(`\n&7 - Total Caught: &d${thousandSeparator(stats.seasonal_total)}`)
        }
        message.addTextComponent(`\n&8Total\n&7 - Fish Caught: &e${thousandSeparator(stats.fish)} ${percentage(stats.fish, stats.total)}`)
        message.addTextComponent(`\n&7 - Junk Caught: &c${thousandSeparator(stats.junk)} ${percentage(stats.junk, stats.total)}`)
        message.addTextComponent(`\n&7 - Treasure Caught: &a${thousandSeparator(stats.treasure)} ${percentage(stats.treasure, stats.total)}`)
        message.addTextComponent(`\n&7 - Plants Caught: &2${thousandSeparator(stats.plant)} ${percentage(stats.plant, stats.total)}`)
        message.addTextComponent(`\n&7 - Creatures Caught: &b${thousandSeparator(stats.creature)} ${percentage(stats.creature, stats.total)}`)
        if (stats.orbs.total < 0) {
            message.addTextComponent("\n&7 - Mythical Fish Caught: &cUnset")
        } else {
            let orb_data = createOrbArray(stats.orbs)
            let hover = "&cMythical Fish Caught"
            for (let i = 0; i < orb_names.length; i++) {
                let orb = orb_data[i]
                hover += `\n${orb[0]}: &6${thousandSeparator(orb[1])}`
                if (orb[2] > 0) {
                    let color = "&f"
                    if (orb[2] === maximumWeightValues[orb_names[i]]) color = "&6"
                    hover += ` &7| ${color}${orb[2]}kg`
                }
                hover += ` ${percentage(orb[1], stats.orbs.total)}`
            }
            message.addTextComponent(new TextComponent(`\n&7 - Mythical Fish Caught: &6${thousandSeparator(stats.orbs.total)} ${percentage(stats.orbs.total, stats.total)}`).setHover("show_text", hover))
        }
        message.addTextComponent(`\n&7 - Total Caught: &d${thousandSeparator(stats.total)}`)
        ChatLib.chat(message)
        return
    }
    if (API_KEY === "NONE") {
        ChatLib.chat("&cYou need to set your API Key before you can use this command!")
        return
    }
    if (!name_re.test(username)) {
        ChatLib.chat("&cError: That username is invalid.")
        return
    }
    request(`https://api.mojang.com/users/profiles/minecraft/${username}`)
        .then((response) => {
            if (response.length == 0) {
                ChatLib.chat("&cError: That player does not exist.")
                return
            }
            let data = JSON.parse(response);
            request(`https://api.hypixel.net/player?key=${API_KEY}&uuid=${data.id}`)
                .then((response) => {
                    let h_data = JSON.parse(response)
                    if (h_data.player === null) {
                        ChatLib.chat(`&cError: ${data.name} has not joined Hypixel.`)
                        return
                    }
                    let displayname = h_data.player.displayname
                    if (FishingUtils.getSetting("/fs", "Style Name")) displayname = styleName(h_data)
                    if (h_data.player.stats === null || h_data.player.stats === undefined) {
                        ChatLib.chat(`&cError: ${displayname} &chas no visible stats.`)
                        return
                    }
                    let lobby = h_data.player.stats.MainLobby
                    let fishing
                    if (lobby !== undefined) fishing = lobby.fishing
                    if (fishing === undefined || fishing.stats === undefined || fishing.stats.permanent === undefined) {
                        ChatLib.chat(`&cError: ${displayname} &chas not fished.`)
                        return
                    }
                    let perm = fishing.stats.permanent
                    let orbs = fishing.orbs
                    let specials = []
                    if (fishing.special_fish !== undefined) {
                        for (let key in fishing.special_fish) {
                            specials.push(key)
                        }
                        specials.sort()
                    }
                    if (FishingUtils.getSetting("/fs", "Ignore Old Mahi Mahi")) {
                        specials = specials.filter((el) => el !== "mahi-mahi")
                    }
                    let seasonal
                    if (stats.season) {
                        let season_name = stats.season_name.toLowerCase()
                        if (season_name == "holidays") season_name = "christmas"
                        if (fishing.stats[stats.season_year] !== undefined && fishing.stats[stats.season_year][season_name] !== undefined) seasonal = fishing.stats[stats.season_year][season_name]
                        else seasonal = {}
                    }
                    let fishing_stats = {
                        fish: 0,
                        junk: 0,
                        treasure: 0,
                        plant: 0,
                        creature: 0,
                        total: 0,
                        seasonal_fish: 0,
                        seasonal_junk: 0,
                        seasonal_treasure: 0,
                        seasonal_plant: 0,
                        seasonal_creature: 0,
                        seasonal_orb: 0,
                        seasonal_total: 0,
                        orbs: {
                            helios: 0,
                            selene: 0,
                            nyx: 0,
                            aphrodite: 0,
                            zeus: 0,
                            demeter: 0,
                            archimedes: 0,
                            hades: 0,
                            total: 0,
                            weight: {
                                helios: -1,
                                selene: -1,
                                nyx: -1,
                                aphrodite: -1,
                                zeus: -1,
                                demeter: -1,
                                archimedes: -1,
                                hades: -1
                            }
                        },
                        overall: 0
                    }

                    let environment = modifier === undefined ? "" : modifier.toLowerCase()
                    if (!env_list.includes(environment)) environment = ""
                    type_list.forEach(el => {
                        env_list.forEach(env => {
                            if (perm[env] !== undefined && perm[env][el] !== undefined) {
                                if (environment === "" || environment === env) {
                                    fishing_stats[el] += perm[env][el]
                                    fishing_stats.total += perm[env][el]
                                }
                                fishing_stats.overall += perm[env][el]
                            }
                            if (seasonal) {
                                if (seasonal[env] !== undefined && seasonal[env][el] !== undefined) {
                                    if (environment === "" || environment === env) {
                                        fishing_stats[`seasonal_${el}`] += seasonal[env][el]
                                        fishing_stats.seasonal_total += seasonal[env][el]
                                    }
                                }
                            }
                        })
                    })
                    if (orbs !== undefined) {
                        orb_names.forEach(el => {
                            if (orbs[el] !== undefined) {
                                fishing_stats.orbs[el] = orbs[el]
                                fishing_stats.orbs.total += orbs[el]
                            }
                        })
                        if (orbs.weight) {
                            orb_names.forEach(el => {
                                if (orbs.weight[el] !== undefined) {
                                    fishing_stats.orbs.weight[el] = orbs.weight[el]
                                }
                            })
                        }
                        if (!environment) fishing_stats.total += fishing_stats.orbs.total
                    }
                    let fish_data = [
                        ["Fish", "&e", fishing_stats.fish],
                        ["Junk", "&c", fishing_stats.junk],
                        ["Treasure", "&a", fishing_stats.treasure],
                        ["Plant", "&2", fishing_stats.plant],
                        ["Creature", "&b", fishing_stats.creature]
                    ]
                    let special_hover = "&cSpecial Fish:"
                    specials.forEach(el => {
                        special_hover += `\n&e${titleCase(el)}`
                    })
                    let orb_data = createOrbArray(fishing_stats.orbs)
                    let orb_hover = "&cMythical Fish Caught"
                    for (let i = 0; i < orb_names.length; i++) {
                        orb_hover += `\n${orb_data[i][0]}: &6${thousandSeparator(orb_data[i][1])}`
                        if (orb_data[i][2] > 0) {
                            let color = "&f"
                            if (orb_data[i][2] === maximumWeightValues[orb_names[i]]) color = "&6"
                            orb_hover += ` &7| ${color}${orb_data[i][2]}kg`
                        }
                        orb_hover += ` ${percentage(orb_data[i][1], fishing_stats.orbs.total)}`
                    }
                    orb_hover += (`\n&9Total: &6${thousandSeparator(fishing_stats.orbs.total)}`)
                    let profile_hover = `&bClick to view ${displayname}'s stats online`
                    let lineBreakNeeded = false
                    if (fishing.activeFishHookTrail) {
                        lineBreakNeeded = true
                        if (trail_dictionary[fishing.activeFishHookTrail] !== undefined) profile_hover += `\n&7Fish Hook Trail: &a${trail_dictionary[fishing.activeFishHookTrail]}`
                        else profile_hover += `\n&7Fish Hook Trail: &a${titleCase(fishing.activeFishHookTrail)}`

                    }
                    if (fishing.activeFishingRod) {
                        lineBreakNeeded = true
                        if (rod_dictionary[fishing.activeFishingRod] !== undefined) profile_hover += `\n&7Fishing Rod: ${rod_dictionary[fishing.activeFishingRod]}`
                        else profile_hover += `\n&7Fishing Rod: &a${fishing.activeFishingRod}`
                    }
                    if (lobby.fishing_reward_tracked) {
                        lineBreakNeeded = true
                        profile_hover += "\n&7Tracked Reward: &a"
                        let tier = lobby.fishing_reward_tracked.slice(lobby.fishing_reward_tracked.lastIndexOf("_") + 1)
                        if (lobby.fishing_reward_tracked.startsWith("permanent")) {
                            profile_hover += "Master Reward Tier " + tier.toUpperCase()
                        } else {
                            profile_hover += titleCase(tier.slice(0, tier.lastIndexOf(" "))) + tier.slice(tier.lastIndexOf(" ")).toUpperCase()
                        }
                    }
                    if (FishingUtils.getSetting("/fs", "Show More Info in Hover") && lobby.leaderboardSettings) {
                        profile_hover += "\n&7Selected Leaderboard: "
                        switch (lobby.leaderboardSettings.fishingType) {
                            case "FISH":
                                profile_hover += "&eFish"
                                break
                            case "JUNK":
                                profile_hover += "&cJunk"
                                break
                            case "TREASURE":
                                profile_hover += "&aTreasure"
                                break
                            case "MYTHICAL_FISH":
                                profile_hover += "&6Mythical Fish"
                                break
                            default:
                                profile_hover += "&cUnknown"
                                break
                        }
                    }
                    if (fishing.enchants) {
                        if (lineBreakNeeded) profile_hover += "\n"
                        profile_hover += "\n&6Enchants:"
                        for (let key in fishing.enchants) {
                            if (enchant_dictionary[key] !== undefined) profile_hover += `\n&7${enchant_dictionary[key]}: `
                            else profile_hover += `\n&7${titleCase(key)}: `
                            if (fishing.enchants[key].toggle !== undefined) profile_hover += `&${fishing.enchants[key].toggle ? "a" : "c"}`
                            else profile_hover += "&6"
                            if (fishing.enchants[key].level !== undefined) profile_hover += (FishingUtils.getSetting("/fs", "Use Roman Numerals for Enchants")) ? romanize(fishing.enchants[key].level) : fishing.enchants[key].level
                            else if (fishing.enchants[key].toggle !== undefined) profile_hover += `${fishing.enchants[key].toggle ? "✔" : "✖"}`
                            else profile_hover += "?"
                        }
                    }
                    if (FishingUtils.getSetting("/fs", "Show More Info in Hover")) {
                        if (fishing.settings) {
                            profile_hover += "\n\n&6Menu Settings:"
                            for (let key in fishing.settings) {
                                if (settings_dictionary[key] !== undefined) profile_hover += `\n&7${settings_dictionary[key]}: `
                                else profile_hover += `\n&7${titleCase(key)}: `
                                if (settings_value_dictionary[key] !== undefined) profile_hover += `${settings_value_dictionary[key][fishing.settings[key]]}`
                                else profile_hover += `&${fishing.settings[key] ? "a✔" : "c✖"}`
                            }
                        }
                        profile_hover += "\n\n&6NPCs Interacted With:"
                        let npcs = []
                        if (lobby.questNPCTutorials)
                            for (let key in lobby.questNPCTutorials) npcs.push(key)
                        profile_hover += "\n&7Dock Master: "
                        if (npcs.includes("dockmaster")) profile_hover += "&a✔"
                        else profile_hover += "&c✖"
                        profile_hover += "\n&7Vulcan's Dock Master: "
                        if (npcs.includes("lava_fisherman")) profile_hover += "&a✔"
                        else profile_hover += "&c✖"
                        profile_hover += "\n&7Neptune's Nereid: "
                        if (fishing.ice && fishing.ice.spokenToNereid) profile_hover += "&a✔"
                        else profile_hover += "&c✖"
                        if (lobby.packages) {
                            profile_hover += "\n\n&6Packages:"
                            lobby.packages.forEach(el => {
                                profile_hover += "\n&7 - " + el
                            })
                        }
                        if (fishing.fireproofing) profile_hover += `\n\n&6Fireproofing:\n&7Flame of the Sun Titan: ${colorRange(fishing.fireproofing.flame, 0, 1)}\n&710 Salmon Scales: ${colorRange(fishing.fireproofing.scales, 0, 10)}\n&7Curing Process: ${colorRange(fishing.fireproofing.sealant, 0, 1)}`
                    }
                    let master = ""
                    if (FishingUtils.getSetting("/fs", "Show Master Tier")) {
                        if (fishing_stats.fish >= 100000) master = " &e[4]"
                        else if (fishing_stats.fish >= 50000) master = " &d[3]"
                        else if (fishing_stats.fish >= 25000) master = " &9[2]"
                        else if (fishing_stats.fish >= 10000) master = " &a[1]"
                        else master = " &7[0]"
                    }
                    let message = new Message(new TextComponent(`&b${displayname}${master}&b's Fishing Stats`).setHover("show_text", profile_hover).setClick("open_url", `https://plancke.io/hypixel/player/stats/${data.name}#Fishing:~:text=©`))
                    switch (environment) {
                        case "water":
                            message.addTextComponent("\n&7Environment: &9WATER ")
                            break
                        case "lava":
                            message.addTextComponent("\n&7Environment: &cLAVA ")
                            break
                        case "ice":
                            message.addTextComponent("\n&7Environment: &bICE ")
                            break
                        default:
                            break
                    }
                    if (environment !== "") message.addTextComponent(percentage(fishing_stats.total, fishing_stats.overall))
                    if (seasonal) {
                        message.addTextComponent(`\n&8${stats.season} ${percentage(fishing_stats.seasonal_total, fishing_stats.total)}`)
                        message.addTextComponent(`\n&7 - Fish Caught: &e${thousandSeparator(fishing_stats.seasonal_fish)} ${percentage(fishing_stats.seasonal_fish, fishing_stats.seasonal_total)}`)
                        message.addTextComponent(`\n&7 - Junk Caught: &c${thousandSeparator(fishing_stats.seasonal_junk)} ${percentage(fishing_stats.seasonal_junk, fishing_stats.seasonal_total)}`)
                        message.addTextComponent(`\n&7 - Treasure Caught: &a${thousandSeparator(fishing_stats.seasonal_treasure)} ${percentage(fishing_stats.seasonal_treasure, fishing_stats.seasonal_total)}`)
                        message.addTextComponent(`\n&7 - Plants Caught: &2${thousandSeparator(fishing_stats.seasonal_plant)} ${percentage(fishing_stats.seasonal_plant, fishing_stats.seasonal_total)}`)
                        message.addTextComponent(`\n&7 - Creatures Caught: &b${thousandSeparator(fishing_stats.seasonal_creature)} ${percentage(fishing_stats.seasonal_creature, fishing_stats.seasonal_total)}`)
                        message.addTextComponent(`\n&7 - Mythical Fish Caught: &6${thousandSeparator(fishing_stats.seasonal_orb)} ${percentage(fishing_stats.seasonal_orb, fishing_stats.seasonal_total)}`)
                        message.addTextComponent(`\n&7 - Total Caught: &d${thousandSeparator(fishing_stats.seasonal_total)}`)
                    }
                    message.addTextComponent("\n&8Total")
                    fish_data.forEach(el => {
                        let text = new TextComponent(`\n&7 - ${el[0]} Caught: ${el[1]}${thousandSeparator(el[2])} ${percentage(el[2], fishing_stats.total)}`)
                        if (environment === "" && perm.individual !== undefined && perm.individual[el[0].toLowerCase()] !== undefined) {
                            let hover = `${el[1]}${el[0]} Breakdown`
                            let individual = perm.individual[el[0].toLowerCase()]
                            for (let key in individual) hover += `\n&7${titleCase(key)}: ${el[1]}${thousandSeparator(individual[key])}`
                            text.setHover("show_text", hover)
                        }
                        message.addTextComponent(text)
                    })
                    if (environment === "") {
                        let orbs = new TextComponent(`\n&7 - Mythical Fish Caught: &6${thousandSeparator(fishing_stats.orbs.total)} ${percentage(fishing_stats.orbs.total, fishing_stats.total)}`)
                        if (fishing_stats.orbs.total > 0) orbs.setHover("show_text", orb_hover)
                        message.addTextComponent(orbs)
                    }
                    message.addTextComponent(`\n&7 - Total Caught: &d${thousandSeparator(fishing_stats.total)}`)
                    if (environment === "") {
                        let special = new TextComponent(`\n&7 - Special Fish: &d${specials.length}`)
                        if (specials.length > 0) special.setHover("show_text", special_hover)
                        message.addTextComponent(special)
                    }
                    message.chat()
                })
                .catch((error) => {
                    let old_e = error
                    try {
                        let data = JSON.parse(error)
                        if (!data.success) { ChatLib.chat(`&cError: ${data.cause}`); return; }
                    } catch (e) {
                        ChatLib.chat("&cAn unknown error occurred while getting the player's stats. Check the console (/ct console js) for more information.")
                        console.log(`Original Error: ${old_e}\nNew Error: ${e}`)
                    }
                })
        })
}).setTabCompletions((args) => {
    if (args.length === 1) return parseTab(args[0])
    else if (args.length === 2) return env_list.filter(sub => sub.startsWith(args[1].toLowerCase()))
    else return [""]
}).setName("fs")


register("command", (username, year, season, modifier) => {
    if (username === undefined) {
        ChatLib.chat("&cSyntax: /hfs <username> <year> <season>")
        return
    }
    let year = parseInt(year)
    if (year === undefined || isNaN(year)) {
        ChatLib.chat("&cSyntax: /hfs <username> <year> <season>")
        return
    }
    if (season === undefined) {
        ChatLib.chat("&cSyntax: /hfs <username> <year> <season>")
        return
    }
    if (API_KEY === "NONE") {
        ChatLib.chat("&cYou need to set your API Key before you can use this command!")
        return
    }
    if (!name_re.test(username)) {
        ChatLib.chat("&cError: That username is invalid.")
        return
    }
    let season = season.toLowerCase()
    if (!seasons.includes(season)) {
        ChatLib.chat("&cError: That is not a valid season.")
        return
    }
    if (year < 2022 || (year === 2022 && season !== "halloween" && season !== "christmas")) {
        ChatLib.chat("&cError: Hypixel does not have any data before Halloween 2022.")
        return
    }
    request(`https://api.mojang.com/users/profiles/minecraft/${username}`)
        .then((response) => {
            if (response.length == 0) {
                ChatLib.chat("&cError: That player does not exist.")
                return
            }
            let data = JSON.parse(response);
            request(`https://api.hypixel.net/player?key=${API_KEY}&uuid=${data.id}`)
                .then((response) => {
                    let h_data = JSON.parse(response)
                    if (h_data.player === null) {
                        ChatLib.chat(`&cError: ${data.name} has not joined Hypixel.`)
                        return
                    }
                    let displayname = h_data.player.displayname
                    if (FishingUtils.getSetting("/fs", "Style Name")) displayname = styleName(h_data)
                    if (h_data.player.stats === null) {
                        ChatLib.chat(`&cError: ${displayname} &chas their stats hidden.`)
                        return
                    }
                    let lobby = h_data.player.stats.MainLobby
                    let fishing
                    if (lobby !== undefined) fishing = lobby.fishing
                    if (fishing === undefined) {
                        ChatLib.chat(`&cError: ${displayname} &chas not fished.`)
                        return
                    }
                    let perm = fishing.stats.permanent
                    let season_data = fishing.stats[year]
                    if (season_data !== undefined) season_data = season_data[season]
                    if (season_data === undefined) {
                        ChatLib.chat(`&cError: ${displayname} &chas not fished in ${titleCase(season)} ${year}.`)
                        return
                    }
                    // let environment = ""
                    // if (modifier !== undefined)
                    //     if (modifier.toLowerCase() === "lava" || modifier.toLowerCase() === "water") environment = modifier.toLowerCase()
                    let fishing_stats = {
                        fish: 0,
                        junk: 0,
                        treasure: 0,
                        plant: 0,
                        creature: 0,
                        mythical_fish: 0,
                        total: 0,
                        seasonal_fish: 0,
                        seasonal_junk: 0,
                        seasonal_treasure: 0,
                        seasonal_plant: 0,
                        seasonal_creature: 0,
                        seasonal_mythical_fish: 0,
                        seasonal_total: 0,
                        overall: 0,
                        seasonal_overall: 0
                    }
                    const countMythicalFish = (year > 2023 || (year === 2023 && (season === "halloween" || season === "christmas")))
                    let environment = modifier === undefined ? "" : modifier.toLowerCase()
                    if (!env_list.includes(environment)) environment = ""
                    type_list.forEach(el => {
                        env_list.forEach(env => {
                            if (perm[env] !== undefined && perm[env][el] !== undefined) {
                                if (environment === "" || environment === env) {
                                    fishing_stats[el] += perm[env][el]
                                    fishing_stats.total += perm[env][el]
                                }
                                fishing_stats.overall += perm[env][el]
                            }
                            if (season_data[env] !== undefined && season_data[env][el] !== undefined) {
                                if (environment === "" || environment === env) {
                                    fishing_stats[`seasonal_${el}`] += season_data[env][el]
                                    fishing_stats.seasonal_total += season_data[env][el]
                                }
                                fishing_stats.seasonal_overall += season_data[env][el]
                            }
                        })
                    })
                    if (countMythicalFish) {
                        env_list.forEach(env => {
                            if (season_data[env] !== undefined && season_data[env].orb !== undefined) {
                                if (environment === "" || environment === env) {
                                    fishing_stats.seasonal_mythical_fish += season_data[env].orb
                                    fishing_stats.seasonal_total += season_data[env].orb
                                }
                                fishing_stats.seasonal_overall += season_data[env].orb
                            }
                        })
                        if (fishing.orbs) {
                            orb_names.forEach(el => {
                                if (fishing.orbs[el] !== undefined) {
                                    fishing_stats.mythical_fish += fishing.orbs[el]
                                    fishing_stats.total += fishing.orbs[el]
                                    fishing_stats.overall += fishing.orbs[el]
                                }
                            })
                        }
                    }
                    let array = [
                        ["Fish", "&e", fishing_stats.seasonal_fish, fishing_stats.fish],
                        ["Junk", "&c", fishing_stats.seasonal_junk, fishing_stats.junk],
                        ["Treasure", "&a", fishing_stats.seasonal_treasure, fishing_stats.treasure],
                    ]
                    if (year > 2025 || (year === 2025 && season !== "easter")) {
                        array.push(["Plants", "&2", fishing_stats.seasonal_plant, fishing_stats.plant])
                        array.push(["Creatures", "&b", fishing_stats.seasonal_creature, fishing_stats.creature])
                    }
                    let message = new Message(`&b${displayname}&b's ${titleCase(season)} ${year} Fishing Stats`)
                    switch (environment) {
                        case "water":
                            message.addTextComponent("\n&7Environment: &9WATER ")
                            break
                        case "lava":
                            message.addTextComponent("\n&7Environment: &cLAVA ")
                            break
                        case "ice":
                            message.addTextComponent("\n&7Environment: &bICE ")
                            break
                        default:
                            break
                    }
                    if (environment) message.addTextComponent(percentage(fishing_stats.seasonal_total, fishing_stats.seasonal_overall))
                        // if (environment === "water") message.addTextComponent(`\n&7Environment: &9WATER ${percentage(fishing_stats.seasonal_total, fishing_stats.seasonal_overall)}`)
                        // if (environment === "lava") message.addTextComponent(`\n&7Environment: &cLAVA ${percentage(fishing_stats.seasonal_total, fishing_stats.seasonal_overall)}`)
                    message.addTextComponent(`\n&8${titleCase(season)} ${year}`)
                    let label = ""
                    if (environment !== "") label = ` in ${environment}`
                    array.forEach(stat => {
                        message.addTextComponent(new TextComponent(`\n&7 - ${stat[0]} Caught: ${stat[1]}${thousandSeparator(stat[2])} ${percentage(stat[2], fishing_stats.seasonal_total)}`).setHover("show_text", `${stat[1]}${orbPercentage(stat[2], stat[3])} &7of ${stat[0].toLowerCase()} caught${label}`))
                    })
                    if (countMythicalFish) message.addTextComponent(new TextComponent(`\n&7 - Mythical Fish Caught: &6${thousandSeparator(fishing_stats.seasonal_mythical_fish)} ${percentage(fishing_stats.seasonal_mythical_fish, fishing_stats.seasonal_total)}`).setHover("show_text", `&6${orbPercentage(fishing_stats.seasonal_mythical_fish, fishing_stats.mythical_fish)} &7of mythical fish caught${label}`))
                    message.addTextComponent(new TextComponent(`\n&7 - Total: &d${thousandSeparator(fishing_stats.seasonal_total)}`).setHover("show_text", `&d${orbPercentage(fishing_stats.seasonal_total, fishing_stats.total)} &7of total caught${label}`))
                    message.chat()
                })
                .catch((error) => {
                    let old_e = error
                    try {
                        let data = JSON.parse(error)
                        if (!data.success) { ChatLib.chat(`&cError: ${data.cause}`); return; }
                    } catch (e) {
                        ChatLib.chat("&cAn unknown error occurred while getting the player's stats. Check the console (/ct console js) for more information.")
                        console.log(`Original Error: ${old_e}\nNew Error: ${e}`)
                    }
                })
        })
}).setTabCompletions((args) => {
    if (args.length === 1) return parseTab(args[0])
    else if (args.length === 2) return ["2022", "2023", "2024", "2025", "2026", "2027", "2028"].filter(sub => sub.startsWith(args[1].toLowerCase()))
    else if (args.length === 3) {
        if (args[1] === "2022") return ["halloween", "christmas"].filter(sub => sub.startsWith(args[2].toLowerCase()))
        else return seasons.filter(sub => sub.startsWith(args[2].toLowerCase()))
    } else if (args.length === 4) return env_list.filter(sub => sub.startsWith(args[3].toLowerCase()))
    else return [""]
}).setName("hfs")

register("command", (...guild) => {
    let bookMenu = false
    let showOrbs = false
    let showSeason = false
    let withPlayer = false
    while (guild !== undefined && guild[0] !== undefined && guild[0].startsWith("-")) {
        let arg = guild.shift()
        if (arg === "-b") bookMenu = true
        else if (arg === "-o") showOrbs = true
        else if (arg === "-s") showSeason = true
        else if (arg === "-p") withPlayer = true
    }
    if (guild) guild = guild.join(" ")
    let url = `https://api.hypixel.net/guild?key=${API_KEY}&`
    let isOwnGuild = true
    if (guild) {
        url += `name=${guild}`
        isOwnGuild = false
    } else url += `player=${Player.getUUID()}`
    request({
            url: url,
            resolveWithFullResponse: true
        })
        .then((response) => {
            let headers = response.headers
            let data = JSON.parse(response.body)
            if (data.guild === null) {
                if (isOwnGuild) ChatLib.chat("&cYou are not in a guild!")
                else ChatLib.chat(`&cThat guild does not exist!`)
                return
            }
            let players = []
            data.guild.members.forEach(el => {
                players.push(el.uuid)
            })
            if (headers["RateLimit-Remaining"] < players.length) {
                console.log(`You need ${players.length} requests, but can only make ${headers["RateLimit-Remaining"]} requests.`)
                if (headers["RateLimit-Limit"] <= players.length) ChatLib.chat("&cThis guild is too large for you to get the stats of all the players in it.")
                else ChatLib.chat(`&cYou do not have enough API requests remaining to get the stats of all the players in this guild. Please try again in ${headers["RateLimit-Reset"]} seconds.`)
                return
            }
            let guild_stats = {
                total: {
                    fish: 0,
                    junk: 0,
                    treasure: 0,
                    plant: 0,
                    creature: 0,
                    total: 0,
                    orbs: {
                        helios: 0,
                        selene: 0,
                        nyx: 0,
                        aphrodite: 0,
                        zeus: 0,
                        demeter: 0,
                        archimedes: 0,
                        hades: 0,
                        total: 0
                    }
                },
                players: []
            }
            let guild_name = data.guild.name
            let count = 0
            ChatLib.chat("&7Getting guild stats, this may take a few seconds...")
            players.forEach(uuid => {
                request(`https://api.hypixel.net/player?key=${API_KEY}&uuid=${uuid}`)
                    .then((response) => {
                        let data = JSON.parse(response)
                        if (data !== undefined && data.player !== undefined && data.player.stats !== undefined && data.player.stats.MainLobby !== undefined && data.player.stats.MainLobby.fishing !== undefined && data.player.stats.MainLobby.fishing.stats !== undefined && data.player.stats.MainLobby.fishing.stats.permanent !== undefined) {
                            let perm = data.player.stats.MainLobby.fishing.stats.permanent
                            let player = {
                                name: styleName(data),
                                fish: 0,
                                junk: 0,
                                treasure: 0,
                                plant: 0,
                                creature: 0,
                                total: 0,
                                orbs: {
                                    helios: 0,
                                    selene: 0,
                                    nyx: 0,
                                    aphrodite: 0,
                                    zeus: 0,
                                    demeter: 0,
                                    archimedes: 0,
                                    hades: 0,
                                    total: 0
                                },
                                self: false
                            }
                            env_list.forEach(env => {
                                if (perm[env]) type_list.forEach(type => {
                                    if (perm[env][type]) {
                                        guild_stats.total[type] += perm[env][type]
                                        guild_stats.total.total += perm[env][type]
                                        player[type] += perm[env][type]
                                        player.total += perm[env][type]
                                    }
                                })
                            })
                            let orbs = data.player.stats.MainLobby.fishing.orbs
                            if (orbs) orb_names.forEach(orb => {
                                if (orbs[orb]) {
                                    guild_stats.total.orbs[orb] += orbs[orb]
                                    guild_stats.total.orbs.total += orbs[orb]
                                    player.orbs[orb] += orbs[orb]
                                    player.orbs.total += orbs[orb]
                                }
                            })
                            if (uuid === Player.getUUID().replaceAll("-", "")) player.self = true
                            guild_stats.players.push(player)
                        }
                        count++
                        console.log("Processed " + count + "/" + players.length + " players.")
                        if (count === players.length) {
                            outputGuildStats(guild_stats, guild_name, isOwnGuild, bookMenu, showOrbs, showSeason, withPlayer)
                        }
                    })
                    .catch((error) => {
                        console.log("ERROR: " + error)
                    })
            })
        })
        .catch((error) => {
            console.log("ERROR: " + error)
        })
}).setName("fsguild")

function outputGuildStats(guild_stats, name, isOwnGuild, bookMenu, showOrbs, showSeason, withPlayer) {
    let message = new Message((bookMenu ? `&3&l${name}\n\n` : `\n&b▂▄▆▉&e ${name} &b▉▆▄▂\n`))
    let array
    if (showOrbs) array = [
        ["Helios", "&e", guild_stats.total.orbs.helios],
        ["Selene", "&e", guild_stats.total.orbs.selene],
        ["Nyx", "&a", guild_stats.total.orbs.nyx],
        ["Aphrodite", "&a", guild_stats.total.orbs.aphrodite],
        ["Zeus", "&b", guild_stats.total.orbs.zeus],
        ["Demeter", "&b", guild_stats.total.orbs.demeter],
        ["Archimedes", "&d", guild_stats.total.orbs.archimedes],
        ["Hades", "&d", guild_stats.total.orbs.hades],
        ["Total", "&6", guild_stats.total.orbs.total]
    ]
    else array = [
        ["Fish", "&e", guild_stats.total.fish],
        ["Junk", "&c", guild_stats.total.junk],
        ["Treasure", "&a", guild_stats.total.treasure],
        ["Plants", "&2", guild_stats.total.plant],
        ["Creatures", "&b", guild_stats.total.creature]
        ["Total", "&d", guild_stats.total.total]
    ]
    array.forEach(el => {
        let hover = `${el[1]}${el[0]} Leaderboard`
        guild_stats.players.sort((a, b) => b[el[0].toLowerCase()] - a[el[0].toLowerCase()])
        if (showOrbs) guild_stats.players.sort((a, b) => b.orbs[el[0].toLowerCase()] - a.orbs[el[0].toLowerCase()])
        for (let i = 1; i <= guild_stats.players.length; i++) {
            let player = guild_stats.players[i - 1]
            let stat = player[el[0].toLowerCase()]
            if (showOrbs) stat = player.orbs[el[0].toLowerCase()]
            let line = `\n&7${i}. ${player.name}: ${el[1]}${thousandSeparator(stat)} ${percentage(stat, el[2])}`
            if (player.self) line = line.replace(/([§&][0-9a-fr])+/gm, "$&§l")
            hover += line
        }
        let text = new TextComponent(`${(bookMenu ? "&0" : "&b")}${el[0]}: ${el[1]}${thousandSeparator(el[2])} ${isOwnGuild ? percentage((showOrbs ? stats.orbs[el[0].toLowerCase()] : stats[el[0].toLowerCase()]), el[2]) : ""}\n`).setHover("show_text", hover)
        message.addTextComponent(text)
    })
    if (bookMenu) {
        let title = `${name} ${Math.floor(Math.random() * 10000)}`
        console.log(title)
        let book = new Book(title)
        book.addPage(message)
        book.display()
    } else ChatLib.chat(message)
}

register("command", (name) => {
    if (name === undefined) { ChatLib.chat("&cIncorrect syntax! Correct syntax: /getenchants <name>"); return; }
    let lowerName = name.toLowerCase()
    let players = World.getAllPlayers()
    let player = players.find(p => p.name.toLowerCase() === lowerName)
    if (player == undefined) {
        ChatLib.chat(`&cError: ${name} is not in your loaded chunks`)
        return
    }
    let item = player.getItemInSlot(0)
    if (item !== null) {
        if (item.getID() === 346) {
            let lore = item.getLore()
            let num = lore.indexOf("§5§o")
            if (num != -1) {
                let enchants = []
                for (let i = 1; i < num; i++) {
                    let enchant = lore[i].split("§7")[1]
                    enchants.push(enchant)
                }
                if (enchants.length === 0) {
                    ChatLib.chat(`&a${player.name}'s enchants:\n&7&o no enchants`)
                    return
                }
                ChatLib.chat(`&a${player.name}'s enchants:\n&7 - &2${enchants.join("\n&7 - &2")}`)
                return
            }
        }
    }
    ChatLib.chat(`&cError: ${player.name} is not holding the fishing rod`)
}).setTabCompletions((args) => {
    if (args.length === 1) return parseTab(args[0])
    else return [""]
}).setName("getenchants")
register("command", (...args) => {
    let names = []
    for (let key in data.player) {
        names.push(data.player[key].name)
    }
    let name
    if (args !== undefined) name = args[0]
    if (name === undefined) {
        let book = new Book("Your Fishing Stats")
        let message = new Message("Select an account:\n")
        let repeat_count = names.length
        if (repeat_count > 12) repeat_count = 12
        for (let i = 0; i < repeat_count; i++) {
            message.addTextComponent(new TextComponent(`\n ⦾ ${names[i]}`).setHover("show_text", `&7Click to select ${names[i]}`).setClick("run_command", `/selfstats ${names[i]}`))
        }
        book.addPage(message)
        if (names.length > 12) {
            let needed_to_repeat = names.length - 12
            let pages = Math.ceil(needed_to_repeat / 14)
            let first_page = true
            for (let i = 1; i < pages + 1; i++) {
                let message = new Message()
                let repeat_count = needed_to_repeat
                if (repeat_count > 14) repeat_count = 14
                let offset = 14 * i - 2
                if (first_page) {
                    offset = 12
                    first_page = false
                }
                for (let j = 0; j < repeat_count; j++) {
                    message.addTextComponent(new TextComponent(` ⦾ ${names[j + offset]}\n`).setHover("show_text", `&7Click to select ${names[j + offset]}`).setClick("run_command", `/selfstats ${names[j + offset]}`))
                }
                book.addPage(message)
                needed_to_repeat -= 14
            }
        }
        book.display()
        return
    }
    if (!names.includes(name)) {
        ChatLib.chat("&cNo data for that player.")
        return
    }
    let account
    for (let key in data.player) {
        if (data.player[key].name.toLowerCase() === name.toLowerCase()) {
            account = data.player[key]
            name = account.name
            break
        }
    }
    if (account === undefined) {
        ChatLib.chat("&cNo data for that player.")
        return
    }
    if (args[1] === undefined) {
        if (!account.alpha.retroactive) {
            ChatLib.command(`selfstats ${name} main`, true)
            return
        }
        let book = new Book(`Your Fishing Stats`).addPage(new Message("Select a server:\n\n",
            new TextComponent(" ⦾ Main\n").setHover("show_text", "&7Click to select the main server").setClick("run_command", `/selfstats ${name} main`),
            new TextComponent(" ⦾ Alpha").setHover("show_text", "&7Click to select the alpha server").setClick("run_command", `/selfstats ${name} alpha`)
        ))
        book.display()
        return
    }
    let sub = args[1]
    if (sub !== "main" && sub !== "alpha") {
        ChatLib.command(`selfstats ${name}`, true)
        return
    }
    let stats = account[sub]
    let book = new Book(`Your Fishing Stats`)
    let message = new Message(`${name}:`)
    if (!stats.retroactive) {
        message.addTextComponent(`\n\n&cThere is no data for ${name} on the ${sub} server`)
        book.addPage(message)
        book.display()
        return
    }
    let types = [
        ["Fish", "&6", stats.fish, "&e"],
        ["Junk", "&4", stats.junk, "&c"],
        ["Treasure", "&2", stats.treasure, "&a"],
        ["Plants", "&2", stats.plant, "&2"],
        ["Creatures", "&3", stats.creature, "&b"],
        ["Total", "&5", stats.total, "&d"],
        ["Fish", "&6", stats.seasonal_fish, "&e"],
        ["Junk", "&4", stats.seasonal_junk, "&c"],
        ["Treasure", "&2", stats.seasonal_treasure, "&a"],
        ["Mythics", "&1", stats.orbs.seasonal_total, "&6"],
        ["Total", "&5", stats.seasonal_total, "&d"]
    ]
    if (stats.season !== undefined) {
        message.addTextComponent(new TextComponent(`\n&8${stats.season}`).setHover("show_text", `&7${stats.season} ${percentage(stats.seasonal_total, stats.total)}`))
        for (let i = 6; i < 11; i++) {
            let type = types[i]
            let percent = ""
            if (i !== 10) percent = percentage(type[2], stats.seasonal_total)
            message.addTextComponent(new TextComponent(`\n&7${type[0]}: ${type[1]}${thousandSeparator(type[2])}`).setHover("show_text", `&7${stats.season_name} ${type[0]} Caught: ${type[3]}${thousandSeparator(type[2])} ${percent}`))
        }
        message.addTextComponent("\n&8Overall")
    }
    for (let i = 0; i < 6; i++) {
        let type = types[i]
        let percent = ""
        if (i !== 5) percent = percentage(type[2], stats.total)
        message.addTextComponent(new TextComponent(`\n&7${type[0]}: ${type[1]}${thousandSeparator(type[2])}`).setHover("show_text", `&7${type[0]} Caught: ${type[3]}${thousandSeparator(type[2])} ${percent}`))
    }
    if (stats.orbs.total < 0) {
        message.addTextComponent("\n&7Orbs: &cUnset")
    } else {
        let orb_data = [
            ["&eEmber of Helios", stats.orbs.helios],
            ["&eDust of Selene", stats.orbs.selene],
            ["&aShadow of Nyx", stats.orbs.nyx],
            ["&aHeart of Aphrodite", stats.orbs.aphrodite],
            ["&bSpark of Zeus", stats.orbs.zeus],
            ["&bSpirit of Demeter", stats.orbs.demeter],
            ["&dAutomaton of Daedalus", stats.orbs.archimedes],
            ["&dWrath of Hades", stats.orbs.hades]
        ]
        let hover = "&cMythical Fish Caught"
        for (let i = 0; i < orb_names.length; i++) {
            let orb = orb_data[i]
            let percent = percentage(orb[1], stats.orbs.total)
            hover += `\n${orb[0]}: &6${thousandSeparator(orb[1])} ${percent}`
        }
        message.addTextComponent(new TextComponent(`\n&7Mythics: &1${thousandSeparator(stats.orbs.total)}`).setHover("show_text", hover))
    }
    message.addTextComponent(new TextComponent(`\n&7Special Fish: &5${thousandSeparator(stats.special)}`).setHover("show_text", `&7Special Fish Caught: &d${stats.special}\n&7&oNumber may be slightly off`))
    book.addPage(message).display()
}).setTabCompletions((args) => {
    if (args.length === 1) {
        let names = []
        for (let key in data.player) {
            names.push(data.player[key].name)
        }
        return names
    } else if (args.length === 2) {
        return ["main", "alpha"].filter(sub => sub.startsWith(args[1].toLowerCase()))
    } else return [""]
}).setName("selfstats")


//trying to find the fun commands by reading the source code? shame on you...
register("command", () => {
    ChatLib.chat("&aTreasure luck has been increased by 10%")
}).setName("fishncats")
register("command", () => {
    catsnfish = !catsnfish
    ChatLib.chat(`&ePufferfish chances have been ${(catsnfish) ? "maximized" : "normalized"}`)
}).setName("catsnfish")
register("command", () => {
    crabMode = !crabMode
    if (crabMode) ChatLib.chat("&aCrab mode has been enabled!")
    else ChatLib.chat("&cCrab mode has been disabled.")
}).setName("crabmode").setAliases("estitch")
register("command", () => {
    ChatLib.chat(new Message(new TextComponent("&2[GM] Centranos").setHover("show_text", "&eStaff Rank - &2GAME MASTER [GM]\n\n&2Game Masters &f(or &2GMs&f) are staff members that moderate the Hypixel Server.\nYou can help them out by using the reporting system! &c/report (username)\n\n&fFor more information, visit &ehttps://hypixel.net/ranks").setClick("run_command", "/viewprofile Centranos"),
        ": We have countless tools to catch people doing this, the same tools we use to catch people who use macros, scripts and key weights when farming on skyblock."
    ))
}).setName("countlesstools")
register("command", () => {
    Client.Companion.disconnect()
    disconnect = true
}).setName("disconnect")
register("serverConnect", () => {
    if (!disconnect) return
    if (Server.getIP().includes("hypixel")) {
        setTimeout(() => {
            Client.Companion.disconnect()
            Client.Companion.connect("us.mineplex.com")
        }, 3000)
    }
    disconnect = false
})
register("command", () => {
    ChatLib.chat(`\n${ChatLib.getCenteredText("&7DeadKittie hears your prayer.")}\n${ChatLib.getCenteredText("&7&oYou feel a divine sense of bliss, like you have been chosen")}\n${ChatLib.getCenteredText("&7&ofor glory.")}\n${ChatLib.getCenteredText("&aYou sense that a great honor has been bestowed upon you.")}\n${ChatLib.getCenteredText("&aYou have recieved 100 Archimedes' Spheres!")}\n`)
    stats.orbs.archimedes += 100
    stats.orbs.total += 100
    saveStats()
    updateDisplay()
    updateOrbDisplay()
}).setName("deadkittie")

register("renderTitle", (title, subtitle, event) => {
    if (subtitle === "§7A §eMythical Fish §7emerges from the depths!!§r") {
        assignOrb()
        return
    }
})

register("chat", (event) => {
    const msg = ChatLib.getChatMessage(event, true)
    if (!orb_chat_re.test(msg)) return
    const match = msg.match(orb_chat_re)
    logOrb(match[3], Number.parseFloat(match[1]), match[2])
    if (FishingUtils.getSetting("Mythic Catch Assist", "Custom Catch Message")) cancel(event)
    endSpin(match[1])
})

let ticksAlive = 0
//Orb Logger
function logOrb(orb, weight, color) {
    if (stats.orbs.total < 0) {
        ChatLib.chat("&cOpen the Mythical Fish Menu in the Dockmaster to record your orbs!")
        return
    }
    const key = orb_dictionary[orb]
    if (key !== undefined) stats.orbs[key]++;
    stats.orbs.total++;
    stats.total++;
    thousandAnnouncer("mythical_fish", stats.orbs.total)
    thousandAnnouncer("total", stats.total)
    if (stats.season !== undefined) {
        stats.orbs.seasonal_total++;
        stats.seasonal_total++;
        thousandAnnouncer("seasonal_mythical_fish", stats.orbs.seasonal_total)
        thousandAnnouncer("seasonal_total", stats.seasonal_total)
    }
    let weight_color = "&f"
    if (stats.orbs.weight[key] < weight) {
        stats.orbs.weight[key] = weight
        weight_color = "&6"
    }
    if (simplerTimes) {
        let allowedToSet = FishingUtils.getSetting("Miscellaneous", "Don't Convert Ultra Rares") ? (key !== "archimedes" && key !== "hades") : true
        if (allowedToSet) orb = mythicToOrbNames[orb]
    }
    if (FishingUtils.getSetting("Mythic Catch Assist", "Custom Catch Message")) {
        ChatLib.chat(`&7You caught a ${weight_color}${weight}kg ${color}${orb} &7in &3${ticksAlive / 20} &7seconds!`)
    }
    if (key === "archimedes" || key === "hades") {
        const orbsSinceLastUltraRare = stats.orbs.total - stats.orbs.last_ultra_rare
        stats.orbs.last_ultra_rare = stats.orbs.total
        ChatLib.chat(`&7&oYou've caught &d&o${thousandSeparator(orbsSinceLastUltraRare)} &7&omythical fish since your last one!`)
    }
    stats.caught = `${weight}kg ${orb}`
    updateOrbDisplay()
    updateDisplay()
    saveStats()
}

//Mythical Loader
register("guiRender", () => {
    const inventory = Player.getContainer()
    if (inventory === null) return
    if (inventory.getName() !== "Mythical Fish") return
    for (let i = 0; i < 8; i++) {
        let index = 10 + Math.floor(i / 7) * 9 + i % 7
        let item = inventory.getStackInSlot(index)
        if (item === null) return
        let count = (item.getID() === 351) ? 0 : item.getLore()[5].removeFormatting().split(": ")[1]
        stats.orbs[orb_names[i]] = parseInt(count)
        if (count > 0) {
            let weight = item.getLore()[6].removeFormatting().split(": ")[1]
            if (weight !== "Unrecorded") stats.orbs.weight[orb_names[i]] = parseInt(weight.split("kg")[0])
        }
    }
    if (stats.orbs.total < 0) ChatLib.chat(new Message(
        "&aSuccessfully loaded your mythical fish! You can now use ",
        new TextComponent("&2/mythicalfish").setClick("run_command", "/mythicalfish"),
        "&a to view your mythical fish at any time. Opening the Mythical Fish menu again will reload your mythical fish."
    ))
    stats.orbs.total = stats.orbs.helios + stats.orbs.selene + stats.orbs.nyx + stats.orbs.aphrodite + stats.orbs.zeus + stats.orbs.demeter + stats.orbs.archimedes + stats.orbs.hades
    if (stats.orbs.last_ultra_rare < 0) stats.orbs.last_ultra_rare = stats.orbs.total
    updateOrbDisplay()
    updateDisplay()
    saveStats()
});

//Orb Viewer
register("command", () => {
    if (stats.orbs.total < 0) {
        ChatLib.chat("&cOpen the Mythical Fish Menu in the Dockmaster to view your mythical fish!")
        return
    }
    let orb_data = [
        ["&e - Ember of Helios", stats.orbs.helios, stats.orbs.weight.helios],
        ["&e - Dust of Selene", stats.orbs.selene, stats.orbs.weight.selene],
        ["&a - Shadow of Nyx", stats.orbs.nyx, stats.orbs.weight.nyx],
        ["&a - Heart of Aphrodite", stats.orbs.aphrodite, stats.orbs.weight.aphrodite],
        ["&b - Spark of Zeus", stats.orbs.zeus, stats.orbs.weight.zeus],
        ["&b - Spirit of Demeter", stats.orbs.demeter, stats.orbs.weight.demeter],
        ["&d - Automaton of Daedalus", stats.orbs.archimedes, stats.orbs.weight.archimedes],
        ["&d - Wrath of Hades", stats.orbs.hades, stats.orbs.weight.archimedes]
    ]
    let msg = new Message("&cMythical Fish Caught:")
    orb_data.forEach(el => {
        msg.addTextComponent(`\n&r${el[0]}: &r&6${thousandSeparator(el[1])}`)
        if (el[2] > 0) msg.addTextComponent(` &7| &f${el[2]}kg`)
        msg.addTextComponent(` ${percentage(el[1], stats.orbs.total)}`)
    })
    msg.addTextComponent(`\n&r&9 - Total: &r&6${thousandSeparator(stats.orbs.total)}`)
    ChatLib.chat(msg)
}).setName("mythicalfish").setAliases("orbs", "orb")

//Move Gui Settings
register("dragged", (dx, dy, x, y, btn) => {
    if (displayPos.isOpen()) {
        data.config.displayPos.x = x
        data.config.displayPos.y = y
        display.setRenderLoc(x, y)
        saveStats()
    } else if (orbDisplayPos.isOpen()) {
        data.config.orbDisplayPos.x = x
        data.config.orbDisplayPos.y = y
        updateOrbDisplay()
        saveStats()
    }
})

function centerText(text) {
    let width = text.getWidth()
    let height = text.getHeight()
    let screenWidth = Renderer.screen.getWidth()
    let screenHeight = Renderer.screen.getHeight()
    let x = (screenWidth / 2) - (width / 2)
    let y = (screenHeight / 2) - (height / 2)
    text.setX(x)
    text.setY(y)
    return (text)
}

function moveGuiRender() {
    centerText(text)
    text.draw()
}

//Update Data Path
register("serverConnect", () => {
    updateDataPath()
})

register("worldLoad", () => {
    if (new_account) {
        //this is here because of me not knowing what deep and shallow copying is, but
        //it's actually very convenient and i don't feel like editing the code to fix it
        ChatLib.chat("&a&lNew Account Detected!\n&aReloading modules to create new account data...")
        ChatLib.command("ct load", true)
    }
})

function getSub() {
    let ip = Server.getIP()
    let subdomain;
    (ip.startsWith("alpha")) ? subdomain = "alpha": subdomain = "main"
    return subdomain
}

function styleName(data) {
    let name = data.player.displayname
    let special = data.player.rank
    let prefix = data.player.prefix
    let plus = data.player.rankPlusColor
    let monthly = data.player.monthlyPackageRank
    let rank = data.player.newPackageRank
    if (prefix !== undefined) {
        prefix = prefix.replace(/Â/g, "")
        return `${prefix} ${name}`
    }
    switch (special) {
        case "ADMIN":
            return `§c[ADMIN] ${name}`
        case "GAME_MASTER":
            return `§2[GM] ${name}`
        case "STAFF":
            return `§c[§6ዞ§c] ${name}`
        case "YOUTUBER":
            return `§c[§fYOUTUBE§c] ${name}`
    }
    if (plus !== undefined) {
        plus = plus_dictionary[plus]
    } else plus = "§c"
    if (monthly === "SUPERSTAR") {
        let type;
        (data.player.monthlyRankColor === "GOLD") ? type = "§6": type = "§b"
        return `${type}[MVP${plus}++${type}] ${name}`
    }
    switch (rank) {
        case "MVP_PLUS":
            return `§b[MVP${plus}+§b] ${name}`
        case "MVP":
            return `§b[MVP] ${name}`
        case "VIP_PLUS":
            return `§a[VIP§6+§a] ${name}`
        case "VIP":
            return `§a[VIP] ${name}`
        default:
            return `§7${name}`
    }
}

function parseTab(start) {
    if (start === undefined) start = ""
    return TabList.getNames().filter(el => tab_re.test(el)).map(el => el.match(tab_re)[1]).filter(el => el.toLowerCase().startsWith(start.toLowerCase()))
}

register("playerInteract", () => {
    let item = Player.getHeldItem()
    if (item === null) return
    if (item.getID() === 346 && bobber === undefined) {
        bobber_needed = true
    }
})

register("tick", () => {
    if (!FishingUtils.getSetting("Custom Trails", "Custom Trails")) return
    if (FishingUtils.getSetting("Custom Trails", "Only Show in the Main Lobby"))
        if (!enabled) return
    if (bobber) {
        if (bobber.isDead()) {
            bobber = undefined
            bobber_needed = true
            return
        }
        let config = {
            type: particle_dictionary[FishingUtils.getSetting("Custom Trails", "Trail Type")],
            shape: FishingUtils.getSetting("Custom Trails", "Trail Shape"),
            color_setting: FishingUtils.getSetting("Custom Trails", "Use Custom Color"),
            color_toggle: false,
            rainbow: FishingUtils.getSetting("Custom Trails", "Rainbow Color"),
            color: FishingUtils.getSetting("Custom Trails", "Trail Color").map(el => el / 255),
            alpha: FishingUtils.getSetting("Custom Trails", "Trail Opacity") / 100,
            lifespan_setting: FishingUtils.getSetting("Custom Trails", "Use Custom Lifespan"),
            lifespan: FishingUtils.getSetting("Custom Trails", "Trail Lifespan"),
            x: bobber.getX(),
            y: bobber.getY(),
            z: bobber.getZ(),
            dx: 0,
            dy: 0,
            dz: 0,
        }
        switch (FishingUtils.getSetting("Custom Trails", "Preset")) {
            case "None (Use Custom Trails)":
                break
            case "Emerald":
                config.type = "VILLAGER_HAPPY"
                config.shape = "Burst"
                config.color_setting = false
                config.lifespan_setting = false
                break
            case "Sparkle":
                config.type = "CRIT_MAGIC"
                config.shape = "Burst"
                config.color_setting = false
                config.lifespan_setting = false
                break
            case "Treasure's Sheen":
                config.type = "FIREWORKS_SPARK"
                config.shape = "Burst"
                config.color_setting = false
                config.lifespan_setting = false
                break
            case "Beloved Junk":
                config.type = "VILLAGER_ANGRY"
                config.shape = "Burst"
                config.color_setting = false
                config.lifespan_setting = false
                break
            case "Archimedes' Trail":
                config.type = "ENCHANTMENT_TABLE"
                config.shape = "Archimedes"
                config.color_setting = false
                config.lifespan_setting = true
                config.lifespan = 40
                break
            case "Hades' Hook":
                config.type = "LAVA"
                config.shape = "Burst"
                config.color_setting = false
                config.lifespan_setting = false
                break
            case "Helios' Breath":
                config.type = "FLAME"
                config.shape = "Circle"
                config.color_setting = false
                config.lifespan_setting = false
                break
            case "Organic Material":
                if (bobber.getTicksExisted() % 5 === 0) {
                    for (let i = 0; i < 5; i++) {
                        World.getWorld().func_175688_a(net.minecraft.util.EnumParticleTypes.BLOCK_CRACK, config.x, config.y, config.z, 0, 0, 0, [170])
                    }
                }
                return
            case "Creature Catch":
                return
            case "Neptune's Grace":
                config.type = "WATER_BUBBLE"
                config.shape = "Circle"
                config.color_setting = false
                config.lifespan_setting = false
                break
            case "Ominous Rain":
                if (distanceToEntity(config.x, config.y, config.z) > 14) return
                if (bobber.getTicksExisted() % 3 === 0) {
                    for (let i = 0; i < 2; i++) {
                        let lavaOffsetX = (Math.random() - 0.5) / 2
                        let lavaOffsetZ = (Math.random() - 0.5) / 2
                        World.particle.spawnParticle("DRIP_LAVA", config.x + lavaOffsetX, config.y + 2, config.z + lavaOffsetZ, 0, 0, 0).setMaxAge(60)
                    }
                    for (let i = 0; i < 3; i++) {
                        let cloudOffsetX = (Math.random() - 0.5)
                        let cloudOffsetZ = (Math.random() - 0.5)
                        World.particle.spawnParticle("CLOUD", config.x + cloudOffsetX, config.y + 2, config.z + cloudOffsetZ, 0, 0, 0)
                    }
                }
                return
            case "All of the Above":
            if (distanceToEntity(config.x + x_offset, config.y + y_offset, config.z + z_offset) > 14) return
                function burst(type) {
                    for (let i = 0; i < 3; i++) {
                        let x_offset = Math.random() - 0.5
                        let y_offset = Math.random() * 0.5 + 0.25
                        let z_offset = Math.random() - 0.5
                        World.particle.spawnParticle(type, config.x + x_offset, config.y + y_offset, config.z + z_offset, config.dx, config.dy, config.dz)
                    }
                }
                function circle(type, phaseShift) {
                    let circle_angle = bobber.getTicksExisted() * Math.PI / 10 + phaseShift
                    let x_offset = Math.cos(circle_angle) * 0.5
                    let z_offset = Math.sin(circle_angle) * 0.5
                    World.particle.spawnParticle(type, config.x + x_offset, config.y, config.z + z_offset, config.dx, config.dy, config.dz)
                }
                if (bobber.getTicksExisted() % 20 === 0) burst("VILLAGER_HAPPY")
                if (bobber.getTicksExisted() % 20 === 4) burst("CRIT_MAGIC")
                if (bobber.getTicksExisted() % 20 === 8) burst("FIREWORKS_SPARK")
                if (bobber.getTicksExisted() % 20 === 12) burst("VILLAGER_ANGRY")
                if (bobber.getTicksExisted() % 20 === 16) burst("LAVA")
                circle("FLAME", 0)
                circle("WATER_BUBBLE", Math.PI)
                if (bobber.getTicksExisted() % 5 === 0) {
                    for (let i = 0; i < 5; i++) {
                        World.getWorld().func_175688_a(net.minecraft.util.EnumParticleTypes.BLOCK_CRACK, config.x, config.y, config.z, 0, 0, 0, [170])
                    }
                }
                if (bobber.getTicksExisted() % 3 === 0) {
                    for (let i = 0; i < 2; i++) {
                        let lavaOffsetX = (Math.random() - 0.5) / 2
                        let lavaOffsetZ = (Math.random() - 0.5) / 2
                        World.particle.spawnParticle("DRIP_LAVA", config.x + lavaOffsetX, config.y + 2, config.z + lavaOffsetZ, 0, 0, 0).setMaxAge(60)
                    }
                    for (let i = 0; i < 3; i++) {
                        let cloudOffsetX = (Math.random() - 0.5)
                        let cloudOffsetZ = (Math.random() - 0.5)
                        World.particle.spawnParticle("CLOUD", config.x + cloudOffsetX, config.y + 2, config.z + cloudOffsetZ, 0, 0, 0)
                    }
                }
                config.type = "ENCHANTMENT_TABLE"
                config.shape = "Archimedes"
                config.color_setting = false
                config.lifespan_setting = true
                config.lifespan = 40
                break
            case "Musical":
                config.type = "NOTE"
                config.shape = "Orbit"
                config.color_setting = true
                config.rainbow = true
                config.lifespan_setting = false
                break
            case "Ring of Fire":
                config.type = "FLAME"
                config.shape = "Halo"
                config.color_setting = false
                config.lifespan_setting = false
                break
            case "Rainbow":
                config.type = "REDSTONE"
                config.shape = "Continuous"
                config.color_setting = true
                config.rainbow = true
                config.lifespan_setting = false
                break
            case "Love":
                config.type = "HEART"
                config.shape = "Burst"
                config.color_setting = false
                config.lifespan_setting = true
                config.lifespan = 20
                break
            case "Boiling":
                config.type = "EXPLOSION_NORMAL"
                config.shape = "Continuous"
                config.color_setting = true
                config.color = [1, 1, 1]
                config.rainbow = false
                config.alpha = 0.1
                config.lifespan_setting = true
                config.lifespan = 50
                break
            case "Moon":
                config.type = "CRIT"
                config.shape = "Orbit (Close)"
                config.color_setting = true
                config.color = [1, 1, 1]
                config.rainbow = false
                config.lifespan_setting = true
                config.lifespan = 2
                break
            case "Absorb":
                config.type = "PORTAL"
                config.shape = "Absorb"
                break
            case "Learn":
                config.type = "ENCHANTMENT_TABLE"
                config.shape = "Learn"
                break
            case "Stop Fishing":
                config.type = "BARRIER"
                config.shape = "Continuous"
                config.color_setting = false
                config.alpha = 1
                config.lifespan_setting = true
                config.lifespan = 1
                break
            case "Snow":
                if (bobber.getTicksExisted() % 5 !== 0) return
                let x_offset = Math.random() - 0.5
                let y_offset = Math.random() * 0.5 + 0.25
                let z_offset = Math.random() - 0.5
                if (distanceToEntity(config.x + x_offset, config.y + y_offset, config.z + z_offset) > 14.5) return
                World.particle.spawnParticle("SNOW_SHOVEL", config.x + x_offset, config.y + y_offset, config.z + z_offset, 0, 0, 0)
                return
            case "Lightning":
                if ((bobber.getTicksExisted() + 10) % 30 !== 0) return
                let lightningRadius = 1.5
                const numberOfParticles = 15
                let altitude = Math.random() * Math.PI / 6 + Math.PI / 6
                let azimuth = Math.random() * Math.PI * 2
                let offsets = [
                    lightningRadius * Math.cos(azimuth) * Math.sin(altitude),
                    lightningRadius * Math.cos(altitude),
                    lightningRadius * Math.sin(azimuth) * Math.sin(altitude)
                ]
                let increments = offsets.map(el => el * 2 / (numberOfParticles - 1))
                for (let i = 0; i < numberOfParticles; i++) {
                    if (distanceToEntity(config.x + offsets[0], config.y + offsets[1], config.z + offsets[2]) < 14.5) World.particle.spawnParticle("REDSTONE", config.x + offsets[0], config.y + offsets[1], config.z + offsets[2], 0, 0, 0).setColor(1, 1, 1)
                    offsets = offsets.map((el, index) => el = el - increments[index])
                }
                return
            case "Spooky":
                config.type = "REDSTONE"
                config.shape = "Circle"
                let orange_offset = Math.random() * 30
                config.color = [(223 - orange_offset) / 255, (148 - orange_offset) / 255, 0]
                let purple_offset = Math.random() * 30
                if (distanceToEntity(config.x, config.y, config.z) < 14.5 && bobber.getTicksExisted() % 2 === 0) World.particle.spawnParticle("SPELL", config.x, config.y, config.z, 0, 0, 0).setColor((84 - purple_offset) / 255, 0, (84 - purple_offset) / 255)
                break
            case "Trans":
                if (bobber.getTicksExisted() % 20 !== 0) return
                config.type = "REDSTONE"
                const transColors = [[91 / 255, 206 / 255, 250 / 255],
                                     [245 / 255, 169 / 255, 184 / 255],
                                     [255 / 255, 255 / 255, 255 / 255]]
                for (let i = 0; i < 3; i++) {
                    let x_offset = Math.random() - 0.5
                    let y_offset = Math.random() * 0.5 + 0.25
                    let z_offset = Math.random() - 0.5
                    if (distanceToEntity(config.x + x_offset, config.y + y_offset, config.z + z_offset) > 14.5) return
                    let particle = World.particle.spawnParticle(config.type, config.x + x_offset, config.y + y_offset, config.z + z_offset, config.dx, config.dy, config.dz).setAlpha(config.alpha)
                    let color = transColors[i]
                    particle.setColor(color[0], color[1], color[2])
                    if (config.lifespan_setting) particle.setMaxAge(config.lifespan)
                }
                return
            case "Fish":
                if (bobber.getTicksExisted() % 5 === 0) bobber.dropItem(fish, 1)
                return
            default:
                break
        }
        if (config.color_setting) {
            if (!nocolor_list.includes(config.type)) {
                config.color_toggle = true
                if (config.rainbow) {
                    for (let i = 0; i < 3; i++) {
                        config.color[i] = Math.sin(0.1 * bobber.getTicksExisted() + 2 * i * Math.PI / 3) * 0.5 + 0.5
                    }
                }
            }
        }
        let orbit = false
        let radius = 1
        switch (config.shape) {
            case "Orbit":
                orbit = true
                break
            case "Orbit (Close)":
                orbit = true
                radius = 0.5
                break
            case "Orbit (Far)":
                orbit = true
                radius = 1.5
                break
            case "Circle":
                let circle_angle = bobber.getTicksExisted() * Math.PI / 10
                config.x += Math.cos(circle_angle) * 0.5
                config.z += Math.sin(circle_angle) * 0.5
                break
            case "Halo":
                let halo_angle = (10 * bobber.getTicksExisted()) * Math.PI / 180
                config.x += Math.sin(halo_angle) * 0.5
                config.y += 0.5
                config.z += Math.cos(halo_angle) * 0.5
                break
            case "Sine Wave":
                config.y += Math.sin(bobber.getTicksExisted() * 0.275) * radius
                break
            case "Burst":
                if (bobber.getTicksExisted() % 20 !== 0) return
                for (let i = 0; i < 3; i++) {
                    let x_offset = Math.random() - 0.5
                    let y_offset = Math.random() * 0.5 + 0.25
                    let z_offset = Math.random() - 0.5
                    if (distanceToEntity(config.x + x_offset, config.y + y_offset, config.z + z_offset) > 14.5) return
                    let particle = World.particle.spawnParticle(config.type, config.x + x_offset, config.y + y_offset, config.z + z_offset, config.dx, config.dy, config.dz).setAlpha(config.alpha)
                    if (config.color_toggle) particle.setColor(config.color[0], config.color[1], config.color[2])
                    if (config.lifespan_setting) particle.setMaxAge(config.lifespan)
                }
                return
            case "Sawtooth":
                let ticks = sawtoothTicks(bobber.getTicksExisted() * 0.1)
                let saw_angle = ticks * 65 * Math.PI / 180
                config.x += Math.sin(saw_angle)
                config.y += 1 - 4 * Math.abs((bobber.getTicksExisted() * 0.1 / 2) % 1 - 0.5)
                config.z += Math.cos(saw_angle)
                break
            case "Continuous":
                break
            case "Archimedes":
                config.dx = Math.random() * 4 - 2
                config.dy = Math.random() * 2
                config.dz = Math.random() * 4 - 2
                break
            case "Absorb":
                config.dx = -bobber.getX() + Player.getX()
                config.dy = -bobber.getY() + Player.getY()
                config.dz = -bobber.getZ() + Player.getZ()
                break
            case "Learn":
                config.x = Player.getX()
                config.y = Player.getY() + 2
                config.z = Player.getZ()
                config.dx = bobber.getX() - Player.getX()
                config.dy = bobber.getY() - Player.getY() - 2
                config.dz = bobber.getZ() - Player.getZ()
                break
            default:
                orbit = true
        }
        if (orbit) {
            let angle = (10 * bobber.getTicksExisted()) * Math.PI / 180
            config.x += Math.sin(angle) * radius
            config.y += Math.sin(bobber.getTicksExisted() * 0.275) * radius
            config.z += Math.cos(angle) * radius
        }
        //[EXPLOSION_NORMAL, EXPLOSION_LARGE, EXPLOSION_HUGE, FIREWORKS_SPARK, WATER_BUBBLE, WATER_SPLASH, WATER_WAKE, SUSPENDED, SUSPENDED_DEPTH, CRIT, CRIT_MAGIC, SMOKE_NORMAL, SMOKE_LARGE, SPELL, SPELL_INSTANT, SPELL_MOB, SPELL_MOB_AMBIENT, SPELL_WITCH, DRIP_WATER, DRIP_LAVA, VILLAGER_ANGRY, VILLAGER_HAPPY, TOWN_AURA, NOTE, PORTAL, ENCHANTMENT_TABLE, FLAME, LAVA, FOOTSTEP, CLOUD, REDSTONE, SNOWBALL, SNOW_SHOVEL, SLIME, HEART, BARRIER, ITEM_CRACK, BLOCK_CRACK, BLOCK_DUST, WATER_DROP, ITEM_TAKE, MOB_APPEARANCE]
        if (distanceToEntity(config.x, config.y, config.z) > 14.5) return
        let particle = World.particle.spawnParticle(config.type, config.x, config.y, config.z, config.dx, config.dy, config.dz).setAlpha(config.alpha)
        if (config.color_toggle) particle.setColor(config.color[0], config.color[1], config.color[2])
        if (config.lifespan_setting) particle.setMaxAge(config.lifespan)
    }
    if (!bobber_needed) return
    World.getAllEntitiesOfType(fishhook).forEach(el => {
        if (el.entity.field_146042_b === Player.asPlayerMP().entity) {
            bobber = el
            bobber_needed = false
        }
    })
})

function sawtoothTicks(ticks) {
    let new_ticks
    if (ticks % 2 > 1) {
        new_ticks = ticks - 1 - Math.floor(ticks / 2)
    } else {
        new_ticks = Math.floor(ticks / 2)
    }
    return new_ticks
}

register("worldUnload", () => {
    bobber = undefined
    bobber_needed = false
})

function distanceToEntity(x1, y1, z1) {
    let x = x1 - Player.getX()
    let y = y1 - (Player.getY() + 1.62)
    let z = z1 - Player.getZ()
    return Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2) + Math.pow(z, 2))
}

function updateOrbDisplay() {
    for (let i = 0; i < orb_names.length; i++) {
        top_text[i].setString(stats.orbs[orb_names[i]].toString()).setX(data.config.orbDisplayPos.x + 16 + (30 + margin) * i - 0.5).setY(data.config.orbDisplayPos.y)
        bottom_text[i].setString(orbPercentage(stats.orbs[orb_names[i]], stats.orbs.total).replace(/[()]/g, "")).setX(data.config.orbDisplayPos.x + 16 + (30 + margin) * i - 0.5).setY(data.config.orbDisplayPos.y + 40)
    }
}

function orbPercentage(num, total) {
    let ratio = num / total
    if (isNaN(ratio)) return "0%"
    if (ratio === 0) return "0%"
    if (ratio < 0.00001) return decimalSeparator("<0.001%")
    return decimalSeparator(Math.floor(ratio * 100000) / 1000 + "%")

}
register("renderOverlay", () => {
    if (!FishingUtils.getSetting("Mythic Display", "Mythical Fish Display")) return
    if (!orbDisplayToggle) return
    if (stats.orbs.total === -1) return
    if (FishingUtils.getSetting("Mythic Display", "Lock Display to Top Right")) {
        data.config.orbDisplayPos.x = Renderer.screen.getWidth() - (190 + 44 *2 + margin * 5)
        data.config.orbDisplayPos.y = 10
        updateOrbDisplay()
    }
    if (FishingUtils.getSetting("Mythic Display", "Background")) Renderer.drawRect(Renderer.color(FishingUtils.getSetting("Mythic Display", "Background Color")[0], FishingUtils.getSetting("Mythic Display", "Background Color")[1], FishingUtils.getSetting("Mythic Display", "Background Color")[2], FishingUtils.getSetting("Mythic Display", "Background Opacity")), data.config.orbDisplayPos.x - 5, data.config.orbDisplayPos.y - 5, 190 + 44 *2 + margin * 5, 60)
    for (let i = 0; i < orb_names.length; i++) {
        images[i].draw(data.config.orbDisplayPos.x + (30 + margin) * i, data.config.orbDisplayPos.y + 8, 30, 32)
        top_text[i].draw()
        bottom_text[i].draw()
    }
})

const armorstand = Java.type("net.minecraft.entity.item.EntityArmorStand").class

function getOrbsFromWorld() {
    let orb_list = []
    console.log("[WORLD] beginning better search")
    const stands = World.getAllEntitiesOfType(armorstand).reverse()
    const found = stands.find((stand) => {
        try {
            const skin = getSkinFromOrb(stand)
            if (orb_skins[skin] !== undefined) {
                console.log("[GET] found orb " + orb_skins[skin] + ", ending search")
                return true
            }
        } catch (e) {
            console.log("[GET] error: " + e)
            return false
        }
        console.log("[GET] not an orb")
        return false
    })
    if (found === undefined) {
        console.log("[WORLD] could not find orb")
        return orb_list
    }
    console.log("[WORLD] found orb of age " + found.getTicksExisted())
    orb_list.push(found)
    return orb_list
}

let yourorb
let mythicalHealth = 0

function getOrbsFromSkinURL() {
    let stands = World.getAllEntitiesOfType(armorstand).filter(el => {
        try {
            console.log("[GET] parsing " + el.getName())
            let skin = getSkinFromOrb(el)
            if (orb_skins[skin] !== undefined) {
                console.log("[GET] found orb " + orb_skins[skin])
                return true
            }
        } catch (e) {
            console.log("[GET] error: " + e)
            return false
        }
        console.log("[GET] not an orb")
        return false
    })
    return stands
}

function getSkinFromOrb(entity) {
    // console.log("[SKIN] parsing " + entity.getName())
    let head = entity.entity.func_82169_q(3)
    // console.log("[SKIN] got head " + head)
    let item = new Item(head)
    // console.log("[SKIN] got item " + item)
    let nbt = item.getNBT()
    // console.log("[SKIN] got nbt" + nbt)
        // console.log(nbt.keySet)
        // let skindata = nbt.getCompoundTag("tag").getCompoundTag("SkullOwner").getCompoundTag("Properties").get("textures")
    let skindata = nbt.toObject().tag.SkullOwner.Properties.textures[0].Value
    // console.log("[SKIN] got skindata " + skindata)
    let decrypted = new java.lang.String(java.util.Base64.getDecoder().decode(skindata.toString())) //make sure this is "java"!
    // console.log("[SKIN] got decrypted " + decrypted)
    let skin = JSON.parse(decrypted).textures.SKIN.url.split("texture/")[1]
    // console.log("[SKIN] got skin " + skin)
    return skin
}

const orb_skins = {
    // "c3d14561bbd063f70424a8afcc37bfe9c74562ea36f7bfa3f23206830c64faf1": "helios",
    // "fadc4a024718d401eeae9e95b3c92767f916f323c9e83649ad15c9265ee5092f": "selene",
    // "5879ed2b39fa0462c74292f5ca3d188420128b4a63ac75db8c97a094d1ac63f4": "nyx",
    // "190253c49e13cc2de00090ee65809da617c53f59e35f09a7c6e35011d19acb3d": "aphrodite",
    // "77400ea19dbd84f75c39ad6823ac4ef786f39f48fc6f84602366ac29b837422": "zeus",
    // "4fa1ef47daecfbda7e5505a1ba657926f621247c8761cd46c907736661bbe": "archimedes",
    // "9c2e9d8395cacd9922869c15373cf7cb16da0a5ce5f3c632b19ceb3929c9a11": "hades"
    // "9fbe1be19e4ffaba97d61beef7ca3010b62996c641e57084fc364a6f3eb14138": "fish pet"
    "c0102be6756274719b7f625830ea7ef5051c7d95dc01fe8359b4186378a0c263": "helios",
    "64a1fd9df8ad1d0e216ac347a39b47e797f4a3de7de4df073b065cb69f705baf": "selene",
    "d56123b334c5c18a4df9c1d6aff25046f5e06a7ea8f60b80b91ae48ac7f9830d": "nyx",
    "fc084765c62c03f3479e759208ca1e7fa99f674d0c8be78a3f10f5b1e866ca24": "aphrodite",
    "bb42db182471da05bc2e3d04ea08b7069004f5c066c0aacca1f18c40ee3049cf": "zeus",
    "placeholder": "demeter",
    "a92dca1e8218b18b0759fc5baedc7e054067b1ec2f97b10c8c3fca8f923a0a6a": "archimedes",
    "a46fa2c5492722bd510cf546cde1b6b6c689e7640a99606ed49930fe54def0d": "hades"
}

function getOrbTitle(orb) {
    let name = orb_skins[getSkinFromOrb(orb)]
    let title
    switch (name) {
        case "helios":
            title = simplerTimes ? "&eOrb of Helios" : "&eEmber of Helios"
            break
        case "selene":
            title = simplerTimes ? "&eOrb of Selene" : "&eDust of Selene"
            break
        case "nyx":
            title = "&aShadow of Nyx"
            break
        case "aphrodite":
            title = "&aHeart of Aphrodite"
            break
        case "zeus":
            title = "&bSpark of Zeus"
            break
        case "demeter":
            title = "&bSpirit of Demeter"
            break
        case "archimedes":
            title = (simplerTimes && !FishingUtils.getSetting("Miscellaneous", "Don't Convert Ultra Rares")) ? "&dArchimedes' Sphere" : "&dAutomaton of Daedalus"
            break
        case "hades":
            title = (simplerTimes && !FishingUtils.getSetting("Miscellaneous", "Don't Convert Ultra Rares")) ? "&dHades' Wrath" : "&dWrath of Hades"
            break
        default:
            title = "&cUnknown"
            break
    }
    return title
}

function assignOrb() {
    if (yourorb !== undefined) return
    updateDebugOrbDisplayStatus(`&eAttempted`)
    let orb_list = getOrbsFromWorld()
    console.log(orb_list)
    if (orb_list.length === 0) return
    let orb = orb_list[Math.floor(Math.random() * orb_list.length)]
    yourorb = orb
    ticksAlive = 0
    mythicalHealth = getMaximumHealthFromOrb(orb)
    updateDebugOrbDisplayStatus("&aFound", true)
    if (FishingUtils.getSetting("Mythic Catch Assist", "Mythic Spawning Message")) ChatLib.chat(`&7A wild ${getOrbTitle(orb)} &7appears!`)
    if (FishingUtils.getSetting("Mythic Catch Assist", "Mythical Alarm")) notesNeeded = 5
    let type = orb_skins[getSkinFromOrb(orb)]
    if (FishingUtils.getSetting("Miscellaneous", "Spin")) {
        if (type === "zeus" || type === "demeter") startSpin(false) 
        if (type === "archimedes" || type === "hades") startSpin(true)
    }
    if (simplerTimes) {
        let allowedToSet = FishingUtils.getSetting("Miscellaneous", "Don't Convert Ultra Rares") ? (type !== "archimedes" && type !== "hades") : true
        if (orbGameProfiles.initialized && allowedToSet) setSkinOfArmorStand(yourorb, orbGameProfiles[type])
    } else if (FishingUtils.getSetting("Miscellaneous", "Trans Mythical Fish")) {
        let allowedToSet = FishingUtils.getSetting("Miscellaneous", "Don't Convert Ultra Rares") ? (type !== "archimedes" && type !== "hades") : true
        if (transGameProfiles.initialized && allowedToSet) setSkinOfArmorStand(yourorb, transGameProfiles[type])
    }
}

let checked = []
register("step", () => {
    if (!enabled || !(simplerTimes || FishingUtils.getSetting("Miscellaneous", "Trans Mythical Fish"))) return
    let profiles = simplerTimes ? orbGameProfiles : transGameProfiles
    let stands = World.getAllEntitiesOfType(armorstand)
    for (let i = stands.length - 1; i > -1; i--) {
        let stand = stands[i]
        if (stand.getTicksExisted() > 60 || checked.indexOf(stand) > 0) break
        checked.push(stand)
        try {
            let type = orb_skins[getSkinFromOrb(stand)]
            if (type) {
                if ((!FishingUtils.getSetting("Miscellaneous", "Don't Convert Ultra Rares")) || (type !== "archimedes" && type !== "hades")) setSkinOfArmorStand(stand, profiles[type])
            }
        } catch (e) {}
    }
    checked = checked.filter(el => el.getTicksExisted() < 120)
}).setDelay(2)

function getMaximumHealthFromOrb(orb) {
    const skin = getSkinFromOrb(orb)
    const name = orb_skins[skin]
    switch (name) {
        case "helios":
        case "selene":
            return 25
        case "nyx":
        case "aphrodite":
            return 38
        case "zeus":
        case "demeter":
            return 50
        case "archimedes":
        case "hades":
            return 63
        default:
            console.log("unknown mythical skin: " + skin)
            return 100
    }
}

let mythicalClickCounter = 0
let ticksSinceLastClick = 0
register("playerInteract", () => {
    if (!yourorb) return
    mythicalClickCounter++
    ticksSinceLastClick = 0
    updateClickTracker()
    if (yourorb.getName()[4] === "c") mythicalHeat += 10
})

let notesNeeded = 0
register("tick", (ticks) => {
    if (ticks % 2 === 0 && notesNeeded > 0) {
        World.playSound("note.harp", FishingUtils.getSetting("Mythic Catch Assist", "Volume") / 100, 1 - (notesNeeded / 10))
        notesNeeded--
    }
})

let mythicalHeat = 0
register("tick", () => {
    if (!yourorb) return
    ticksSinceLastClick++
    if (mythicalHeat > 0) {
        mythicalHeat -= 0.75
    } else mythicalHeat = 0
})

register("tick", () => {
    if (yourorb !== undefined) {
        updatePhaseTracker()
        updateDebugOrbDisplay()
        ticksAlive = yourorb.getTicksExisted()
        if (!FishingUtils.getSetting("Mythic Catch Assist", "Catch Overlay")) return
        const health = yourorb.getName()
        const click = (health[4] === "a")
        const secondsLeft = (60 - Math.floor(yourorb.getTicksExisted() / 20)).toString()
        const clicksLeft = Math.clamp(mythicalHealth - mythicalClickCounter, 0, 100).toString()
        let title
        if (!click) title = "&c" + FishingUtils.getSetting("Mythic Catch Assist", "Red Phase Text")
        else if (phaseTracker[phaseTracker.length - 1] > 40) title = "&e" + FishingUtils.getSetting("Mythic Catch Assist", "Yellow Phase Text")
        else title = "&a" + FishingUtils.getSetting("Mythic Catch Assist", "Green Phase Text")
        const showTimeLeft = FishingUtils.getSetting("Mythic Catch Assist", "Show Time Left")
        const showClicksLeft = FishingUtils.getSetting("Mythic Catch Assist", "Show Clicks Left")
        const padWidth = Math.max((showTimeLeft ? secondsLeft.length : 0), (showClicksLeft ? clicksLeft.length : 0))
        const subtitleRow = []
        let numberColor = "&f"
        if (ticksSinceLastClick >= 250 && (ticksSinceLastClick % 10) < 5) numberColor = "&c"
        if (showTimeLeft) {
            subtitleRow.push(numberColor + secondsLeft.padStart(padWidth, "0"))
        }
        if (FishingUtils.getSetting("Mythic Catch Assist", "Show Health Bar")) {
            subtitleRow.push(health)
        }
        if (FishingUtils.getSetting("Mythic Catch Assist", "Show Heat Bar")) {
            subtitleRow.push(generateHeatBar(mythicalHeat))
        }
        if (showClicksLeft) {
            subtitleRow.push(numberColor + clicksLeft.padStart(padWidth, "0"))
        }
        if (clicksLeft > 0) Client.showTitle(title, subtitleRow.join(" "), 0, 20, 10)
        if (FishingUtils.getSetting("Mythic Catch Assist", "Show Phase Data in Action Bar")) displayActionBarTracker()
        if (yourorb.isDead()) {
            updateDebugOrbDisplayStatus("&cNone")
            yourorb = undefined
            mythicalClickCounter = 0
            ticksSinceLastClick = 0
            mythicalHealth = 0
            mythicalHeat = 0
            phaseTracker = []
            clickTracker = []
        }
    }
}).setPriority(Priority.LOWEST)

function generateHeatBar(heat) {
    const heatProgress = Math.max(0, Math.ceil(heat * 0.15))
    const remainingProgress = Math.max(0, 15 - heatProgress)
    let color
    if (heat >= 85) color = "&c"
    else if (heat >= 50) color = "&e"
    else color = "&a"
    return `&6[${color}${"|".repeat(heatProgress)}&8${"|".repeat(remainingProgress)}&6]`
}

function displayActionBarTracker() {
    const tracker = []
    phaseTracker.forEach((el, index) => {
        let color = (index % 2 === 0) ? "&c" : "&a"
        tracker.push(`${color}${(el / 20).toFixed(2)}/${clickTracker[index] || "0"}`)
    })
    ChatLib.actionBar(tracker.join(" &8| "))
}

const debugOrbDisplay = new Display().setRenderLoc(650, 150).addLine(new DisplayLine("Debug Orb Display").setShadow(true).setTextColor(Renderer.GOLD))
    .addLine(new DisplayLine("Status: &cNone").setShadow(true))
    .addLine(new DisplayLine("Current Orb:").setShadow(true))
    .addLine(new DisplayLine("Time:").setShadow(true))
    .addLine(new DisplayLine("Health:").setShadow(true))
    .addLine(new DisplayLine("Heat:").setShadow(true))
    .addLine(new DisplayLine("No Reel Timer:").setShadow(true))
    .addLine(new DisplayLine("Phase Tracker:").setShadow(true))
    .hide()


register("command", (toggle) => {
    if (toggle === "show") debugOrbDisplay.show()
    else if (toggle === "hide") debugOrbDisplay.hide()
    else ChatLib.chat("&cUsage: /debugorbdisplay <show|hide>")
}).setName("debugorbdisplay")


let phaseTracker = []
let clickTracker = []

function updatePhaseTracker() {
    const isGreen = yourorb.getName()[4] === "a"
    const trackingGreen = phaseTracker.length % 2 === 0
    if (isGreen !== trackingGreen) phaseTracker.push(0)
    if (phaseTracker.length > clickTracker.length) clickTracker.push(0)
    phaseTracker.push(phaseTracker.pop() + 1)
}

function updateClickTracker() {
    clickTracker.push(clickTracker.pop() + 1)
}

function updateDebugOrbDisplayStatus(status, updateName = false) {
    debugOrbDisplay.setLine(1, debugOrbDisplay.getLine(1).setText("Status: " + status).setShadow(true))
    if (updateName) debugOrbDisplay.setLine(2, debugOrbDisplay.getLine(2).setText(`Current Orb: ${orb_skins[getSkinFromOrb(yourorb)]}`).setShadow(true))
}

function updateDebugOrbDisplay() {
    const lines = [debugOrbDisplay.getLine(0), debugOrbDisplay.getLine(1), debugOrbDisplay.getLine(2)]
    lines.push(new DisplayLine(`Time: ${(yourorb.getTicksExisted() / 20).toFixed(2)} / 60`).setShadow(true))
    lines.push(new DisplayLine(`Health: ${mythicalHealth - mythicalClickCounter} / ${mythicalHealth}`).setShadow(true))
    lines.push(new DisplayLine(`Heat: ${mythicalHeat} / 100`).setShadow(true))
    lines.push(new DisplayLine(`No Reel Timer: ${(ticksSinceLastClick / 20).toFixed(2)} / 15`).setShadow(true))
    lines.push(new DisplayLine("Phase Tracker:").setShadow(true))
    phaseTracker.forEach((el, index) => {
        lines.push(new DisplayLine((el / 20).toFixed(2) + " (" + (clickTracker[index] || "0") + ")").setTextColor((index % 2 === 1) ? Renderer.GREEN : Renderer.RED).setShadow(true))
    })
    debugOrbDisplay.clearLines()
    debugOrbDisplay.addLines(lines)
}

let spinGuesses = {}
let isSpinning = false
function startSpin(isUltraRare) {
    spinGuesses = {}
    isSpinning = true
    ChatLib.command("pc spin" + (isUltraRare ? " (ultra rare edition)" : ""))
}

register("chat", (name, guess) => {
    if (!isSpinning) return
    spinGuesses[name] = guess
}).setChatCriteria(/&r&9Party &8> (?:(?:&[0-9a-fr])*?\[[\w+&ዞ]+\] |&7)(\w{1,16})[&rf7]+?: &r(\d+)/).setStart()

function endSpin(weight) {
    if (!isSpinning) return
    isSpinning = false
    const names = Object.keys(spinGuesses)
    const exact = []
    names.forEach(name => {
        if (spinGuesses[name] === weight) exact.push(name)
    })
    if (exact.length > 0) {
        ChatLib.command(`pc ${weight}, ${exact.join(" and ")} got it`)
        return
    }
    let smallestDistance = 1000
    let closest = []
    names.forEach(name => {
        let distance = Math.abs(weight - spinGuesses[name])
        if (distance < smallestDistance) {
            closest = [name]
            smallestDistance = distance
        } else if (distance === smallestDistance) {
            closest.push(name)
        }
    })
    if (closest.length > 0) {
        ChatLib.command(`pc ${weight}, ${closest.join(" and ")} ${closest.length === 1 ? "was" : "were"} closest`)
        return
    }
    ChatLib.command(`pc ${weight}`)
}

register("command", (username) => {
    if (API_KEY === "NONE") {
        ChatLib.chat("&cYou need to set your API Key before you can use this command!")
        return
    }
    if (!name_re.test(username)) {
        ChatLib.chat("&cError: That username is invalid.")
        return
    }
    request(`https://api.mojang.com/users/profiles/minecraft/${username}`)
        .then((response) => {
            if (response.length == 0) {
                ChatLib.chat("&cError: That player does not exist.")
                return
            }
            let data = JSON.parse(response);
            request(`https://api.hypixel.net/player?key=${API_KEY}&uuid=${data.id}`)
                .then((response) => {
                    let h_data = JSON.parse(response)
                    if (h_data.player === null) {
                        ChatLib.chat(`&cError: ${data.name} has not joined Hypixel.`)
                        return
                    }
                    let player = h_data.player
                    let displayname = styleName(h_data)
                    let favorites = player.vanityFavorites ? player.vanityFavorites.split(";") : []
                    let outfit = player.outfit
                    let suit = "&cNONE"
                    if (outfit !== undefined) Object.keys(outfit).forEach(el => {
                        let id = outfit[el].slice(0, outfit[el].lastIndexOf("_"))
                        if (suit === "&cNONE") suit = id
                        else if (suit !== id) suit = "&aMIXED"
                    })
                    if (suit !== "&cNONE" && suit !== "&aMIXED") suit = "&e" + suit
                    if (outfit !== undefined && Object.keys(outfit).length !== 4 && Object.keys(outfit).length !== 0) suit = "&aMIXED"
                    let vanity = {
                        "particle_pack": player.currentParticlePack,
                        "hat": player.currentHat,
                        "click_effect": player.currentClickEffect,
                        "suit": "",
                        "gadget": player.currentGadget,
                        "cloak": player.currentCloak,
                        "emote": player.currentEmote,
                    }
                    let pet = player.currentPet
                    let petName = (pet !== undefined && player.petStats[pet] !== undefined) ? player.petStats[pet].name : undefined
                    if (petName) petName = petName.replaceAll("Â", "")
                    let message = new Message(`${displayname}&b's current vanity items:`)
                    let petLine = `\n&bPet: `
                    if (pet === undefined) petLine += "&cNONE"
                    else {
                        petLine += `&e${pet}`
                        petLine = new TextComponent(petLine)
                        if (petName) petLine.setHover("show_text", petName)
                    }
                    message.addTextComponent(petLine)
                    let suitHover = "&bSuit Pieces"
                    let array = ["HELMET", "CHESTPLATE", "LEGGINGS", "BOOTS"]
                    array.forEach(el => {
                        suitHover += `\n&b${titleCase(el.toLowerCase())}: `
                        if (outfit !== undefined && outfit[el] !== undefined) suitHover += `&e${outfit[el].slice(0, outfit[el].lastIndexOf("_"))}`
                        else suitHover += "&cNONE"
                    })
                    let suitLine = new TextComponent(`\n&bSuit: ${suit}`)
                    if (suit !== "&cNONE") suitLine.setHover("show_text", suitHover)
                    for (let key in vanity) {
                        if (key === "suit") {
                            message.addTextComponent(suitLine)
                            continue
                        }
                        let text = `\n&b${titleCase(key)}: `
                        if (vanity[key] === undefined) text += "&cNONE"
                        else text += `&e${vanity[key]}`
                        message.addTextComponent(text)
                    }
                    let favoritesHover = "&bFavorites"
                    favorites.forEach(el => {
                        favoritesHover += `\n&e${el}`
                    })
                    let favoritesLine = new TextComponent(`\n&bFavorites: ${favorites.length > 0 ? "&e" : "&c"}${favorites.length}`)
                    if (favorites.length > 0) favoritesLine.setHover("show_text", favoritesHover)
                    message.addTextComponent(favoritesLine)
                    message.chat()
                })
                .catch((error) => {
                    console.log(error)
                })
        })
}).setTabCompletions((args) => {
    if (args.length === 1) return parseTab(args[0])
    else return [""]
}).setName("lc")

const bookTemplateData = {
    overall: {
        total: {
            fish: 0,
            junk: 0,
            treasure: 0,
            plant: 0,
            creature: 0,
            total: 0
        },
        water: {
            fish: 0,
            junk: 0,
            treasure: 0,
            plant: 0,
            creature: 0,
            total: 0
        },
        lava: {
            fish: 0,
            junk: 0,
            treasure: 0,
            plant: 0,
            creature: 0,
            total: 0
        },
        ice: {
            fish: 0,
            junk: 0,
            treasure: 0,
            plant: 0,
            creature: 0,
            total: 0
        }
    },
    individual: {
        fish: {},
        treasure: {},
        junk: {},
        plant: {},
        creature: {},
    },
    orbs: {
        helios: 0,
        selene: 0,
        nyx: 0,
        aphrodite: 0,
        zeus: 0,
        demeter: 0,
        archimedes: 0,
        hades: 0,
        total: 0,
        weight: {
            helios: -1,
            selene: -1,
            nyx: -1,
            aphrodite: -1,
            zeus: -1,
            demeter: -1,
            archimedes: -1,
            hades: -1
        }
    },
    seasonal: {},
    special: [],
    cosmetics: {
        selected: {
            rod: "fishing_rod_3000",
            trail: "none"
        },
        unlocked: {
            rod: ["fishing_rod_3000"],
            trail: ["none"],
            lobby: []
        }
    },
    enchants: {
        lure: {
            level: 3,
            toggle: true,
            progress: 0
        },
        luck: {
            level: 2,
            toggle: true,
            progress: 0
        },
        collector: {
            level: 0,
            toggle: true,
            progress: 0
        },
        dumpster_diver: {
            level: 0,
            toggle: true,
            progress: 0
        },
        vulcans_blessing: {
            level: 0,
            toggle: true,
            progress: {
                flame: 0,
                scales: 0,
                sealant: 0
            }
        },
        neptunes_fury: {
            level: 0,
            toggle: true
        },
        mythical_hook: {
            level: 0,
            toggle: true
        },
        herbivore: {
            level: 0,
            toggle: true
        }
    },
    player: {
        uuid: "",
        name: "",
        formattedName: "",
        level: -1, //(sqrt(2*x+30625))/50-2.5
        ap: -1,
        firstLogin: -1,
        completed: false
    },
    extra: {
        achievements: {
            general: {
                general_hot_potato: false,
                general_fishing_hobbyist: false,
                general_doing_my_part: false,
                general_tips_and_tricks: false,
                general_deep_sea_expert: false,
                general_old_farmers_almanac: false,
                general_master_lure: 0,
                general_trashiest_diver: 0,
                general_luckiest_of_the_sea: 0
            },
            summer: {
                summer_collectors_edition: false,
                summer_gone_fishing: 0
            },
            easter: {
                easter_spring_fishing: false,
                easter_spring_water: false
            }
        },
        tracked: "",
        leaderboard: "FISH",
        settings: {
            fishCollectorShowCaught: false,
            simplifiedIcons: false
        },
        npcs: {
            dockmaster: false,
            vulcan: false,
            neptune: false
        }
    },
    completion: {
        unlocked: {
            achievements: 0,
            enchants: 0,
            environments: 0,
            fish_hook_trails: 0,
            fishing_rods: 0,
            lobby_cosmetics: 0,
            mythical_fish: 0,
            special_fish: 0
        },
        maximum: {
            achievements: 0,
            enchants: 0,
            environments: 0,
            fish_hook_trails: 0,
            fishing_rods: 0,
            lobby_cosmetics: 0,
            mythical_fish: 0,
            special_fish: 0
        }
    }
}

const bookSeasonTemplateData = {
    total: {
        fish: 0,
        junk: 0,
        treasure: 0,
        plant: 0,
        creature: 0,
        orb: 0,
        total: 0
    },
    water: {
        fish: 0,
        junk: 0,
        treasure: 0,
        plant: 0,
        creature: 0,
        orb: 0,
        total: 0
    },
    lava: {
        fish: 0,
        junk: 0,
        treasure: 0,
        plant: 0,
        creature: 0,
        orb: 0,
        total: 0
    },
    ice: {
        fish: 0,
        junk: 0,
        treasure: 0,
        plant: 0,
        creature: 0,
        orb: 0,
        total: 0
    }
}

register("command", (username) => {
    if (API_KEY === "NONE") {
        ChatLib.chat("&cYou need to set your API Key before you can use this command!")
        return
    }
    if (username === "--showGuild") {
        const stored = guildRequestDataStorage()
        if (stored.statBook === undefined) {
            ChatLib.chat("&cThere is no book!")
            return
        }
        if (!stored.statBook.isOpen()) {
            ChatLib.chat("&cThe book is not open!")
            return
        }
        stored.statBook.setPage(0, createTitlePage(stored.data, stored.seasons, stored.times, stored.noFishingData, stored.statBook, undefined, true))
        stored.statBook.display(0)
        let originalGuildTime = Date.now()
        request(`https://api.hypixel.net/guild?key=${API_KEY}&player=${stored.data.uuid}`)
            .then((response) => {
                if (!stored.statBook.isOpen()) {
                    ChatLib.chat("&cThe book is not open!")
                    return
                }
                let times = stored.times.map(el => el)
                times.push(Date.now() - originalGuildTime)
                stored.statBook.setPage(0, createTitlePage(stored.data, stored.seasons, times, stored.noFishingData, stored.statBook, JSON.parse(response).guild))
                stored.statBook.display(stored.statBook.getCurrentPage())
            })
            .catch(error => { //TODO: show in book if error

                ChatLib.chat("&cWhoops, there was an error getting the guild!")
                console.log(error)
            })
        return
    }
    if (!username) username = Player.getName()
    if (!name_re.test(username)) {
        ChatLib.chat("&cError: That username is invalid.")
        return
    }
    let originalTime = Date.now()
    request(`https://api.mojang.com/users/profiles/minecraft/${username}`)
        .then((response) => {
            let mojangTime = Date.now()
            if (response.length == 0) {
                ChatLib.chat("&cError: That player does not exist.")
                return
            }
            let data = JSON.parse(response);
            request(`https://api.hypixel.net/player?key=${API_KEY}&uuid=${data.id}`)
                .then((response) => {
                    let hypixelTime = Date.now()
                    let h_data = JSON.parse(response)
                    if (h_data.player === null) {
                        ChatLib.chat(`&cError: ${data.name} has not joined Hypixel.`)
                        return
                    }
                    console.log("[FSB] reached aggregate")
                    aggregateBookData(h_data, [originalTime, mojangTime, hypixelTime], data.id)
                })
                .catch(error => {
                    console.log(error)
                    ChatLib.chat("&cAn unknown error occurred.")
                })
        })
        .catch(error => {
            ChatLib.chat("&cError: That player does not exist.")
        })
}).setTabCompletions((args) => {
    if (args.length === 1) return parseTab(args[0])
    else return [""]
}).setName("fsb")



function aggregateBookData(data, times, uuid) {
    let bookData = JSON.parse(JSON.stringify(bookTemplateData))

    //load general player stats
    console.log("[FSB] general")
    bookData.player.uuid = uuid
    bookData.player.name = data.player.displayname
    bookData.player.formattedName = styleName(data)
    if (Number.isInteger(data.player.networkExp)) bookData.player.level = Math.floor(Math.sqrt(2 * data.player.networkExp + 30625) / 50 - 2.5)
    if (Number.isInteger(data.player.achievementPoints)) bookData.player.ap = data.player.achievementPoints
    if (Number.isInteger(data.player.firstLogin)) bookData.player.firstLogin = data.player.firstLogin

    //create variables for easy access to data
    let lobby = (data.player.stats && data.player.stats.MainLobby) ? data.player.stats.MainLobby : {}
    let fishing = (lobby.fishing) ? lobby.fishing : {}

    //load permanent stats
    console.log("[FSB] perm")
    if (fishing.stats && fishing.stats.permanent) {
        env_list.forEach(env => {
            if (fishing.stats.permanent[env]) type_list.forEach(el => {
                if (fishing.stats.permanent[env][el]) {
                    bookData.overall[env][el] += fishing.stats.permanent[env][el]
                    bookData.overall[env].total += fishing.stats.permanent[env][el]
                    bookData.overall.total[el] += fishing.stats.permanent[env][el]
                    bookData.overall.total.total += fishing.stats.permanent[env][el]
                }
            })
        })

        //load individual stats
        console.log("[FSB] individual")
        if (fishing.stats.permanent.individual) {
            Object.keys(fishing.stats.permanent.individual).forEach(type => {
                Object.keys(fishing.stats.permanent.individual[type]).forEach(el => {
                    bookData.individual[type][el] = fishing.stats.permanent.individual[type][el]
                })
            })
        }

        let total_plants = 0
        Object.keys(bookData.individual.plant).forEach(el => {
            total_plants += bookData.individual.plant[el]
        })
        let og_kelp = total_plants - bookData.overall.total.plant
        if (og_kelp > 0) {
            bookData.individual.plant.og_kelp = -og_kelp
            bookData.individual.fish.og_kelp = og_kelp
        }
    }

    //load mythical fish
    console.log("[FSB] mythical")
    if (fishing.orbs) {
        orb_names.forEach(el => {
            if (fishing.orbs[el]) {
                bookData.orbs[el] = fishing.orbs[el]
                bookData.orbs.total += fishing.orbs[el]
                bookData.completion.unlocked.mythical_fish++
            }
            bookData.completion.maximum.mythical_fish++
        })
        if (fishing.orbs.weight) {
            Object.keys(fishing.orbs.weight).forEach(el => {
                bookData.orbs.weight[el] = fishing.orbs.weight[el]
            })
        }
        bookData.overall.total.total += bookData.orbs.total
    }

    //load historical data
    console.log("[FSB] historical")
    if (fishing.stats) {
        Object.keys(fishing.stats).filter(el => el !== "permanent").forEach(year => {
            bookData.seasonal[year] = {}
            Object.keys(fishing.stats[year]).forEach(event => {
                bookData.seasonal[year][event] = JSON.parse(JSON.stringify(bookSeasonTemplateData))
                console.log("[FSB] season: " + event + " " + year)
                if (year < 2023 || (year == 2023 && (event !== "halloween" && event !== "christmas"))) {
                    console.log("[FSB] deleting total")
                    delete bookData.seasonal[year][event].total.orb
                    console.log("[FSB] deleting water")
                    delete bookData.seasonal[year][event].water.orb
                    console.log("[FSB] deleting lava")
                    delete bookData.seasonal[year][event].lava.orb
                    console.log("[FSB] deleting ice")
                    delete bookData.seasonal[year][event].ice.orb
                }
                if (year < 2025 || (year == 2025 && (event === "easter"))) {
                    ["plant", "creature"].forEach(a => {
                        ["total", "water", "lava", "ice"].forEach(b => {
                            delete bookData.seasonal[year][event][b][a]
                        })
                    })
                }
                Object.keys(fishing.stats[year][event]).forEach(env => {
                    Object.keys(fishing.stats[year][event][env]).forEach(el => {
                        bookData.seasonal[year][event][env][el] = fishing.stats[year][event][env][el]
                        bookData.seasonal[year][event][env].total += fishing.stats[year][event][env][el]
                        bookData.seasonal[year][event].total[el] += fishing.stats[year][event][env][el]
                        bookData.seasonal[year][event].total.total += fishing.stats[year][event][env][el]
                    })
                })
            })
        })
    }

    //load special fish
    console.log("[FSB] specials")
    if (fishing.special_fish) Object.keys(fishing.special_fish).forEach(el => {
        bookData.special.push(el)
        bookData.completion.unlocked.special_fish++;
        if (el === "mahi-mahi") bookData.completion.maximum.special_fish++
    })
    bookData.completion.maximum.special_fish += specialCounts.total

    //load selected cosmetics
    console.log("[FSB] selected")
    if (fishing.activeFishingRod) bookData.cosmetics.selected.rod = fishing.activeFishingRod
    if (fishing.activeFishHookTrail) bookData.cosmetics.selected.trail = fishing.activeFishHookTrail

    //load unlocked rods
    console.log("[FSB] rods")
    bookData.completion.unlocked.fishing_rods++; //Fishing Rod 3000
    if (bookData.seasonal[2022] && bookData.seasonal[2022].christmas && bookData.seasonal[2022].christmas.ice.fish >= 100) {
        bookData.cosmetics.unlocked.rod.push("inaugural_ice_fishing_rod")
        bookData.completion.unlocked.fishing_rods++
    }
    if (bookData.special.includes("poisonous_potato") &&
        bookData.special.includes("golden_apple") &&
        bookData.special.includes("burnt_plant")) {
            bookData.cosmetics.unlocked.rod.push("fishing_rod_overgrown")
            bookData.completion.unlocked.fishing_rods++
    }
    if (bookData.individual.creature.squid > 0) {
        data.cosmetics.unlocked.rod.push("fishing_rod_zoologist")
        bookData.completion.unlocked.fishing_rods++
    }
    if (lobby.packages) Object.keys(rod_dictionary).forEach(el => {
        if (lobby.packages.includes(el)) {
            bookData.cosmetics.unlocked.rod.push(el)
            bookData.completion.unlocked.fishing_rods++
        }
    })
    bookData.completion.maximum.fishing_rods = Object.keys(rod_dictionary).length

    //load unlocked trails
    console.log("[FSB] trails")
    bookData.completion.unlocked.fish_hook_trails++; // "None" trail
    if (bookData.overall.total.fish >= 10000) {
        bookData.cosmetics.unlocked.trail.push("mainlobby_fishing_gold_particles")
        bookData.completion.unlocked.fish_hook_trails++
    }
    if (bookData.special.length >= 20) {
        bookData.cosmetics.unlocked.trail.push("mainlobby_fishing_sparkle")
        bookData.completion.unlocked.fish_hook_trails++
    }
    if (bookData.overall.total.treasure >= 5000) {
        bookData.cosmetics.unlocked.trail.push("mainlobby_fishing_treasure_sheen")
        bookData.completion.unlocked.fish_hook_trails++
    }
    if (bookData.overall.total.junk >= 5000) {
        bookData.cosmetics.unlocked.trail.push("mainlobby_fishing_beloved_junk")
        bookData.completion.unlocked.fish_hook_trails++
    }
    if (bookData.orbs.archimedes >= 1) {
        bookData.cosmetics.unlocked.trail.push("mainlobby_fishing_archimedes")
        bookData.completion.unlocked.fish_hook_trails++
    }
    if (bookData.orbs.hades >= 5) {
        bookData.cosmetics.unlocked.trail.push("mainlobby_fishing_hades_hook")
        bookData.completion.unlocked.fish_hook_trails++
    }
    if (bookData.overall.total.plant >= 1000) {
        bookData.cosmetics.unlocked.trail.push("mainlobby_fishing_organic_matter")
        bookData.completion.unlocked.fish_hook_trails++
    }
    if (bookData.overall.total.creature >= 1000) {
        bookData.cosmetics.unlocked.trail.push("mainlobby_fishing_creature_catch")
        bookData.completion.unlocked.fish_hook_trails++
    }
    if (lobby.packages) {
        Object.keys(trail_dictionary).forEach(el => {
            if (lobby.packages.includes(el)) {
                bookData.cosmetics.unlocked.trail.push(el)
                bookData.completion.unlocked.fish_hook_trails++
            }
        })
    }
    bookData.completion.maximum.fish_hook_trails = Object.keys(trail_dictionary).length

    //load unlocked cosmetics
    console.log("[FSB] cosmetics")
    if (data.player.vanityMeta && data.player.vanityMeta.packages) Object.keys(cosmeticNames).forEach(el => {
        if (data.player.vanityMeta.packages.includes(el)) {
            bookData.cosmetics.unlocked.lobby.push(el)
            bookData.completion.unlocked.lobby_cosmetics++
        }
    })
    if (bookData.overall.total.fish >= 50000) {
        bookData.cosmetics.unlocked.lobby.push("status_legendary_fisher")
        bookData.completion.unlocked.lobby_cosmetics++
    }
    if ((bookData.seasonal[2022] && bookData.seasonal[2022].christmas && bookData.seasonal[2022].christmas.total.fish >= 1050) ||
        Object.keys(bookData.seasonal).find(el => (bookData.seasonal[el]?.christmas?.total?.orb || 0) >= 25)) {
        bookData.cosmetics.unlocked.lobby.push("punchmessage_fished")
        bookData.completion.unlocked.lobby_cosmetics++
    }
    bookData.completion.maximum.lobby_cosmetics = Object.keys(cosmeticNames).length

    //load enchants
    console.log("[FSB] ench")
    if (fishing.enchants) Object.keys(fishing.enchants).forEach(enchant => Object.keys(fishing.enchants[enchant]).forEach(el => bookData.enchants[enchant][el] = fishing.enchants[enchant][el]))

    //load enchant progress
    console.log("[FSB] eprog")
    bookData.enchants.lure.progress = bookData.overall.total.fish
    bookData.enchants.luck.progress = bookData.overall.total.treasure
    bookData.enchants.collector.progress = bookData.overall.total.junk
    bookData.enchants.dumpster_diver.progress = bookData.special.length
    if (fishing.fireproofing) Object.keys(fishing.fireproofing).forEach(el => bookData.enchants.vulcans_blessing.progress[el] = fishing.fireproofing[el])

    //load achievements
    console.log("[FSB] ap")
    Object.keys(bookData.extra.achievements).forEach(category => {
        Object.keys(bookData.extra.achievements[category]).forEach(el => {
            if (bookData.extra.achievements[category][el] === false && data.player.achievementsOneTime) bookData.extra.achievements[category][el] = data.player.achievementsOneTime.includes(el)
            else if (data.player.achievements) bookData.extra.achievements[category][el] = data.player.achievements[el]
        })
    })

    //hide legacy achievements
    if (!bookData.extra.achievements.summer.summer_collectors_edition) delete bookData.extra.achievements.summer.summer_collectors_edition
    else bookData.cosmetics.cloak_school = true

    //load extra info
    console.log("[FSB] extra")
    if (lobby.fishing_reward_tracked) bookData.extra.tracked = lobby.fishing_reward_tracked
    if (lobby.leaderboardSettings && lobby.leaderboardSettings.fishingType) bookData.extra.leaderboard = lobby.leaderboardSettings.fishingType
    if (fishing.settings) Object.keys(fishing.settings).forEach(el => bookData.extra.settings[el] = fishing.settings[el])
    let npcs = []
    if (lobby.questNPCTutorials) Object.keys(lobby.questNPCTutorials).forEach(el => npcs.push(el))
    bookData.extra.npcs.dockmaster = npcs.includes("dockmaster")
    bookData.extra.npcs.vulcan = npcs.includes("lava_fisherman")
    if (fishing.ice) bookData.extra.npcs.neptune = fishing.ice.spokenToNereid === true
    bookData.completion.unlocked.environments = bookData.extra.npcs.dockmaster + bookData.extra.npcs.vulcan + bookData.extra.npcs.neptune
    bookData.completion.maximum.environments = env_list.length

    //generate the book
    console.log("[FSB] generate")
    generateStatBook(bookData, times, Object.keys(fishing).length === 0)
}

function generateStatBook(bookData, times, noFishingData) {
    const statBook = new Book("Fishing Stats")
    times.push(Date.now())
    const pages = []
    console.log("[FSB] creating special")
    pages.push(createSpecialFishPage(bookData.special))
    console.log("[FSB] creating individual")
    pages.push(createIndividualPage(bookData.individual, bookData.overall.total))
    console.log("[FSB] creating cosmetics")
    pages.push(createCosmeticsPage(bookData.cosmetics))
    console.log("[FSB] creating enchants")
    pages.push(createEnchantsPage(bookData))
    console.log("[FSB] creating historical overview")
    pages.push(createHistoricalOverview(bookData.seasonal, bookData.overall.total.total))
    console.log("[FSB] creating historical pages")
    let historicalPages = createHistoricalPages(bookData.seasonal, bookData.overall.total.total, bookData.orbs.total)
    historicalPages.forEach(el => pages.push(el))
    console.log("[FSB] creating extra")
    pages.push(createExtraPage(bookData))
    console.log("[FSB] creating overiew")
    pages.unshift(createStatsOverview(bookData))
    console.log("[FSB] creating title")
    times.push(Date.now())
    pages.unshift(createTitlePage(bookData.player, historicalPages.length, times, noFishingData, statBook))

    console.log(JSON.stringify(bookData, null, 2))

    pages.forEach((el, index) => statBook.setPage(index, el))
    statBook.display()
}

function nameLength(name) {
    let length = 0
    Array.from(name).forEach(char => {
        if (char === "f" || char === "k" || char === ' ') length += 0.8
        else if (char === "I" || char === "t") length += 0.6
        else if (char === "l") length += 0.4
        else if (char === "i") length += 0.2
        else length += 1
    })
    return length
}

function centerBookPadding(name) {
    return new Array(Math.floor((19 - nameLength(name)) * 0.8) + 1).join(" ")
}


let guildRequestDataStorageObject = {
    data: undefined,
    seasons: undefined,
    times: undefined,
    noFishingData: undefined,
    statBook: undefined
}

function guildRequestDataStorage(data = undefined, seasons = undefined, times = undefined, noFishingData = undefined, statBook = undefined) {
    if (data === undefined) return guildRequestDataStorageObject
    guildRequestDataStorageObject.data = JSON.parse(JSON.stringify(data))
    guildRequestDataStorageObject.seasons = seasons
    guildRequestDataStorageObject.times = times.map(el => el)
    guildRequestDataStorageObject.noFishingData = noFishingData
    guildRequestDataStorageObject.statBook = statBook
}

function fixGuildTag(tag) {
    return tag
        .replaceAll("âœ§", "✧")
        .replaceAll("âœª", "✪")
        .replaceAll("âœ–", "✖")
        .replaceAll("âœ“", "✓")
        .replaceAll("âœ¿", "✿")
        .replaceAll("âœŒ", "✌")
        .replaceAll("âžŠ", "➊")
        .replaceAll(/â.¤/g, "❤")
}


function createTitlePage(data, seasons, times, noFishingData, statBook, guild = undefined, loadingGuild = false) {
    const message = new Message()
    let lightColor = "&9"
    let darkColor = "&1"
    if (noFishingData) {
        lightColor = "&c"
        darkColor = "&4"
    }
    if (data.completed) {
        lightColor = "&8"
        darkColor = "&0"
    }
    const hasGuild = (guild !== undefined)
    console.log("[FSB] hasGuild: " + hasGuild + "| guild: " + guild)
    const totalTime = (hasGuild) ? times[0] + times[5] : ((loadingGuild) ? times[0] : times[4] - times[0])
    const mojangTime = (hasGuild || loadingGuild) ? times[1] : times[1] - times[0]
    const hypixelTime = (hasGuild || loadingGuild) ? times[2] : times[2] - times[1]
    const aggregateTime = (hasGuild || loadingGuild) ? times[3] : times[3] - times[2]
    const createTime = (hasGuild || loadingGuild) ? times[4] : times[4] - times[3]
    const guildText = (hasGuild) ? "&b" + ((guild !== null) ? guild.name : "&cNone") : ((loadingGuild) ? "&eLoading..." : "&eClick to load!")
    const guildSuffix = (hasGuild && guild !== null && guild.tag !== undefined) ? ` ${plus_dictionary[guild.tagColor]}[${fixGuildTag(guild.tag)}]` : ""
    console.log(`[FSB] guild suffix: ` + guildSuffix)
    const guildRequestText = (hasGuild) ? `\n  &6Guild Request: ${times[5]}ms` : ""
    if (!hasGuild && !loadingGuild) guildRequestDataStorage(data, seasons, [totalTime, mojangTime, hypixelTime, aggregateTime, createTime], noFishingData, statBook)
    let nameTextComponent = new TextComponent(data.name).setHover("show_text", `${data.formattedName}${guildSuffix}\n&7Hypixel Level: &6${(data.level > 0) ? thousandSeparator(data.level) : "?"}\n&7Achievement Points: &e${(data.ap > 0) ? thousandSeparator(data.ap) : "?"}\n&7Guild: ${guildText}\n&7First Joined: &b${(data.firstLogin > -1) ? new Date(data.firstLogin).toLocaleString() : "?"}`)
    if (!hasGuild && !loadingGuild) nameTextComponent.setClick("run_command", `/fsb --showGuild`)
    message.addTextComponent(lightColor + "▀█▀█▀█")
        .addTextComponent(new TextComponent(darkColor + "α").setHover("show_text", `&bProcessing Time: ${totalTime}ms\n  &cMojang Request: ${mojangTime}ms\n  &eHypixel Request: ${hypixelTime}ms\n  &dData Aggregation: ${aggregateTime}ms\n  &aBook Creation: ${createTime}ms${guildRequestText}`))
        .addTextComponent(lightColor + "█▀█▀█▀")
        .addTextComponent(`\n\n &3&oThe Fishing Stats of\n${centerBookPadding(data.name)}`)
        .addTextComponent(nameTextComponent)
        .addTextComponent(`\n${(data.completed ? "  &7&o-- Master Fisher --": "")}\n         `)
        .addTextComponent(new TextComponent("&9Overview").setHover("show_text", "&9Click to go to Overview").setClick("change_page", "2"))
        .addTextComponent("\n       ")
        .addTextComponent(new TextComponent("&9Special Fish").setHover("show_text", "&9Click to go to Special Fish").setClick("change_page", "3"))
        .addTextComponent("\n         ")
        .addTextComponent(new TextComponent("&9Individual").setHover("show_text", "&9Click to go to Individual Catches").setClick("change_page", "4"))
        .addTextComponent("\n        ")
        .addTextComponent(new TextComponent("&9Cosmetics").setHover("show_text", "&9Click to go to Unlocked Cosmetics").setClick("change_page", "5"))
        .addTextComponent("\n         ")
        .addTextComponent(new TextComponent("&9Enchants").setHover("show_text", "&9Click to go to Enchants").setClick("change_page", "6"))
        .addTextComponent("\n         ")
        .addTextComponent(new TextComponent("&9Seasonal").setHover("show_text", "&9Click to go to Seasonal Overview").setClick("change_page", "7"))
        .addTextComponent("\n           ")
        .addTextComponent(new TextComponent("&9Extra").setHover("show_text", "&9Click to go to Extra").setClick("change_page", (8 + seasons).toString()))
        .addTextComponent(`\n\n${lightColor}▄█▄█▄█`)
        .addTextComponent(new TextComponent(`${darkColor}α`).setHover("show_text", `&dSecret: &c${twoRandomLetters()}&a${twoRandomLetters()}&9${twoRandomLetters()}&e${twoRandomLetters()}&f:&b${threeRandomNumbers()}`))
        .addTextComponent(`${lightColor}█▄█▄█▄`)
    return message
}

function twoRandomLetters() {
    const lowercase = Math.floor(Math.random() * 2)
    const letter1 = 65 + Math.floor(Math.random() * 26) + 32 * lowercase
    const letter2 = 65 + Math.floor(Math.random() * 26) + 32 * lowercase
    return String.fromCharCode(letter1) + String.fromCharCode(letter2)
}

function threeRandomNumbers() {
    return Math.floor(Math.random() * 10).toString() + Math.floor(Math.random() * 10).toString() + Math.floor(Math.random() * 10).toString()
}

function createStatLine(name, color, value, total, water, lava, ice, isTotal = false, orbs = undefined) {
    const orbText = (orbs !== undefined) ? `\n&6MYTHICAL&8: ${color}${thousandSeparator(orbs)} ${percentage(orbs, value)}` : ""
    return new TextComponent(`&8${titleCase(name)}: ${darkenColor(name)}${thousandSeparator(value)}`).setHover("show_text", `&7${titleCase(name)} Caught: ${color}${thousandSeparator(value)} ${isTotal ? "" : percentage(value, total)}\n&9WATER&8: ${color}${thousandSeparator(water)} ${percentage(water, value)}\n&cLAVA&8: ${color}${thousandSeparator(lava)} ${percentage(lava, value)}\n&bICE&8: ${color}${thousandSeparator(ice)} ${percentage(ice, value)}${orbText}`)
}

const fsbArray = [
    ["fish", "&e"],
    ["junk", "&c"],
    ["treasure", "&a"],
    ["plant", "&2"],
    ["creature", "&b"]
]

function createStatsOverview(bookStats) {
    const message = new Message(new TextComponent("Overview").setHover("show_text", "&9Click to return to the Title Page").setClick("change_page", 1))
    const overall = bookStats.overall
    fsbArray.forEach(el => {
        message.addTextComponent("\n")
        message.addTextComponent(createStatLine(el[0], el[1], overall.total[el[0]], overall.total.total, overall.water[el[0]], overall.lava[el[0]], overall.ice[el[0]]))
    })

    let orb_hover = `&cMythical Fish Caught: &6${thousandSeparator(bookStats.orbs.total)} ${percentage(bookStats.orbs.total, overall.total.total)}`
    const orb_data = createOrbArray(bookStats.orbs)
    for (let i = 0; i < orb_names.length; i++) {
        orb_hover += `\n${orb_data[i][0]}: &6${thousandSeparator(orb_data[i][1])}`
        if (orb_data[i][2] > 0) {
            let color = "&f"
            if (orb_data[i][2] === maximumWeightValues[orb_names[i]]) color = "&6"
            orb_hover += ` &7| ${color}${orb_data[i][2]}kg`
        }
        orb_hover += ` ${percentage(orb_data[i][1], bookStats.orbs.total)}`
    }
    orb_hover += (`\n&9Total: &6${thousandSeparator(bookStats.orbs.total)}`)
    message.addTextComponent(new TextComponent(`\n&8Mythical Fish: &6${thousandSeparator(bookStats.orbs.total)}`).setHover("show_text", orb_hover))

    message.addTextComponent("\n").addTextComponent(createStatLine("total", "&d", overall.total.total, 0, overall.water.total, overall.lava.total, overall.ice.total, true, bookStats.orbs.total))

    let specialArray = []
    bookStats.special.forEach(el => specialArray.push("&e" + titleCase(el)))
    message.addTextComponent(new TextComponent(`\n&8Special Fish: &d${bookStats.special.length}`).setHover("show_text", `&7Special Fish Caught: &d${bookStats.special.length}${specialArray.length === 0 ? "" : "\n"}${specialArray.sort().join("\n")}`))

    let totalUnlocked = 0
    let totalMaximum = 0
    let completionHover = ""
    Object.keys(bookStats.completion.unlocked).forEach(el => {
        let unlocked = bookStats.completion.unlocked[el]
        let maximum = bookStats.completion.maximum[el]
        totalUnlocked += unlocked
        totalMaximum += maximum
        let lightColor = ""
        let darkColor = ""
        if (unlocked === 0) {
            lightColor = "&c"
            darkColor = "&4"
        } else if (unlocked === maximum) {
            lightColor = "&a"
            darkColor = "&2"
        } else {
            lightColor = "&e"
            darkColor = "&6"
        }
        completionHover += `\n&7${titleCase(el)}: ${lightColor}${unlocked}${darkColor}/${maximum}`
    })
    completionHover = `&7Fishing Completion: &b${totalUnlocked}&9/${totalMaximum}` + completionHover
    message.addTextComponent(new TextComponent(`\n&8Completion: &9${orbPercentage(totalUnlocked, totalMaximum)}`).setHover("show_text", completionHover))
    if (totalUnlocked === totalMaximum) bookStats.player.completed = true

    let masterTier = master_tiers.findIndex(el => el > bookStats.orbs.total)
    if (masterTier === -1) masterTier = master_tiers.length
    let seasonTierText = ""
    let seasonTierHover = ""
    if (stats.season !== undefined) {
        let seasonalMythics = 0
        let event = (stats.season_name === "Holidays") ? "christmas" : stats.season_name.toLowerCase()
        if (bookStats.seasonal[stats.season_year] !== undefined && bookStats.seasonal[stats.season_year][event] !== undefined) seasonalMythics = bookStats.seasonal[stats.season_year][event].total.orb
        let seasonalTier = seasonal_tiers.findIndex(el => el > seasonalMythics)
        if (seasonalTier === -1) seasonalTier = seasonal_tiers.length
        seasonTierText = ` &8| &2S${seasonalTier}`
        seasonTierHover = `\n&7Mythical Fish: &e${thousandSeparator(seasonalMythics)} Seasonal`
    }
    message.addTextComponent(new TextComponent(`\n&8Reward Tiers: &2M${masterTier}${seasonTierText}`).setHover("show_text", `&7Mythical Fish: &6${thousandSeparator(bookStats.orbs.total)} Total${seasonTierHover}`))
    if ((bookStats.orbs.archimedes > 0) || (bookStats.orbs.hades > 0)) message.addTextComponent(`\n&8Ultra Rares: ${(bookStats.orbs.archimedes > 0) ? "&2" : "&4"}D &8| ${(bookStats.orbs.hades > 0) ? "&2" : "&4"}H`)
    const fishedBeforeAPI = Object.keys(bookStats.individual.junk).reduce((a, b) => a + bookStats.individual.junk[b], 0) < bookStats.overall.total.junk
    if (Object.keys(bookStats.seasonal).length > 0) {
        let firstYear = Object.keys(bookStats.seasonal).sort()[0]
        let firstSeason = titleCase(["easter", "summer", "halloween", "christmas"].find(el => Object.keys(bookStats.seasonal[firstYear]).includes(el)))
        if (firstSeason === "Christmas") firstSeason = "Holidays"
        const tc = new TextComponent(`\n&8First Tracked Event: &2${firstSeason} ${firstYear}`)
        if (fishedBeforeAPI) {
            tc.setText(tc.getText() + "&7*")
            tc.setHover("show_text", "&7Fished before API (Halloween 2022)")
        }
        message.addTextComponent(tc)
    } else if (fishedBeforeAPI) message.addTextComponent(`\n&7Fished before API`)
    return message
}

function createHistoricalOverview(stats, total) {
    const message = new Message(new TextComponent("Seasonal Overview").setHover("show_text", "&9Click to return to the Title Page").setClick("change_page", 1))
    let page = 8
    if (Object.keys(stats).length === 0) message.addTextComponent("\n&cNo seasonal data!")
    else Object.keys(stats).forEach(year => {
        Object.keys(stats[year]).forEach(event => {
            let eventName = event
            if (event === "christmas") eventName = "holiday"
            eventName = titleCase(eventName + " " + year)
            message.addTextComponent(new TextComponent(`\n&8${eventName}`).setHover("show_text", `&9Click to go to ${eventName} ${percentage(stats[year][event].total.total, total)}\n&7Total Caught: &d${thousandSeparator(stats[year][event].total.total)}\n&9WATER&8: &d${thousandSeparator(stats[year][event].water.total)} ${percentage(stats[year][event].water.total, stats[year][event].total.total)}\n&cLAVA&8: &d${thousandSeparator(stats[year][event].lava.total)} ${percentage(stats[year][event].lava.total, stats[year][event].total.total)}\n&bICE&8: &d${thousandSeparator(stats[year][event].ice.total)} ${percentage(stats[year][event].ice.total, stats[year][event].total.total)}`).setClick("change_page", page))
            page++
        })
    })
    return message
}

function createHistoricalPages(stats, total, totalOrbs) {
    const historicalPages = []
    Object.keys(stats).forEach(year => {
        year = Number.parseInt(year)
        Object.keys(stats[year]).forEach(event => {
            let eventName = event
            if (event === "christmas") eventName = "holiday"
            eventName = titleCase(eventName + " " + year)
            let includeOrbs = (year > 2023 || (year === 2023 && (event === "halloween" || event === "christmas")))
            let includeEventStats = (year > 2025 || (year === 2025 && event !== "easter"))
            historicalPages.push(createHistoricalMessage(stats[year][event], eventName, total, (includeOrbs ? totalOrbs : -1), includeEventStats))
        })
    })
    return historicalPages
}

function createHistoricalMessage(stats, name, total, totalOrbs, includeEventStats) {
    const message = new Message(new TextComponent(name + " " + percentage(stats.total.total, total)).setHover("show_text", "&9Click to return to the Seasonal Overview").setClick("change_page", "7"))
    const slice = includeEventStats ? undefined : -2
    fsbArray.slice(0, slice).forEach(el => {
        message.addTextComponent("\n").addTextComponent(createStatLine(el[0], el[1], stats.total[el[0]], stats.total.total, stats.water[el[0]], stats.lava[el[0]], stats.ice[el[0]]))
    })
    if (totalOrbs > 0) message.addTextComponent("\n").addTextComponent(createStatLine("mythical_fish", "&6", stats.total.orb, totalOrbs, stats.water.orb, stats.lava.orb, stats.ice.orb))
    message.addTextComponent("\n").addTextComponent(createStatLine("total", "&d", stats.total.total, 0, stats.water.total, stats.lava.total, stats.ice.total, true))
    return message
}

function specialType(name) {
    if (["molten_iron", "regular_fish", "lava_shark", "burnt_plant"].includes(name)) return "lava"
    if (["frozen_fish", "dawning_snowball", "frozen_meal", "festive_lights"].includes(name)) return "ice"
    if (["angler", "barnacle", "carrot", "cherry_blossom", "chill_the_fish_3", "chocolate_bar", "clay_ball", "cracked_egg", "egg_the_fish", "eggnog", "eyeball", "fish_monger_suit_helmet", "fish_monger_suit_chestplate", "fish_monger_suit_leggings", "fish_monger_suit_boots", "hot_potato", "knockback_slimeball", "leviathan", "lucent_bee_hive", "nemo", "oops_the_fish", "pile_of_sand", "puffer_emoji", "pumpkin_pie", "pumpkin_spice_latte", "raw_ham", "rose", "sea_bass", "shark", "soggy_hot_cross_bun", "spook_the_fish", "star_eater_scales", "sunscreen", "wayfinders_compass", "rubber_duck", "festival_pufferfish_hat", "mahi_mahi", "poisonous_potato", "golden_apple"].includes(name)) return "water"
    return "other"
}

function createSpecialFishPage(specials) {
    const message = new Message(new TextComponent("Special Fish").setHover("show_text", "&9Click to return to the Title Page").setClick("change_page", 1))
    let counts = {
        water: 0,
        lava: 0,
        ice: 0,
        other: 0,
        total: 0
    }
    let other = []
    specials.forEach(el => {
        let type = specialType(el)
        if (type === "other") other.push(el)
        counts.total++
            counts[type]++
    })
    Object.keys(specialFish).forEach(season => {
        let hoverText = ""
        let count = 0
        let color
        switch (season) {
            case "regular":
                color = "&e"
                break
            case "summer":
                color = "&6"
                break
            case "halloween":
                color = "&5"
                break
            case "holiday":
                color = "&c"
                break
            case "easter":
                color = "&b"
                break
            case "event":
                color = "&2"
                break
            default:
                color = "&f"
                break
        }
        specialFish[season].forEach(el => {
            if (specials.includes(el.toLowerCase()
                    .replaceAll(" ", "_")
                    .replaceAll("-", "_")
                    .replaceAll("'", ""))) {
                hoverText += `\n${color}&l${el}`
                count++
            } else hoverText += `\n&7&l${el}`
        })
        hoverText = `${color}${titleCase(season)} Special Fish: &d${count}&5/${specialFish[season].length}` + hoverText
        message.addTextComponent(new TextComponent(`\n&8${titleCase(season)}: &d${count}`).setHover("show_text", hoverText))
    })
    if (counts.other > 0) {
        let hoverText = `&aOther Special Fish: &d${counts.other}`
        other.forEach(el => hoverText += `\n&a&l${titleCase(el)}`)
        message.addTextComponent(new TextComponent(`\n&8Other: &d${counts.other}`).setHover("show_text", hoverText))
    }
    let otherLine = ""
    if (counts.other > 0) otherLine = `\n&aOTHER&7: &d${counts.other}`
    message.addTextComponent(new TextComponent(`\n&8Total: &d${counts.total}\n`).setHover("show_text", `&7Special Fish Caught: &d${counts.total}&5/${specialCounts.total + counts.other}\n&9WATER&7: &d${counts.water}&5/${specialCounts.water}\n&cLAVA&7: &d${counts.lava}&5/${specialCounts.lava}\n&bICE&7: &d${counts.ice}&5/${specialCounts.ice}${otherLine}`))
    return message
}

function createIndividualPage(individual, total) {
    const message = new Message(new TextComponent("Individual Catches").setHover("show_text", "&9Click to return to the Title Page").setClick("change_page", 1))
    fsbArray.forEach(el => {
        let hoverText = ""
        let unknown = total[el[0]]
        let counts = []
        Object.keys(individual[el[0]]).forEach(value => {
            counts.push([titleCase(value), individual[el[0]][value]])
            unknown -= individual[el[0]][value]
        })
        if (unknown > 0) counts.push(["&oUnknown", unknown])
        counts.sort((a, b) => b[1] - a[1])
        counts.forEach(count => {
            hoverText += `\n&7${count[0]}: ${el[1]}${thousandSeparator(count[1])} ${percentage(count[1], total[el[0]])}`
        })
        hoverText = `&7Known ${titleCase(el[0])}: ${el[1]}${thousandSeparator(total[el[0]] - unknown)} ${percentage(total[el[0]] - unknown, total[el[0]])}` + hoverText
        message.addTextComponent(new TextComponent(`\n&8Hover for ${darkenColor(el[0])}${titleCase(el[0])}`).setHover("show_text", hoverText))
    })
    return message
}

function createCosmeticsPage(cosmetics) {
    const message = new Message(new TextComponent("Unlocked Cosmetics").setHover("show_text", "&9Click to return to the Title Page").setClick("change_page", 1))
    let trailHover = ""
    let trailCount = 0
    Object.keys(trail_dictionary).forEach(el => {
        trailHover += "\n"
        if (cosmetics.unlocked.trail.includes(el)) {
            trailHover += "&a"
            trailCount++
        } else trailHover += "&c"
        if (cosmetics.selected.trail === el) trailHover += "&l"
        trailHover += trail_dictionary[el]
    })
    trailHover = `&7Unlocked Fish Hook Trails: &a${trailCount}&2/${Object.keys(trail_dictionary).length}` + trailHover
    message.addTextComponent(new TextComponent(`\n&8Fish Hook Trail: &2${(trail_dictionary[cosmetics.selected.trail]) ? trail_dictionary[cosmetics.selected.trail] : titleCase(cosmetics.selected.trail)}`).setHover("show_text", trailHover))
    let rodHover = ""
    let rodCount = 0
    Object.keys(rod_dictionary).forEach(el => {
        let rod = rod_dictionary[el]
        if (!cosmetics.unlocked.rod.includes(el)) rod = rod.replaceAll(/&[0-9a-f]/gm, "&7")
        else rodCount++
            if (cosmetics.selected.rod === el) rod = rod.replaceAll(/([§&][0-9a-fr])+/gm, "$&§l")
        rodHover += "\n" + rod
    })
    rodHover = `&7Unlocked Fishing Rods: &a${rodCount}&2/${Object.keys(rod_dictionary).length}` + rodHover
    message.addTextComponent(new TextComponent(`\n&8Fishing Rod: ${(rod_dictionary[cosmetics.selected.rod]) ? rod_dictionary[cosmetics.selected.rod] : "&2" + titleCase(cosmetics.selected.rod)}`).setHover("show_text", rodHover))
    let lobbyHover = ""
    let lobbyCount = 0
    Object.keys(cosmeticNames).forEach(el => {
        lobbyHover += "\n"
        let cosmetic = cosmeticNames[el]
        if (!cosmetics.unlocked.lobby.includes(el)) cosmetic = cosmetic.replace(/&[0-9a-f]/gm, "&7")
        else lobbyCount++
            lobbyHover += cosmetic
    })
    lobbyHover = `&7Unlocked Lobby Cosmetics: &a${lobbyCount}&2/${Object.keys(cosmeticNames).length}` + lobbyHover
    message.addTextComponent(new TextComponent(`\n&8Lobby Cosmetics: &2${lobbyCount}`).setHover("show_text", lobbyHover))
    return message
}

function createEnchantsPage(bookData) {
    let enchants = bookData.enchants
    const message = new Message(new TextComponent("Enchants").setHover("show_text", "&9Click to return to the Title Page").setClick("change_page", 1))
    const regular_enchants = ["lure", "luck", "collector", "dumpster_diver"]
    regular_enchants.forEach(el => {
        let data = enchants[el]
        let hoverText = `${(data.toggle) ? "&a" : "&c"}${enchant_dictionary[el]}\n&7Level: &a${data.level}&2/${enchantTiers[el].length}`
        if (data.level !== enchantTiers[el].length) {
            let remaining = enchantTiers[el][data.level] - data.progress
            if (remaining < 0) remaining = 0
            hoverText += `\n&7${enchantUnlockItems[el]} till ${enchant_dictionary[el]} ${data.level + 1}: &e${remaining}`
        }
        bookData.completion.unlocked.enchants += data.level
        bookData.completion.maximum.enchants += enchantTiers[el].length
        message.addTextComponent(new TextComponent(`\n&8${enchant_dictionary[el]}: ${(data.toggle) ? "&2" : "&4"}${(data.level === 0 ? "&00" : romanize(data.level))}`).setHover("show_text", hoverText))
    })
    let vulcanHover = `${(enchants.vulcans_blessing.toggle) ? "&a" : "&c"}Vulcan's Blessing`
    vulcanHover += `\n${(enchants.vulcans_blessing.progress.flame === 1) ? "&a■" : "&c☐"} &7Flame of the Sun Titan`
    if (enchants.vulcans_blessing.progress.scales === 0 || enchants.vulcans_blessing.progress.scales === 10) vulcanHover += `\n${(enchants.vulcans_blessing.progress.scales === 10) ? "&a■" : "&c☐"} &710 Salmon Scales`
    else vulcanHover += `\n&e☐ &7${enchants.vulcans_blessing.progress.scales}/10 Salmon Scales`
    vulcanHover += `\n${(enchants.vulcans_blessing.progress.sealant === 1) ? "&a■" : "&c☐"} &7Curing Process`
    message.addTextComponent(new TextComponent(`\n&8Vulcan's Blessing: ${(enchants.vulcans_blessing.toggle) ? "&2" : "&4"}${(enchants.vulcans_blessing.level === 1) ? "I" : "&00"}`).setHover("show_text", vulcanHover))
    bookData.completion.unlocked.enchants += enchants.vulcans_blessing.level
    bookData.completion.maximum.enchants++;
    const toggle_enchants = ["neptunes_fury", "mythical_hook", "herbivore"]
    toggle_enchants.forEach(el => {
        message.addTextComponent(new TextComponent(`\n&8${enchant_dictionary[el]}: ${(enchants[el].toggle) ? "&2" : "&4"}${(enchants[el].level === 1) ? "I" : "&00"}`).setHover("show_text", `${(enchants[el].toggle) ? "&a" : "&c"}${enchant_dictionary[el]}`))
        if (enchants[el].level === 1) bookData.completion.unlocked.enchants++;
        bookData.completion.maximum.enchants++;
    })

    let chancesHover = "&7Relative Chances:"
    let chances = {
        fish: 79.7,
        junk: 10,
        mythical_fish: 0,
        treasure: 5,
        special_fish: 0.3
    }
    if (enchants.luck.toggle) chances.treasure += enchants.luck.level
    if (enchants.collector.toggle) chances.special_fish += enchants.collector.level * 0.2
    if (enchants.dumpster_diver.toggle) chances.junk += enchants.dumpster_diver.level * 2.5
    if (enchants.mythical_hook.toggle) chances.mythical_fish = 5
    const totalOdds = (chances.fish + chances.junk + chances.mythical_fish + chances.treasure + chances.special_fish) / 100
    Object.keys(chances).forEach(el => {
        let chance = (chances[el] / totalOdds).toPrecision(2)
        if (/[0-9]+\.0/.test(chance)) chance = chance.split(".")[0]
        chancesHover += `\n  &e${chance}% &f${titleCase(el)}`
    })
    message.addTextComponent(new TextComponent(`\n\n&8Hover for Chances`).setHover("show_text", chancesHover))
    return message
}


function createExtraPage(stats) {
    let extra = stats.extra
    const message = new Message(new TextComponent("Extra Info").setHover("show_text", "&9Click to return to the Title Page").setClick("change_page", 1))
    let overallUnlocked = 0
    let overallTotal = 0
    let achievementHover = ""
    console.log("[FSB] ap")
    Object.keys(extra.achievements).forEach(category => {
        let unlocked = 0
        let total = 0
        let categoryText = ""
        Object.keys(extra.achievements[category]).forEach(el => {
            if (Number.isInteger(extra.achievements[category][el])) {
                let tier = 0
                for (let i = 0; i < achievement_tiers[el].length; i++) {
                    if (achievement_tiers[el][i] < extra.achievements[category][el]) tier++
                        else break
                }
                if (tier === 0) categoryText += `\n  &c${achievement_dictionary[el]} (0&4/${achievement_tiers[el].length}&c)`
                else if (tier === achievement_tiers[el].length) categoryText += `\n  &a${achievement_dictionary[el]} (${tier}&2/${achievement_tiers[el].length}&a)`
                else categoryText += `\n  &e${achievement_dictionary[el]} (${tier}&6/${achievement_tiers[el].length}&e)`
                unlocked += tier
                total += achievement_tiers[el].length
            } else {
                if (extra.achievements[category][el]) {
                    categoryText += `\n  &a${achievement_dictionary[el]}`
                    unlocked++
                } else categoryText += `\n  &c${achievement_dictionary[el]}`
                total++
            }
        })
        if (unlocked === 0) categoryText = `\n&c${titleCase(category)} (0&4/${total}&c)` + categoryText
        else if (unlocked === total) categoryText = `\n&a${titleCase(category)} (${total}&2/${total}&a)` + categoryText
        else categoryText = `\n&e${titleCase(category)} (${unlocked}&6/${total}&e)` + categoryText
        achievementHover += categoryText
        overallUnlocked += unlocked
        overallTotal += total
    })
    stats.completion.unlocked.achievements = overallUnlocked
    stats.completion.maximum.achievements = overallTotal
    achievementHover = `&7Achievements Unlocked: &a${overallUnlocked}&2/${overallTotal}` + achievementHover
    message.addTextComponent(new TextComponent(`\n&8Achievements: &2${overallUnlocked}`).setHover("show_text", achievementHover))
    console.log("[FSB] tracked")
    let trackedHover = ""
    let trackedShorthand = ""
    let trackedProgress = "\n&7Fish: &e"
    if (extra.tracked === "") {
        trackedHover = "&cNone"
        trackedShorthand = "&cNone"
        trackedProgress = ""
    } else {
        let trackedResults = extra.tracked.match(trackedRegex)
        let trackedTier = extra.tracked.slice(extra.tracked.lastIndexOf("_") + 1)
        if (trackedResults !== null) {
            trackedHover = "&a" + titleCase(trackedTier.slice(0, trackedTier.lastIndexOf(" "))) + trackedTier.slice(trackedTier.lastIndexOf(" ")).toUpperCase()
            trackedShorthand = trackedResults[2].slice(2, 4) + trackedResults[1].slice(0, 1).toUpperCase() + parseRoman(trackedResults[3])
            let item = "orb"
            if (Number.parseInt(trackedResults[2]) < 2023 || (Number.parseInt(trackedResults[2]) === 2023 && (trackedResults[1] === "easter" || trackedResults[1] === "summer"))) item = "fish"
            if (item === "orb") trackedProgress = "\n&7Mythical Fish: &6"
            trackedProgress += thousandSeparator(stats.seasonal[trackedResults[2]][trackedResults[1]].total[item])
        } else {
            trackedHover = "&aMaster Reward Tier " + trackedTier.toUpperCase()
            trackedShorthand = "M" + parseRoman(trackedTier)
            trackedProgress += thousandSeparator(stats.overall.total.fish)
        }
    }
    message.addTextComponent(new TextComponent(`\n&8Tracked Reward: &2${trackedShorthand}`).setHover("show_text", trackedHover + trackedProgress))
    console.log("[FSB] lb")
    let leaderboard = ""
    let leaderboardHover = "&7Fishing Drop Type: "
    switch (extra.leaderboard) {
        case "FISH":
            leaderboard = "&6Fish"
            leaderboardHover += "&eFish"
            break
        case "JUNK":
            leaderboard = "&4Junk"
            leaderboardHover += "&cJunk"
            break
        case "TREASURE":
            leaderboard = "&2Treasure"
            leaderboardHover += "&aTreasure"
            break
        case "MYTHICAL_FISH":
            leaderboard = "&6Mythical"
            leaderboardHover += "&6Mythical Fish"
            break
        default:
            ChatLib.chat("unknown lb value: " + extra.leaderboard)
            leaderboard = "&0" + titleCase(extra.leaderboard)
            leaderboardHover += "&f" + titleCase(extra.leaderboard)
            break
    }
    message.addTextComponent(new TextComponent(`\n&8Leaderboard: ${leaderboard}`).setHover("show_text", leaderboardHover))
    let settingsHover = "&aMenu Settings"
    Object.keys(extra.settings).forEach(el => {
        settingsHover += `\n&7${settings_dictionary[el]}: ${settings_value_dictionary[el][extra.settings[el]]}`
    })
    console.log("[FSB] settings")
    message.addTextComponent(new TextComponent(`\n&8Settings: ${(extra.settings.fishCollectorShowCaught) ? "&4H" : "&2S"} &8| ${(extra.settings.simplifiedIcons) ? "&6S" : "&2N"}`).setHover("show_text", settingsHover))
    console.log("[FSB] npc")
    let npcCount = extra.npcs.dockmaster + extra.npcs.vulcan + extra.npcs.neptune
    let npcColorLight = "&e"
    let npcColorDark = "&6"
    if (npcCount === 3) {
        npcColorLight = "&a"
        npcColorDark = "&2"
    } else if (npcCount === 0) {
        npcColorLight = "&c"
        npcColorDark = "&4"
    }
    message.addTextComponent(new TextComponent(`\n&8NPCs: ${(extra.npcs.dockmaster) ? "&2" : "&4"}D &8| ${(extra.npcs.vulcan) ? "&2" : "&4"}V &8| ${(extra.npcs.neptune) ? "&2" : "&4"}N`).setHover("show_text", `&7NPCs Interacted With: ${npcColorLight}${npcCount}${npcColorDark}/3\n${(extra.npcs.dockmaster) ? "&a" : "&c"}Dock Master\n${(extra.npcs.vulcan) ? "&a" : "&c"}Vulcan's Dock Master\n${(extra.npcs.neptune) ? "&a" : "&c"}Neptune's Nereid`))
    message.addTextComponent("\n\n&7&omade with &c&o❤ &7&oby &3&oFishing&9&oUtils")
    return message
}

const romanNumerals = {
    i: 1,
    v: 5,
    x: 10,
    l: 50,
    c: 100,
    d: 500,
    m: 1000
}

function parseRoman(numeral) {
    let num = 0
    for (let i = 0; i < numeral.length - 1; i++) {
        if (romanNumerals[numeral[i]] < romanNumerals[numeral[i + 1]]) num -= romanNumerals[numeral[i]]
        else num += romanNumerals[numeral[i]]
    }
    return num + romanNumerals[numeral[numeral.length - 1]]
}

const trackedRegex = /fishing_reward_(\w+?)_(\d{4})_tier_[\w ]+ (\w+)/

let afkTimer = 0

let playerPos = {
    x: undefined,
    y: undefined,
    z: undefined
}

register("worldLoad", () => {
    playerPos.x = undefined
    playerPos.y = undefined
    playerPos.z = undefined
    afkTimer = Date.now()
    afkAlert.setString("")
})

register("tick", (elapsed) => {
    const afkThreshold = FishingUtils.getSetting("Miscellaneous", "AFK Alert Threshold")
    if (afkThreshold === 0) return
    const check = elapsed % 20 === 0
    const x = Math.floor(Player.getX())
    const y = Math.floor(Player.getY())
    const z = Math.floor(Player.getZ())
    if (playerPos.x !== x || playerPos.y !== y || playerPos.z !== z) {
        playerPos.x = x
        playerPos.y = y
        playerPos.z = z
        afkTimer = Date.now()
    }
    if (!check) return
    let afkLimit = 300
    if (Player.getContainer().getWindowId() !== 0) afkLimit *= 3
    const secondsTillAfkKick = Math.clamp(Math.floor(afkLimit - (Date.now() - afkTimer) / 1000), 0, afkLimit)
    if (enabled && secondsTillAfkKick <= afkThreshold) {
        afkAlert.setString("§cAFK kick in §e" + secondsTillAfkKick + (secondsTillAfkKick === 1 ? " §csecond!" : " §cseconds!"))
            .setX(Renderer.screen.getWidth() / 2)
            .setY(Renderer.screen.getHeight() / 2 + 20)
        World.playSound("note.bassattack", 1, 0.5)
        console.log("afk kick in " + secondsTillAfkKick + " seconds")
    } else afkAlert.setString("")
})

register("chat", (name) => {
    if (name !== Player.getName()) return
        // console.log("chat message sent, resetting afk timer")
    afkTimer = Date.now()
}).setChatCriteria(/&r(?:(?:&[0-9a-fr])*?\[[\w+&ዞ]+\] |&7)(\w{1,16})[&rf7]+?:/).setStart()
register("chat", (name) => {
    if (name !== Player.getName()) return
        // console.log("party message sent, resetting afk timer")
    afkTimer = Date.now()
}).setChatCriteria(/&r&9Party &8> (?:(?:&[0-9a-fr])*?\[[\w+&ዞ]+\] |&7)(\w{1,16})/).setStart()
register("chat", (name) => {
    if (name !== Player.getName()) return
        // console.log("guild message sent, resetting afk timer")
    afkTimer = Date.now()
}).setChatCriteria(/&r&2Guild > (?:(?:&[0-9a-fr])*?\[[\w+&ዞ]+\] |&7)(\w{1,16})/).setStart()
register("chat", (name) => {
    if (name !== Player.getName()) return
        // console.log("officer message sent, resetting afk timer")
    afkTimer = Date.now()
}).setChatCriteria(/&r&3Officer > (?:(?:&[0-9a-fr])*?\[[\w+&ዞ]+\] |&7)(\w{1,16})/).setStart()
register("chat", () => {
    // console.log("whisper sent, resetting afk timer")
    afkTimer = Date.now()
}).setChatCriteria(/&dTo (?:(?:&[0-9a-fr])*?\[[\w+&ዞ]+\] |&r&7)\w{1,16}/).setStart()

const afkAlert = new Text("").setShadow(true).setAlign("center")

register("renderOverlay", () => {
    if (enabled) afkAlert.draw()
})

function getStandsFromTexture(texture) {
    let stands = World.getAllEntitiesOfType(armorstand).filter(el => {
        try {
            console.log("[GET] parsing " + el.getName())
            let skin = getSkinFromOrb(el)
            if (skin === texture) {
                return true
            }
        } catch (e) {
            return false
        }
        return false
    })
    return stands
}

const mythicalTextures = {
    "helios": "c0102be6756274719b7f625830ea7ef5051c7d95dc01fe8359b4186378a0c263",
    "selene": "64a1fd9df8ad1d0e216ac347a39b47e797f4a3de7de4df073b065cb69f705baf",
    "nyx": "d56123b334c5c18a4df9c1d6aff25046f5e06a7ea8f60b80b91ae48ac7f9830d",
    "aphrodite": "fc084765c62c03f3479e759208ca1e7fa99f674d0c8be78a3f10f5b1e866ca24",
    "zeus": "bb42db182471da05bc2e3d04ea08b7069004f5c066c0aacca1f18c40ee3049cf",
    "archimedes": "a92dca1e8218b18b0759fc5baedc7e054067b1ec2f97b10c8c3fca8f923a0a6a",
    "hades": "a46fa2c5492722bd510cf546cde1b6b6c689e7640a99606ed49930fe54def0d"
}

/// BEGIN SIMPLER TIMES
function setSkinOfArmorStand(stand, gameProfile) {
    let skull = stand.entity.func_82169_q(3)
    skull.func_77983_a("SkullOwner", net.minecraft.nbt.NBTUtil.func_180708_a(NBT.parse({}).rawNBT, gameProfile))
}

function initializeGameProfiles(textures, profiles) {
    let previousTime = Date.now()
    let index = 0

    function processNext() {
        if (index < orb_names.length) {
            let el = orb_names[index]
            let encryptedValueString = java.util.Base64.getEncoder().encodeToString(stringToBytes(`{"textures":{"SKIN":{"url":"http://textures.minecraft.net/texture/${textures[el]}"}}}`))
            let replacementGameProfile = new com.mojang.authlib.GameProfile(java.util.UUID.randomUUID(), null)
            replacementGameProfile.getProperties().put("textures", new com.mojang.authlib.properties.Property("textures", encryptedValueString))
            profiles[el] = replacementGameProfile
            previousTime = Date.now()
            index++
            setTimeout(processNext, 0) // Schedule the next iteration
        } else {
            profiles.initialized = true
        }
    }

    processNext() // Start the processing
}

function stringToBytes(val) {
    const result = [];
    for (let i = 0; i < val.length; i++) {
        result.push(val.charCodeAt(i));
    }
    return result;
}
/// END SIMPLER TIMES

register("command", () => {
    if (!simplerTimes) {
        simplerTimes = true
        if (!orbGameProfiles.initialized) initializeGameProfiles(orbTextures, orbGameProfiles)
        let alreadyHidden = simplerTimesSettingObject.hidden
        simplerTimesSettingObject.setHidden(false)
        updateOrbImages()
        ChatLib.chat("&5You've gone back to simpler times...")
        if (alreadyHidden) {
            ChatLib.chat("&5&oYou can now permanently enable this in the settings")
            if (FishingUtils.getSetting("Miscellaneous", "Don't Convert Ultra Rares")) ChatLib.chat("&d&oBy default, ultra rares are not converted to orbs. You can change this behavior in the settings.")
            else ChatLib.chat("&d&oUltra rares will be converted to orbs. You can change this behavior in the settings.")
        }
    } else {
        simplerTimes = false
        updateOrbImages()
        ChatLib.chat("&5Alas, no more simpler times...")
    }
    updateDisplay()
}).setName("simplertimes").setAliases("naryka")

let loadingTransFish = false
register("step", () => {
    if (!loadingTransFish && FishingUtils.getSetting("Miscellaneous", "Trans Mythical Fish")) {
        loadingTransFish = true
        initializeGameProfiles(transTextures, transGameProfiles)
    }
}).setFps(1)