let resources = new Book("Fishing Resources")
    .addPage(new Message("&3&lFISHING RESOURCES\n\n&8This book contains a list of assets and resources from fishing.\n\n&3&lTABLE OF CONTENTS\n",
        new TextComponent("&9Achievements\n").setHover("show_text", "&9Click to go to Achievements").setClick("change_page", 3),
        new TextComponent("&9Banners\n").setHover("show_text", "&9Click to go to Banners").setClick("change_page", 5),
        new TextComponent("&9Catches\n").setHover("show_text", "&9Click to go to Catches").setClick("change_page", 6),
        new TextComponent("&9Cloaks\n").setHover("show_text", "&9Click to go to Cloaks").setClick("change_page", 11),
        new TextComponent("&9Fish Hook Trails\n").setHover("show_text", "&9Click to go to Fish Hook Trails").setClick("change_page", 12),
        new TextComponent("&8&ocont. on next page").setClick("change_page", 2)
    ))
    .addPage(new Message(
        new TextComponent("&9Fishing Rewards\n").setHover("show_text", "&9Click to go to Fishing Rewards").setClick("change_page", 13),
        new TextComponent("&9Fishing Rod Upgrades\n").setHover("show_text", "&9Click to go to Fishing Rod Upgrades").setClick("change_page", 14),
        new TextComponent("&9Fishing Rods\n").setHover("show_text", "&9Click to go to Fishing Rods").setClick("change_page", 16),
        new TextComponent("&9Gadgets\n").setHover("show_text", "&9Click to go to Gadgets").setClick("change_page", 17),
        new TextComponent("&9Hats\n").setHover("show_text", "&9Click to go to Hats").setClick("change_page", 18),
        new TextComponent("&9Miscellaneous\n").setHover("show_text", "&9Click to go to Miscellaneous").setClick("change_page", 19),
        new TextComponent("&9NPCs\n").setHover("show_text", "&9Click to go to NPCs").setClick("change_page", 20),
        new TextComponent("&9Orbs\n").setHover("show_text", "&9Click to go to Orbs").setClick("change_page", 21),
        new TextComponent("&9Pets\n").setHover("show_text", "&9Click to go to Pets").setClick("change_page", 22),
        new TextComponent("&9Skyblock Fish\n").setHover("show_text", "&9Click to go to Skyblock Fish").setClick("change_page", 23),
        new TextComponent("&9Special Fish\n").setHover("show_text", "&9Click to go to Special Fish").setClick("change_page", 24),
        new TextComponent("&9Statuses\n").setHover("show_text", "&9Click to go to Statuses").setClick("change_page", 28),
        new TextComponent("&9Updates").setHover("show_text", "&9Click to go to Updates").setClick("change_page", 29)
    ))
    .addPage(new Message(new TextComponent("&9Achievements").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 1),
        "\n&8Hover over the names for more info.\n\n",
        new TextComponent("Collector's Edition\n").setHover("show_text", "&aCollector's Edition (Summer)\nCollect all Special Fish while\nfishing in the Main Lobby\n\n&7Rewards:\n&8+&e20 &7Achievement Points\n&8+&6School Cloak\n\n&7This achievement is legacy and\n&7cannot be obtained anymore."),
        new TextComponent("Gone Fishing\n").setHover("show_text", "&aGone Fishing (Summer)\nCatch X treasure items in the\nMain Lobby\n\n&7Tiers:\n&e10 treasure items\n&e50 treasure items\n&e100 treasure items"),
        new TextComponent("Hot Potato\n").setHover("show_text", "&aHot Potato (General)\nHot, hot hot!\n\n&7Reward:\n&8+&6Hot Potato Gadget\n\n&7&oUnlocked by passing on the hot\n&7&opotato, which can be fished up."),
        new TextComponent("Main Lobby: Deep Sea Expert\n").setHover("show_text", "&aMain Lobby: Deep Sea Expert (General)\nCatch a Special Fish\n\n&7Reward:\n&8+&e10 &7Achievement Points"),
        new TextComponent("Main Lobby: Doing My Part\n").setHover("show_text", "&aMain Lobby: Doing My Part (General)\nFish up a junk item\n\n&7Reward:\n&8+&e5 &7Achievement Points"),
        new TextComponent("Main Lobby: Fishing Hobbyist").setHover("show_text", "&aMain Lobby: Fishing Hobbyist (General)\nCatch a fish\n\n&7Reward:\n&8+&e5 &7Achievement Points")
    ))
    .addPage(new Message(
        new TextComponent("Main Lobby: Luckiest of the Sea\n").setHover("show_text", "&aMain Lobby: Luckiest of the Sea (General)\nCatch X treasure items in the\nMain Lobby\n\n&7Tiers:\n&e10 treasure items\n&e25 treasure items\n&e50 treasure items\n&e100 treasure items\n&e500 treasure items"),
        new TextComponent("Main Lobby: Master Lure\n").setHover("show_text", "&aMain Lobby: Master Lure (General)\nCatch X fish in the Main Lobby\n\n&7Tiers:\n&e25 fish\n&e50 fish\n&e100 fish\n&e500 fish\n&e1,000 fish"),
        new TextComponent("Main Lobby: Old Farmer's Almanac\n").setHover("show_text", "&aMain Lobby: Old Farmer's Almanac (General)\nCatch a seasonal Special Fish\n\n&7Reward:\n&8+&e10 &7Achievement Points"),
        new TextComponent("Main Lobby: Tips and Tricks\n").setHover("show_text", "&aMain Lobby: Tips and Tricks (General)\nClaim a Fishing Rod Upgrade\n\n&7Reward:\n&8+&e5 &7Achievement Points"),
        new TextComponent("Main Lobby: Trashiest Diver\n").setHover("show_text", "&aMain Lobby: Trashiest Diver (General)\nCatch X junk items in the Main Lobby\n\n&7Tiers:\n&e10 junk items\n&e25 junk items\n&e50 junk items\n&e100 junk items\n&e500 junk items"),
        new TextComponent("Spring Fishing\n").setHover("show_text", "&aSpring Fishing (Easter)\nCatch 10 fish in the Main Lobby\nFishing Hut\n\n&7Reward:\n&8+&e5 &7Achievement Points"),
        new TextComponent("Spring Water").setHover("show_text", "&aSpring Water (Easter)\nCatch a lily pad in the Main\nLobby\n\n&7Reward:\n&8+&e5 &7Achievement Points")
    ))
    .addPage(new Message(new TextComponent("&9Banners").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 1),
        "\n&8Click the names below to go to the Miners Need Cool Shoes page.\n\n",
        new TextComponent("Seasoned Fisher Banner\n").setClick("open_url", "https://www.needcoolshoes.com/banner?=paecehejeqmvmK").setHover("show_text", "&6Seasoned Fisher Banner\n&cUnlocked by claiming the Summer Reward Tier VII"),
        new TextComponent("Legendary Fisher Banner\n").setClick("open_url", "https://www.needcoolshoes.com/banner?=paavbdaIdmarai").setHover("show_text", "&6Legendary Fisher Banner\n&cUnlocked by claiming the Master Reward Tier II"),
        new TextComponent("Spooky Fisher Banner\n").setClick("open_url", "https://www.needcoolshoes.com/banner?=eakckhkjkqbvcK").setHover("show_text", "&6Spooky Fisher Banner\n&cUnlocked by claiming the Halloween Reward Tier VII"),
        new TextComponent("Festive Fisher Banner").setClick("open_url", "https://www.needcoolshoes.com/banner?=pabcbhbjbqhvbK").setHover("show_text", "&6Festive Fisher Banner\n&cUnlocked by claiming the Holiday Reward Tier VII"),
    ))
    .addPage(new Message(new TextComponent("&9Catches").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 1),
        "\n&8Hover over the names for more info.\n\n",
        new TextComponent("Cod\n").setHover("show_text", "&eCod\n&7Type: &eFish\n&7Found In: &9WATER\n\n&9Displays as Raw Fish"),
        new TextComponent("Salmon\n").setHover("show_text", "&eSalmon\n&7Type: &eFish\n&7Found In: &9WATER\n\n&9Displays as Raw Salmon"),
        new TextComponent("Clownfish\n").setHover("show_text", "&eClownfish\n&7Type: &eFish\n&7Found In: &9WATER\n\n&9Displays as Clownfish"),
        new TextComponent("Pufferfish\n").setHover("show_text", "&ePufferfish\n&7Type: &eFish\n&7Found In: &9WATER\n\n&9Displays as Pufferfish"),
        new TextComponent("Cooked Cod\n").setHover("show_text", "&eCooked Cod\n&7Type: &eFish\n&7Found In: &cLAVA\n\n&9Displays as Cooked Fish"),
        new TextComponent("Cooked Salmon\n").setHover("show_text", "&eCooked Salmon\n&7Type: &eFish\n&7Found In: &cLAVA\n\n&9Displays as Cooked Salmon"),
        new TextComponent("Charred Pufferfish\n").setHover("show_text", "&eCharred Pufferfish\n&7Type: &eFish\n&7Found In: &cLAVA\n\n&9Displays as Fire Charge"),
        new TextComponent("Trout\n").setHover("show_text", "&eTrout\n&7Type: &eFish\n&7Found In: &bICE\n\n&9Displays as Cooked Salmon"),
        new TextComponent("Perch\n").setHover("show_text", "&ePerch\n&7Type: &eFish\n&7Found In: &bICE\n\n&9Displays as Raw Fish"),
        new TextComponent("Pike").setHover("show_text", "&ePike\n&7Type: &eFish\n&7Found In: &bICE\n\n&9Displays as Raw Fish")
    ))
    .addPage(new Message(
        new TextComponent("Bowl\n").setHover("show_text", "&cBowl\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Bowl"),
        new TextComponent("Leather\n").setHover("show_text", "&cLeather\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Leather"),
        new TextComponent("Leather Boots\n").setHover("show_text", "&cLeather Boots\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Leather Boots"),
        new TextComponent("Rotten Flesh\n").setHover("show_text", "&cRotten Flesh\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Rotten Flesh"),
        new TextComponent("Stick\n").setHover("show_text", "&cStick\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Stick"),
        new TextComponent("String\n").setHover("show_text", "&cString\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as String"),
        new TextComponent("Bone\n").setHover("show_text", "&cBone\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Bone"),
        new TextComponent("Ink Sac\n").setHover("show_text", "&cInk Sac\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Ink Sac"),
        new TextComponent("Tripwire Hook\n").setHover("show_text", "&cTripwire Hook\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Tripwire Hook\n&eThis is the item you appear to\n&ecatch when you catch an orb."),
        new TextComponent("Lily Pad\n").setHover("show_text", "&cLily Pad\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Lily Pad"),
        new TextComponent("Water Bottle\n").setHover("show_text", "&cWater Bottle\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Bottle of Water"),
        new TextComponent("Broken Fishing Rod\n").setHover("show_text", "&cBroken Fishing Rod\n&7Type: &cJunk\n&7Found In:\n &9WATER\n &bICE\n\n&9Displays as Fishing Rod"),
        new TextComponent("Soggy Paper\n").setHover("show_text", "&cSoggy Paper\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Paper"),
        new TextComponent("Rabbit Hide").setHover("show_text", "&cRabbit Hide\n&7Type: &cJunk\n&7Found In: &9WATER\n\n&9Displays as Rabbit Hide")
    ))
    .addPage(new Message(
        new TextComponent("Coal\n").setHover("show_text", "&cCoal\n&7Type: &cJunk\n&7Found In: &cLAVA\n\n&9Displays as Coal"),
        new TextComponent("Charcoal\n").setHover("show_text", "&cCharcoal\n&7Type: &cJunk\n&7Found In: &cLAVA\n\n&9Displays as Charcoal"),
        new TextComponent("Nether Brick\n").setHover("show_text", "&cNether Brick\n&7Type: &cJunk\n&7Found In: &cLAVA\n\n&9Displays as Nether Brick"),
        new TextComponent("Steak\n").setHover("show_text", "&cSteak\n&7Type: &cJunk\n&7Found In: &cLAVA\n\n&9Displays as Steak"),
        new TextComponent("Burned Flesh\n").setHover("show_text", "&cBurned Flesh\n&7Type: &cJunk\n&7Found In: &cLAVA\n\n&9Displays as Rotten Flesh"),
        new TextComponent("Fermented Spider Eye\n").setHover("show_text", "&cFermented Spider Eye\n&7Type: &cJunk\n&7Found In: &cLAVA\n\n&9Displays as Fermented Spider Eye"),
        new TextComponent("Lava Bucket\n").setHover("show_text", "&cLava Bucket\n&7Type: &cJunk\n&7Found In: &cLAVA\n\n&9Displays as Bucket of Lava"),
        new TextComponent("Snowball\n").setHover("show_text", "&cSnowball\n&7Type: &cJunk\n&7Found In: &bICE\n\n&9Displays as Snowball"),
        new TextComponent("Ice Shard\n").setHover("show_text", "&cIce Shard\n&7Type: &cJunk\n&7Found In: &bICE\n\n&9Displays as Prismarine Shard"),
        new TextComponent("Clump Of Leaves\n").setHover("show_text", "&cClump Of Leaves\n&7Type: &cJunk\n&7Found In: &bICE\n\n&9Displays as Cactus Green"),
        new TextComponent("Frozen Flesh\n").setHover("show_text", "&cFrozen Flesh\n&7Type: &cJunk\n&7Found In: &bICE\n\n&9Displays as Rotten Flesh"),
        new TextComponent("Enchanted Book\n").setHover("show_text", "&aEnchanted Book\n&7Type: &aTreasure\n&7Found In:\n &9WATER\n &bICE\n\n&9Displays as Enchanted Book"),
        new TextComponent("Name Tag\n").setHover("show_text", "&aName Tag\n&7Type: &aTreasure\n&7Found In: &9WATER\n\n&9Displays as Name Tag"),
        new TextComponent("Saddle").setHover("show_text", "&aSaddle\n&7Type: &aTreasure\n&7Found In: &9WATER\n\n&9Displays as Saddle")
    ))
    .addPage(new Message(
        new TextComponent("Enchanted Bow\n").setHover("show_text", "&aEnchanted Bow\n&7Type: &aTreasure\n&7Found In: &9WATER\n\n&9Displays as Bow"),
        new TextComponent("Enchanted Fishing Rod\n").setHover("show_text", "&aEnchanted Fishing Rod\n&7Type: &aTreasure\n&7Found In:\n &9WATER\n &bICE\n\n&9Displays as Fishing Rod"),
        new TextComponent("Diamond\n").setHover("show_text", "&aDiamond\n&7Type: &aTreasure\n&7Found In:\n &9WATER\n &bICE\n\n&9Displays as Diamond"),
        new TextComponent("Diamond Sword\n").setHover("show_text", "&aDiamond Sword\n&7Type: &aTreasure\n&7Found In:\n &9WATER\n &bICE\n\n&9Displays as Diamond Sword"),
        new TextComponent("Gold Pickaxe\n").setHover("show_text", "&aGold Pickaxe\n&7Type: &aTreasure\n&7Found In: &9WATER\n\n&9Displays as Golden Pickaxe"),
        new TextComponent("Compass\n").setHover("show_text", "&aCompass\n&7Type: &aTreasure\n&7Found In: &9WATER\n\n&9Displays as Compass"),
        new TextComponent("Emerald\n").setHover("show_text", "&aEmerald\n&7Type: &aTreasure\n&7Found In: &9WATER\n\n&9Displays as Emerald"),
        new TextComponent("Blaze Powder\n").setHover("show_text", "&aBlaze Powder\n&7Type: &aTreasure\n&7Found In: &cLAVA\n\n&9Displays as Blaze Powder"),
        new TextComponent("Magma Cream\n").setHover("show_text", "&aMagma Cream\n&7Type: &aTreasure\n&7Found In: &cLAVA\n\n&9Displays as Magma Cream"),
        new TextComponent("Molten Gold\n").setHover("show_text", "&aMolten Gold\n&7Type: &aTreasure\n&7Found In: &cLAVA\n\n&9Displays as Gold Ingot"),
        new TextComponent("Blaze Rod\n").setHover("show_text", "&aBlaze Rod\n&7Type: &aTreasure\n&7Found In: &cLAVA\n\n&9Displays as Blaze Rod"),
        new TextComponent("Eye Of Ender\n").setHover("show_text", "&aEye Of Ender\n&7Type: &aTreasure\n&7Found In: &cLAVA\n\n&9Displays as Eye Of Ender"),
        new TextComponent("Chainmail Chestplate\n").setHover("show_text", "&aChainmail Chestplate\n&7Type: &aTreasure\n&7Found In: &cLAVA\n\n&9Displays as Chainmail Chestplate"),
        new TextComponent("Gold Sword").setHover("show_text", "&aGold Sword\n&7Type: &aTreasure\n&7Found In: &cLAVA\n\n&9Displays as Golden Sword")
    ))
    .addPage(new Message(
        new TextComponent("Iron Sword\n").setHover("show_text", "&aIron Sword\n&7Type: &aTreasure\n&7Found In: &bICE\n\n&9Displays as Iron Sword"),
        new TextComponent("Coins\n").setHover("show_text", "&aCoins\n&7Type: &aTreasure\n&7Found In:\n &9WATER\n &cLAVA\n &bICE\n\n&9Displays as Gold Ingot\n&eRanges from 1-250"),
        new TextComponent("Event Experience\n").setHover("show_text", "&aEvent Experience\n&7Type: &aTreasure\n&7Found In:\n &9WATER\n &cLAVA\n &bICE\n\n&9Displays as Emerald\n&eRanges from 1-100\n&cOnly catchable during an event."),
        new TextComponent("Hypixel Experience").setHover("show_text", "&aHypixel Experience\n&7Type: &aTreasure\n&7Found In:\n &9WATER\n &cLAVA\n &bICE\n\n&9Displays as Cyan Dye\n&eRanges from 1-250")
        //     new TextComponent("Clownfish\n").setHover("show_text", "#0349/2"),
        //     new TextComponent("Cod\n").setHover("show_text", "#0349/0"),
        //     new TextComponent("Pufferfish\n").setHover("show_text", "#0349/3"),
        //     new TextComponent("Salmon\n").setHover("show_text", "#0349/1"),
        //     "&4Junk:\n",
        //     new TextComponent("Bone\n").setHover("show_text", "#0352"),
        //     new TextComponent("Bowl\n").setHover("show_text", "#0281"),
        //     new TextComponent("Broken Fishing Rod\n").setHover("show_text", "#0346"),
        //     new TextComponent("Ink Sac").setHover("show_text", "#0351/0"),
        // ))
        // .addPage(new Message(
        //     new TextComponent("Leather\n").setHover("show_text", "#0334"),
        //     new TextComponent("Leather Boots\n").setHover("show_text", "#0301"),
        //     new TextComponent("Lily Pad\n").setHover("show_text", "#0111"),
        //     new TextComponent("Paper\n").setHover("show_text", "#0339"),
        //     new TextComponent("Rabbit Hide\n").setHover("show_text", "#0415"),
        //     new TextComponent("Rotten Flesh\n").setHover("show_text", "#0367"),
        //     new TextComponent("Stick\n").setHover("show_text", "#0280"),
        //     new TextComponent("String\n").setHover("show_text", "#0287"),
        //     new TextComponent("Tripwire Hook\n").setHover("show_text", "#0131\nThis is the item you appear to\ncatch when you catch an orb."),
        //     new TextComponent("Water Bottle\n").setHover("show_text", "#0373/0"),
        //     "&2Treasure:\n",
        //     new TextComponent("Coins\n").setHover("show_text", "#0266\nThe item displays as a gold ingot.\nRanges from 1-250."),
        //     new TextComponent("Compass\n").setHover("show_text", "#0345"),
        //     new TextComponent("Diamond").setHover("show_text", "#0264"),
        // ))
        // .addPage(new Message(
        //     new TextComponent("Diamond Sword\n").setHover("show_text", "#0276"),
        //     new TextComponent("Emerald\n").setHover("show_text", "#0388"),
        //     new TextComponent("Enchanted Book\n").setHover("show_text", "#0403"),
        //     new TextComponent("Enchanted Bow\n").setHover("show_text", "#0261"),
        //     new TextComponent("Enchanted Fishing Rod\n").setHover("show_text", "#0346"),
        //     new TextComponent("Event Experience\n").setHover("show_text", "#0388\nThe item displays as an emerald.\nRanges from 1-100.\nOnly catchable during an event."),
        //     new TextComponent("Gold Pickaxe\n").setHover("show_text", "#0285"),
        //     new TextComponent("Hypixel Experience\n").setHover("show_text", "#0351/6\nThe item displays as cyan dye.\nRanges from 1-250."),
        //     new TextComponent("Name Tag\n").setHover("show_text", "#0421"),
        //     new TextComponent("Saddle").setHover("show_text", "#0329")
    ))
    .addPage(new Message(new TextComponent("&9Cloaks").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 1),
        "\n&8Hover over the names for more info.\n\n",
        new TextComponent("School Cloak\n").setHover("show_text", "&6School Cloak\n&7Blub.\n\n&cUnlocked by obtaining the Collector's\n&cEdition achievement or by claiming\n&cthe Halloween Reward Tier VIII\n&9Displays as #0349/0 (Raw Fish)"),
        new TextComponent("Aquarium Cloak").setHover("show_text", "&6Aquarium Cloak\n&7Become a portable fish tank!\n\n&cUnlocked by claiming the Master Reward\n&cTier IV\n&9Displays as #0349/1 (Raw Salmon)")
    ))
    .addPage(new Message(new TextComponent("&9Fish Hook Trails").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 1),
        "\n&8Hover over the names for more info.\n\n",
        new TextComponent("None\n").setHover("show_text", "&aNone\n&cRequires: Nothing\n&eParticles: None\n&9Display Item: #0166 (Barrier)"),
        new TextComponent("Emerald\n").setHover("show_text", "&aEmerald\n&cRequires: Master Reward I\n&eParticles: Happy Villager\n&9Display Item: #0388 (Emerald)"),
        new TextComponent("Sparkle\n").setHover("show_text", "&aSparkle\n&cRequires: 20 Special Fish\n&eParticles: Magic Crit\n&9Display Item: #0261 (Bow)"),
        new TextComponent("Treasure's Sheen\n").setHover("show_text", "&aTreasure's Sheen\n&cRequires: 5,000 Treasure\n&eParticles: Fireworks Spark\n&9Display Item: #0266 (Gold Ingot)"),
        new TextComponent("Beloved Junk\n").setHover("show_text", "&aBeloved Junk\n&cRequires: 5,000 Junk\n&eParticles: Angry Villager\n&9Display Item: #0280 (Stick)"),
        new TextComponent("Archimedes' Trail\n").setHover("show_text", "&aArchimedes' Trail\n&cRequires: Deactivate Archimedes' Sphere 1 time\n&eParticles: Enchantment Table\n&9Display Item: #0340 (Book)"),
        new TextComponent("Hades' Hook").setHover("show_text", "&aHades' Hook\n&cRequires: Deactivate Hades' Wrath 5 times\n&eParticles: Unknown\n&9Display Item: Unknown")
    ))
    .addPage(new Message(new TextComponent("&9Fishing Rewards").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Hover over the numbers for more info.\n\n&8Master:\n",
        new TextComponent("&01").setHover("show_text", "&aMaster Reward Tier I\n&7Required Fish: &e10,000 Total\n\n&7Rewards:\n&8+&310,000 &7Hypixel Experience\n&8+&6Emerald Fish Hook Trail"),
        "&8-",
        new TextComponent("&02").setHover("show_text", "&aMaster Reward Tier II\n&7Required Fish: &e25,000 Total\n\n&7Rewards:\n&8+&325,000 &7Hypixel Experience\n&8+&6Legendary Fisher Banner"),
        "&8-",
        new TextComponent("&03").setHover("show_text", "&aMaster Reward Tier III\n&7Required Fish: &e50,000 Total\n\n&7Rewards:\n&8+&350,000 &7Hypixel Experience\n&8+&6Legendary Fisher Status"),
        "&8-",
        new TextComponent("&04").setHover("show_text", "&aMaster Reward Tier IV\n&7Required Fish: &e100,000 Total\n\n&7Rewards:\n&8+&3100,000 &7Hypixel Experience\n&8+&6Aquarium Cloak"),
        "\n\n&8Seasonal: &7(generalized)\n",
        new TextComponent("&01").setHover("show_text", "&aSeasonal Reward Tier I\n&7Required Fish: &e50 Seasonal\n\n&7Rewards:\n&8+&9Pufferfish Hat\n&8+&b1 &eSeasonal Mystery Box\n&8+&e2 &6Bed Wars Loot Chest"),
        "&8-",
        new TextComponent("&02").setHover("show_text", "&aSeasonal Reward Tier II\n&7Required Fish: &e150 Seasonal\n\n&7Rewards:\n&8+&71 &62.0x &7Personal Coin Booster (&bThree Hour&7)\n&8+&e5 &dDaily Reward Token"),
        "&8-",
        new TextComponent("&03").setHover("show_text", "&aSeasonal Reward Tier III\n&7Required Fish: &e300 Seasonal\n\n&7Rewards:\n&8+&b3 &6Seasonal Mystery Boxes\n&8+&e3 &6Bed Wars Seasonal Chest"),
        "&8-",
        new TextComponent("&04").setHover("show_text", "&aSeasonal Reward Tier IV\n&7Required Fish: &e500 Seasonal\n\n&7Rewards:\n&8+&e3 &6Murder Mystery Seasonal Chest\n&8+&e3 &6Bed Wars Seasonal Chest"),
        "&8-",
        new TextComponent("&05").setHover("show_text", "&aSeasonal Reward Tier V\n&7Required Fish: &e750 Seasonal\n\n&7Rewards:\n&8+&b5 &6Seasonal Mystery Boxes\n&8+&b2 &6Seasonal Gift Boxes"),
        "&8-",
        new TextComponent("&06").setHover("show_text", "&aSeasonal Reward Tier VI\n&7Required Fish: &e1,050 Seasonal\n\n&7Rewards:\n&8+&dCosmetic\n&8+&72 &62.0x &7Personal Coin Booster (&bFour Hour&7)"),
        "&8-",
        new TextComponent("&07").setHover("show_text", "&aSeasonal Reward Tier VII\n&7Required Fish: &e1,400 Seasonal\n\n&7Rewards:\n&8+&6Banner\n&8+&e3 &6Bed Wars Seasonal Chest\n&8+&e3 &6Murder Mystery Seasonal Chest"),
        "&8-",
        new TextComponent("&08").setHover("show_text", "&aSeasonal Reward Tier VIII\n&7Required Fish: &e2,500 Seasonal\n\n&7Reward:\n&8+&dCosmetic")
    ))
    .addPage(new Message(new TextComponent("&9Fishing Rod Upgrades").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Hover over the names and numbers for more info.\n",
        new TextComponent("\n&8Lure\n").setHover("show_text", "&9Displays as #0346 (Fishing Rod)\n&7Increases fishing speed."),
        new TextComponent("&03").setHover("show_text", "&eUnlocked by default"),
        "&8-",
        new TextComponent("&04").setHover("show_text", "&7Required Fish: &e500"),
        "&8-",
        new TextComponent("&05").setHover("show_text", "&7Required Fish: &e1,500"),
        "&8-",
        new TextComponent("&06").setHover("show_text", "&7Required Fish: &e3,000"),
        new TextComponent("\n&8Luck of the Sea\n").setHover("show_text", "&9Displays as #0388 (Emerald)\n&7Increases treasure drop chances."),
        new TextComponent("&02").setHover("show_text", "&eUnlocked by default"),
        "&8-",
        new TextComponent("&03").setHover("show_text", "&7Required Treasure: &e100"),
        "&8-",
        new TextComponent("&04").setHover("show_text", "&7Required Treasure: &e250"),
        "&8-",
        new TextComponent("&05").setHover("show_text", "&7Required Treasure: &e750"),
        "&8-",
        new TextComponent("&06").setHover("show_text", "&7Required Treasure: &e1,000"),
        new TextComponent("\n&8Collector\n").setHover("show_text", "&9Displays as #0349/2 (Clownfish)\n&7Slightly increases special fish\n&7drop chances."),
        new TextComponent("&01").setHover("show_text", "&7Required Junk: &e250"),
        "&8-",
        new TextComponent("&02").setHover("show_text", "&7Required Junk: &e500"),
        "&8-",
        new TextComponent("&03").setHover("show_text", "&7Required Junk: &e1,000"),
        "&8-",
        new TextComponent("&04").setHover("show_text", "&7Required Junk: &e2,500"),
        new TextComponent("\n&8Dumpster Diver\n").setHover("show_text", "&9Displays as #0301 (Leather Boots)\n&7Increases junk drop chances."),
        new TextComponent("&01").setHover("show_text", "&7Required Special Fish: &e1"),
        "&8-",
        new TextComponent("&02").setHover("show_text", "&7Required Special Fish: &e2"),
        "&8-",
        new TextComponent("&03").setHover("show_text", "&7Required Special Fish: &e3"),
        "&8-",
        new TextComponent("&04").setHover("show_text", "&7Required Special Fish: &e4"),
        "&8-",
        new TextComponent("&05").setHover("show_text", "&7Required Special Fish: &e5")
    ))
    .addPage(new Message(new TextComponent("&8Vulcan's Blessing\n").setHover("show_text", "&9Displays as #0327 (Bucket of Lava)\n&7Allows for fishing in lava."),
        new TextComponent("&01").setHover("show_text", "&e□ &7Flame of the Sun Titan\n&e□ &710 Salmon Scales\n&e□ &7Curing Process"),
        new TextComponent("\n&8Neptune's Fury\n").setHover("show_text", "&9Displays as #0409 (Prismarine Shard)\n&7Slightly increases special fish\n&7drop chances."),
        new TextComponent("&01").setHover("show_text", "&7Speak to &bNeptune's Nereid\n&7in the Ice Fishing area during\n&7the Holidays Event in December.")
    ))
    .addPage(new Message(new TextComponent("&9Fishing Rods").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Hover over the names for more info.\n\n",
        new TextComponent("Fishing Rod 3000\n").setHover("show_text", "&6Fishing Rod &l3000\n&7Unlocked by default."),
        new TextComponent("Inaugural Ice Fishing Rod\n").setHover("show_text", "&bInaugural Ice Fishing Rod\n&7Catch 100 fish in ice during the 2022 Holidays event."),
        new TextComponent("Springtime Fishing Rod").setHover("show_text", "&eSpringtime Fishing Rod\n&7Claim the Easter Reward Tier III (1000 fish) during the easter event.")
    ))
    .addPage(new Message(new TextComponent("&9Gadgets").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Hover over the names for more info.\n\n",
        new TextComponent("Hot Potato Gadget\n").setHover("show_text", "&bHot Potato Gadget (Fun & Games)\n&7Hot, hot, hot!\n\n&cUnlocked by passing on the Hot Potato Special Fish\n&c&o(can also be obtained from an admin)\n&9Displays as #0392 (Potato)"),
        new TextComponent("Portable Pond Gadget\n").setHover("show_text", "&6Portable Pond Gadget (Fun & Games)\n&7Bring the fish wherever you go!\n\n&cUnlocked by claiming the Summer Reward Tier VI\n&9Displays as #0326 (Bucket of Water)"),
        new TextComponent("Spooky Fish Gadget").setHover("show_text", "&6Spooky Fish Gadget (Halloween)\n&7The fish are flying!\n\n&cUnlocked by claiming the Halloween Reward Tier VI\n&9Displays as #0349/0 (Raw Fish)")
    ))
    .addPage(new Message(new TextComponent("&9Hats").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Click the names below to go to the Minecraft Heads page.\n\n",
        new TextComponent("Festive Pufferfish Hat\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/animals/24779-pufferfish-festive").setHover("show_text", "&6Festive Pufferfish Hat\n&cUnlocked by catching the Festive Pufferfish Hat Special Fish"),
        new TextComponent("Golden Pufferfish Hat\n").setClick("open_url", "http://textures.minecraft.net/texture/668b0536f64b0bffa82886968337f09a00fa7e07f1604475d738316bbc4ae8a2").setHover("show_text", "&6Golden Pufferfish Hat\n&cUnlocked by claiming the Summer Reward Tier I\n\n&7&oThe Minecraft Heads page is currently unknown."),
        new TextComponent("Spooked Pufferfish Hat").setClick("open_url", "https://minecraft-heads.com/custom-heads/animals/30033-pufferfish-astonished").setHover("show_text", "&6Spooked Pufferfish Hat\n&cUnlocked by claiming the Halloween Reward Tier I")
    ))
    .addPage(new Message(new TextComponent("&9Miscellaneous").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Hover over the names for more info.\n\n",
        new TextComponent("Fish Monger Suit\n").setHover("show_text", "&6Fish Monger Suit\n\n&aAs you walk, the fish will\n&afollow.\n\n&aFull Set Ability: Spawn fish in\n&ayour wake as you walk around the\n&alobby!\n\n&cUnlocked by catching each suit pieces'\n&crespective special fish.\n&9Displays as #0298 (Leather Helmet)\n\n&7&oThe full suit will also change colors\n&7&obetween light blue and dark blue."),
        new TextComponent("Fished Punch Message\n").setHover("show_text", "&aFished Punch Message\n\n&7Preview: &b[MVP&c+&b] Steve &a&lfished &b[MVP&c+&b] Steve &7into the sky!\n\n&cUnlocked by claiming the Holiday Reward Tier VI\n&9Displays as #0346 (Fishing Rod)"),
    ))
    .addPage(new Message(new TextComponent("&9NPCs").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Click the names below to go to the skin file.\n\n",
        new TextComponent("Fish Collector").setClick("open_url", "https://i.imgur.com/k0Oe8rL.png"),
        " &7(taken from ",
        new TextComponent("&7&nthis list").setClick("open_url", "https://imgur.com/a/hdgfh"),
        "&7)\n",
        new TextComponent("Dock Master\n").setClick("open_url", "http://textures.minecraft.net/texture/b5403826d1e0fe685c64af388bb8e6076c0da17b3fbe1c0e234c3fa6f4b4c467"),
        new TextComponent("Neptune's Nereid").setClick("open_url", "http://textures.minecraft.net/texture/cb54f5f8ff94f6aa4477b313e82c9d3535ecd32f23362816202c3e40c8e3595c"),
    ))
    .addPage(new Message(new TextComponent("&9Orbs").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Click the names below to go to the Minecraft Heads page.\n\n",
        new TextComponent("Orb of Helios\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/decoration/51720-orb-yellow").setHover("show_text", "&7Rarity: &eCommon"),
        new TextComponent("Orb of Selene\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/decoration/23169-iron-orb").setHover("show_text", "&7Rarity: &eCommon"),
        new TextComponent("Heart of Aphrodite\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/decoration/52468-orb-red").setHover("show_text", "&7Rarity: &aUncommon"),
        new TextComponent("Shadow of Nyx\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/decoration/26639-shadow-orb").setHover("show_text", "&7Rarity: &aUncommon"),
        new TextComponent("Spark of Zeus\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/decoration/44796-energy-core").setHover("show_text", "&7Rarity: &bRare"),
        new TextComponent("Archimedes' Sphere\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/miscellaneous/4322-fancy-cube").setHover("show_text", "&7Rarity: &dUltra Rare"),
        new TextComponent("Hades' Wrath").setClick("open_url", "https://minecraft-heads.com/player-heads/blocks/3556-fire-charge").setHover("show_text", "&7Rarity: &dUltra Rare")
    ))
    .addPage(new Message(new TextComponent("&9Pets").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Click the names below to go to the Minecraft Heads page.\n\n",
        new TextComponent("Fish Pet\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/animals/25805-fish").setHover("show_text", "&5Fish\n&cUnlocked by purchasing it for 90 Event Silver in the Summer Event Shop\n&aFavorites: Carrot, Water, Stick"),
        new TextComponent("Pufferfish Pet\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/animals/40877-pufferfish-yellow").setHover("show_text", "&6Pufferfish\n&cUnlocked by claiming the Summer Reward Tier VIII\n&aFavorites: Carrot, Water, Stick"),
        new TextComponent("Salmon Pet\n").setClick("open_url", "https://minecraft-heads.com/custom-heads/animals/17899-salmon").setHover("show_text", "&5Salmon\n&cCurrently unobtainable\n&aFavorites: Carrot, Water, Stick"),
        new TextComponent("Clownfish Pet").setClick("open_url", "https://minecraft-heads.com/custom-heads/animals/22794-clownfish").setHover("show_text", "&5Clownfish\n&cUnlocked by purchasing it for 90 Event Silver in the Halloween Event Shop\n&aFavorites: Carrot, Water, Stick")
    ))
    .addPage(new Message(new TextComponent("&9Skyblock Fish").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Click the names below to go to the Hypixel Wiki page.\n\n",
        new TextComponent("Oops the Fish\n").setClick("open_url", "https://wiki.hypixel.net/Oops_The_Fish").setHover("show_text", "&cOops the Fish\n&7Discovered in the depths of the\n&7Main Lobby during the summer\n&7months.\n\n&c&lSPECIAL"),
        new TextComponent("Spook the Fish\n").setClick("open_url", "https://wiki.hypixel.net/Spook_The_Fish").setHover("show_text", "&cSpook the Fish\n&7This fish lurks in the darkness\n&7below the Main Lobby during the\n&7Halloween season\n\n&c&lSPECIAL"),
        new TextComponent("Chill the Fish\n").setClick("open_url", "https://wiki.hypixel.net/Chill_The_Fish").setHover("show_text", "&cChill the Fish\n&7This fish was found frozen solid\n&7in the lake of the Main Lobby\n&7during the Holiday months.\n\n&c&lSPECIAL"),
        new TextComponent("Egg the Fish").setClick("open_url", "https://wiki.hypixel.net/Egg_The_Fish").setHover("show_text", "&cEgg the Fish\n&7This delicate, painted fish was\n&7found in the depths of the Main\n&7Lobby during the Easter season.\n\n&c&lSPECIAL")
    ))
    .addPage(new Message(new TextComponent("&9Special Fish").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Hover over the names for more info.\n\n",
        new TextComponent("Puffer Emoji\n").setHover("show_text", "&e&lPuffer Emoji\n&8Found In: &9WATER\n\n&7:puffer:\n\n&9Displays as Pufferfish"),
        new TextComponent("Nemo\n").setHover("show_text", "&e&lNemo\n&8Found In: &9WATER\n\n&7Maybe he's lost again?\n\n&9Displays as Clownfish"),
        new TextComponent("Knockback Slimeball\n").setHover("show_text", "&e&lKnockback Slimeball\n&8Found In: &9WATER\n\n&7So this is where it's been all\n&7this time?\n\n&9Displays as Slimeball"),
        new TextComponent("Hot Potato\n").setHover("show_text", "&e&lHot Potato\n&8Found In: &9WATER\n\n&7Would you look at that?\n\n&9Displays as Baked Potato"),
        new TextComponent("Fish Monger Suit Helmet\n").setHover("show_text", "&e&lFish Monger Suit Helmet\n&8Lobby Cosmetic\n&8Found In: &9WATER\n\n&7Oh look, a dirty helmet.\n\n&7&eEquip cosmetics using the\n&eCollectibles Menu!\n\n&9Displays as Leather Helmet\n&8Color: #1B458C"),
        new TextComponent("Fish Monger Suit Chestplate\n").setHover("show_text", "&e&lFish Monger Suit Chestplate\n&8Lobby Cosmetic\n&8Found In: &9WATER\n\n&7That's a pretty scuzzy shirt.\n\n&7&eEquip cosmetics using the\n&eCollectibles Menu!\n\n&9Displays as Leather Chestplate\n&8Color: #0E3880"),
        new TextComponent("Fish Monger Suit Leggings\n").setHover("show_text", "&e&lFish Monger Suit Leggings\n&8Lobby Cosmetic\n&8Found In: &9WATER\n\n&7Gross, mossy pants.\n\n&7&eEquip cosmetics using the\n&eCollectibles Menu!\n\n&9Displays as Leather Leggings\n&8Color: #062C6B"),
    ))
    .addPage(new Message(
        new TextComponent("Fish Monger Suit Boots\n").setHover("show_text", "&e&lFish Monger Suit Boots\n&8Lobby Cosmetic\n&8Found In: &9WATER\n\n&7These boots are falling apart.\n\n&7&eEquip cosmetics using the\n&eCollectibles Menu!\n\n&9Displays as Leather Boots\n&8Color: #00235C"),
        new TextComponent("Barnacle\n").setHover("show_text", "&e&lBarnacle\n&8Found In: &9WATER\n\n&7It really grows on you.\n\n&9Displays as Quartz"),
        new TextComponent("Leviathan\n").setHover("show_text", "&e&lLeviathan\n&8Found In: &9WATER\n\n&7That's one huge catch!\n\n&9Displays as Cooked Salmon"),
        new TextComponent("Star-Eater Scales\n").setHover("show_text", "&e&lStar-Eater Scales\n&8Found In: &9WATER\n\n&7It's destiny.\n\n&9Displays as Pink Dye"),
        new TextComponent("Rubber Duck\n").setHover("show_text", "&e&lRubber Duck\n&8Found In: &9WATER\n\n&7This isn't meant to be here!\n\n&9Displays as Blaze Powder"),
        new TextComponent("Oops the Fish\n").setHover("show_text", "&6&lOops The Fish\n&8Summer Fish\n&8Found In: &9WATER\n\n&7Oops, wrong game.\n\n&7&eClaim this SkyBlock fish from\n&eyour Jerry!\n\n&9Displays as Clownfish"),
        new TextComponent("Shark\n").setHover("show_text", "&6&lShark\n&8Summer Fish\n&8Found In: &9WATER\n\n&7Seems a bit small.\n\n&9Displays as Raw Fish"),
        new TextComponent("Sea Bass\n").setHover("show_text", "&6&lSea Bass\n&8Summer Fish\n&8Found In: &9WATER\n\n&7No wait- it's at least a C+!\n\n&9Displays as Raw Fish"),
        new TextComponent("Sunscreen\n").setHover("show_text", "&6&lSunscreen\n&8Summer Fish\n&8Found In: &9WATER\n\n&7Safety first!\n\n&9Displays as Potion of Fire Resistance"),
        new TextComponent("Pile of Sand\n").setHover("show_text", "&6&lPile Of Sand\n&8Summer Fish\n&8Found In: &9WATER\n\n&7Just like the beach!\n\n&9Displays as Glowstone Dust"),
        new TextComponent("Mahi Mahi\n").setHover("show_text", "&6&lMahi Mahi\n&8Summer Fish\n&8Found In: &9WATER\n\n&7So tasty!\n\n&9Displays as Raw Salmon"),
        new TextComponent("Lucent Bee Hive\n").setHover("show_text", "&6&lLucent Bee Hive\n&8Summer Fish\n&8Found In: &9WATER\n\n&7It's glowing!\n\n&9Displays as Yellow Dye"),
        new TextComponent("Spook the Fish\n").setHover("show_text", "&5&lSpook The Fish\n&8Halloween Fish\n&8Found In: &9WATER\n\n&7Wow, so spooky!\n\n&7&eClaim this SkyBlock fish from\n&eyour Jerry!\n\n&9Displays as Raw Salmon"),
        new TextComponent("Chocolate Bar").setHover("show_text", "&5&lChocolate Bar\n&8Halloween Fish\n&8Found In: &9WATER\n\n&7Might be a bit soggy.\n\n&9Displays as Nether Brick")
    ))
    .addPage(new Message(
        new TextComponent("Pumpkin Spice Latte\n").setHover("show_text", "&5&lPumpkin Spice Latte\n&8Halloween Fish\n&8Found In: &9WATER\n\n&7Wouldn't be fall without some\n&7pumpkin spice.\n\n&9Displays as Potion of Jump Boost"),
        new TextComponent("Angler\n").setHover("show_text", "&5&lAngler\n&8Halloween Fish\n&8Found In: &9WATER\n\n&7It looks kinda scary.\n\n&9Displays as Raw Fish"),
        new TextComponent("Pumpkin Pie\n").setHover("show_text", "&5&lPumpkin Pie\n&8Halloween Fish\n&8Found In: &9WATER\n\n&7You can have it for dessert!\n\n&9Displays as Pumpkin Pie"),
        new TextComponent("Eyeball\n").setHover("show_text", "&5&lEyeball\n&8Halloween Fish\n&8Found In: &9WATER\n\n&7How'd this get in here...\n\n&9Displays as Eye of Ender"),
        new TextComponent("Wayfinder's Compass\n").setHover("show_text", "&5&lWayfinder's Compass\n&8Halloween Fish\n&8Found In: &9WATER\n\n&7It's the season of the lost,\n&7don't lose your way.\n\n&9Displays as Compass"),
        new TextComponent("Molten Iron\n").setHover("show_text", "&5&lMolten Iron\n&8Halloween Fish\n&8Found In: &cLAVA\n\n&7Is it hot in here?\n\n&9Displays as Iron Ingot"),
        new TextComponent("Regular Fish\n").setHover("show_text", "&5&lRegular Fish\n&8Halloween Fish\n&8Found In: &cLAVA\n\n&7Wait, what?\n\n&9Displays as Raw Fish"),
        new TextComponent("Lava Shark\n").setHover("show_text", "&5&lLava Shark\n&8Halloween Fish\n&8Found In: &cLAVA\n\n&7Even scarier than a regular\n&7shark!\n\n&9Displays as Cooked Fish"),
        new TextComponent("Chill The Fish 3\n").setHover("show_text", "&c&lChill The Fish 3\n&8Holiday Fish\n&8Found In: &9WATER\n\n&7BrrRrRRr.\n\n&7&eClaim this SkyBlock fish from\n&eyour Jerry!\n\n&9Displays as Cooked Fish"),
        new TextComponent("Frozen Fish\n").setHover("show_text", "&c&lFrozen Fish\n&8Holiday Fish\n&8Found In: &bICE\n\n&7Heat in a microwave for 30\n&7seconds.\n\n&9Displays as Cooked Salmon"),
        new TextComponent("Festive Pufferfish Hat\n").setHover("show_text", "&c&lFestive Pufferfish Hat\n&8Holiday Fish\n&8Found In: &9WATER\n\n&7Look at its cute little hat!\n\n&7&eEquip cosmetics using the\n&eCollectibles Menu!\n\n&9Displays as Pufferfish"),
        new TextComponent("Eggnog\n").setHover("show_text", "&c&lEggnog\n&8Holiday Fish\n&8Found In: &9WATER\n\n&7Now is when everyone starts\n&7arguing.\n\n&9Displays as Potion of Slowness"),
        new TextComponent("Dawning Snowball\n").setHover("show_text", "&c&lDawning Snowball\n&8Holiday Fish\n&8Found In: &bICE\n\n&7Oh how I miss you...\n\n&9Displays as Snowball"),
        new TextComponent("Frozen Meal").setHover("show_text", "&c&lFrozen Meal\n&8Holiday Fish\n&8Found In: &bICE\n\n&7Instant dinner!\n\n&9Displays as Mushroom Stew")

    ))
    .addPage(new Message(
        new TextComponent("Festive Lights\n").setHover("show_text", "&c&lFestive Lights\n&8Holiday Fish\n&8Found In: &bICE\n\n&7Just needs to be untangled.\n\n&9Displays as Nether Star"),
        new TextComponent("Egg The Fish\n").setHover("show_text", "&b&lEgg The Fish\n&8Easter Fish\n&8Found In: &9WATER\n\n&7Don't crack it, it's fragile!\n\n&7&eClaim this SkyBlock fish from\n&eyour Jerry!\n\n&9Displays as Cooked Salmon"),
        new TextComponent("Cracked Egg\n").setHover("show_text", "&b&lCracked Egg\n&8Easter Fish\n&8Found In: &9WATER\n\n&7Poor chicken. :(.\n\n&9Displays as Egg"),
        new TextComponent("Raw Ham\n").setHover("show_text", "&b&lRaw Ham\n&8Easter Fish\n&8Found In: &9WATER\n\n&7Well, that saves a trip to the\n&7supermarket.\n\n&9Displays as Raw Porkchop"),
        new TextComponent("Carrot\n").setHover("show_text", "&b&lCarrot\n&8Easter Fish\n&8Found In: &9WATER\n\n&7Feed it to a rabbit!\n\n&9Displays as Carrot"),
        new TextComponent("Soggy Hot Cross Bun\n").setHover("show_text", "&b&lSoggy Hot Cross Bun\n&8Easter Fish\n&8Found In: &9WATER\n\n&7Make sure to learn the song on\n&7your recorder.\n\n&9Displays as Bread"),
        new TextComponent("Clay Ball\n").setHover("show_text", "&b&lClay Ball\n&8Easter Fish\n&8Found In: &9WATER\n\n&7That's no egg!\n\n&9Displays as Clay"),
        new TextComponent("Rose\n").setHover("show_text", "&b&lRose\n&8Easter Fish\n&8Found In: &9WATER\n\n&7From the sea birthed beauty.\n\n&9Displays as Poppy"),
        new TextComponent("Cherry Blossom").setHover("show_text", "&b&lCherry Blossom\n&8Easter Fish\n&8Found In: &9WATER\n\n&7So pretty!\n\n&9Displays as Magenta Dye")
    ))
    .addPage(new Message(new TextComponent("&9Statuses").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Hover over the names for more info.\n\n",
        new TextComponent("Legendary Fisher\n").setHover("show_text", "&aLegendary Fisher (General)\n\n&7Preview:\n&6Legendary Fisher\n\n&cRequires Master Reward III\n&9Displays as #0339 (Paper)"),
        new TextComponent("Main Lobby Special Fish Caught\n").setHover("show_text", "&aMain Lobby Special Fish Caught (General Stats)\n\n&7Preview:\n&aSpecial Fish Caught: &6X\n&d&lSpecial Fish Caught: &6X\n\n&cRequires MVP++\n&9Displays as #0349/0 (Raw Fish)\n\n&7&oThe style of the status changes after reaching\n&7&o10 special fish."),
        new TextComponent("Main Lobby Treasure Caught").setHover("show_text", "&aMain Lobby Treasure Caught (General Stats)\n\n&7Preview:\n&aTreasure Caught: &6X\n\n&cRequires MVP++\n&9Displays as #0329 (Saddle)")
    ))
    .addPage(new Message(new TextComponent("&9Updates").setHover("show_text", "&9Click to return to the Table of Contents").setClick("change_page", 2),
        "\n&8Click the names below to go the forum post.\n\n",
        new TextComponent("Summer 2020\n").setClick("open_url", "https://hypixel.net/threads/summer-update-scuba-simulator-achievements-and-more.2999676/"),
        new TextComponent("Summer 2021\n").setClick("open_url", "https://hypixel.net/threads/summer-update-sale-achievements-and-more.4350557/"),
        new TextComponent("Main Lobby Revamp\n").setClick("open_url", "https://hypixel.net/threads/main-lobby-new-activities-achievements-and-more.4887629/"),
        new TextComponent("Holidays 2022").setClick("open_url", "https://hypixel.net/threads/happy-holidays-from-hypixel.5184912/")
    ));
export { resources }