import { SettingsObject, Setting } from 'SettingsManager/SettingsManager'
let FishingUtils = new SettingsObject("FishingUtils", [{
        name: "Fishing Display",
        settings: [
            new Setting.Toggle("Display Fishing Stats", true),
            new Setting.Toggle("Show Seasonal Stats", true),
            new Setting.StringSelector("Text Align", 0, [
                "Left",
                "Center",
                "Right"
            ]),
            new Setting.StringSelector("Line Order", 0, [
                "Top to Bottom",
                "Bottom to Top"
            ]),
            new Setting.Button("Move Display", "Click", function() {
                ChatLib.command("fu move", true)
            }),
            new Setting.Toggle("Text Shadow", true),
            new Setting.Toggle("Background", false),
            new Setting.ColorPicker("Background Color", [34, 34, 39]),
            new Setting.Slider("Background Opacity", 255, 0, 255),
            new Setting.Toggle("Shorten Text", false),
            new Setting.Toggle("Show Last Caught", false),
            new Setting.Toggle("Show Mythical Fish Since Last Ultra Rare", false)
        ]
    },
    {
        name: "Mythic Display",
        settings: [
            new Setting.Toggle("Mythical Fish Display", true),
            new Setting.Button("Move Display", "Click", function() {
                ChatLib.command("fu move mythic", true)
            }),
            new Setting.Toggle("Lock Display to Top Right", true),
            new Setting.Toggle("Background", false),
            new Setting.ColorPicker("Background Color", [34, 34, 39]),
            new Setting.Slider("Background Opacity", 255, 0, 255)
        ]
    },
    {
        name: "Mythic Catch Assist",
        settings: [
            new Setting.Toggle("Mythical Alarm", false),
            new Setting.Slider("Volume", 100, 0, 100),
            new Setting.Toggle("Catch Overlay", true),
            new Setting.TextInput("Green Phase Text", "Click!"),
            new Setting.TextInput("Yellow Phase Text", "Click!"),
            new Setting.TextInput("Red Phase Text", "Wait!"),
            new Setting.Toggle("Show Time Left", true),
            new Setting.Toggle("Show Health Bar", true),
            new Setting.Toggle("Show Heat Bar", false),
            new Setting.Toggle("Show Clicks Left", true),
            new Setting.Toggle("Custom Catch Message", true),
            new Setting.Toggle("Mythic Spawning Message", false),
            new Setting.Toggle("Show Phase Data in Action Bar", false)
        ]
    },
    {
        name: "Announcer",
        settings: [
            new Setting.Toggle("Thousand Announcer", true),
            new Setting.StringSelector("Announcer Increment", 0, [
                "1K",
                "5K",
                "10K",
                "25K",
                "50K",
                "100K"
            ]),
            new Setting.Toggle("One Treasure Announcer", true),
        ]
    },
    {
        name: "Goals",
        settings: [
            new Setting.Toggle("Goals", false),
            new Setting.Toggle("Darken Goal Denominator", false),
            new Setting.StringSelector("Goal Preset", 0, [
                "None (Use Custom Goals)",
                "Achievements",
                "Fishing Rewards"
            ]),
            new Setting.Button("Set Custom Goals", "Click", function() {
                ChatLib.command("fu goals", true);
                Client.Companion.setCurrentChatMessage("/fu goals");
            })
        ]
    },
    {
        name: "Auto GC",
        settings: [
            new Setting.Toggle("Auto GC", false),
            new Setting.TextInput("Message", "gc"),
            new Setting.Button("Test Message", "Click", function() {
                ChatLib.command("fu testautogc", true)
            })
        ]
    },
    {
        name: "/fs",
        settings: [
            new Setting.Toggle("Style Name", false),
            new Setting.Toggle("Show Master Tier", false),
            new Setting.Toggle("Use Roman Numerals for Enchants", true),
            new Setting.Toggle("Ignore Old Mahi Mahi", false),
            new Setting.Toggle("Show More Info in Hover", false)
        ]

    },
    {
        name: "Custom Trails",
        settings: [
            new Setting.Toggle("Custom Trails", false),
            new Setting.Toggle("Only Show in the Main Lobby", true),
            new Setting.StringSelector("Preset", 0, [
                "None (Use Custom Trails)",
                "Emerald",
                "Sparkle",
                "Treasure's Sheen",
                "Beloved Junk",
                "Archimedes' Trail",
                "Hades' Hook",
                "Helios' Breath",
                "Organic Material",
                "Creature Catch",
                "Neptune's Grace",
                "Ominous Rain",
                "All of the Above",
                "Musical",
                "Ring of Fire",
                "Rainbow",
                "Love",
                "Moon",
                "Boiling",
                "Absorb",
                "Learn",
                "Stop Fishing",
                "Snow",
                "Lightning",
                "Spooky",
                "Trans",
                "Fish"
            ]),
            new Setting.StringSelector("Trail Type", 0, [
                "Emerald",
                "Hearts",
                "Water",
                "Fire",
                "Storm",
                "Dust",
                "Small Dust",
                "Large Dust",
                "Rising Dust",
                "Falling Dust",
                "Magic Dust",
                "Cloud",
                "Large Cloud",
                "Crit",
                "Magic Crit",
                "Runes",
                "Stars",
                "Music Notes"
            ]),
            new Setting.StringSelector("Trail Shape", 0, [
                "Orbit",
                "Orbit (Close)",
                "Orbit (Far)",
                "Continuous",
                "Burst",
                "Circle",
                "Halo",
                "Sine Wave",
                "Sawtooth"
            ]),
            new Setting.Toggle("Use Custom Color", false),
            new Setting.ColorPicker("Trail Color", [255, 255, 255]),
            new Setting.Toggle("Rainbow Color", false),
            new Setting.Slider("Trail Opacity", 100, 0, 100),
            new Setting.Toggle("Use Custom Lifespan", false),
            new Setting.Slider("Trail Lifespan", 20, 1, 100)
        ]
    },
    {
        name: "Miscellaneous",
        settings: [
            new Setting.Slider("AFK Alert Threshold", 0, 0, 60),
            new Setting.Toggle("Dockmaster Waypoint", false),
            new Setting.Toggle("Hide Leaderboard Switch Messages", false),
            new Setting.Toggle("Basic Mode", false),
            new Setting.TextInput("Thousand Separator Character", ","),
            new Setting.TextInput("Decimal Separator Character", "."),
            new Setting.Toggle("Continuously Refresh Display on Settings Menu", true),
            new Setting.Toggle("Secret", true),
            new Setting.Toggle("Spin", false),
            new Setting.Toggle("Trans Mythical Fish", false),
            new Setting.Toggle("Simpler Times", false).setHidden(true),
            new Setting.Toggle("Don't Convert Ultra Rares", true)
        ]
    }
]);

//golden ratio, 18, 448
FishingUtils.setSize(599, 289)

Setting.register(FishingUtils);

export { FishingUtils }