/*
 * Decompiled with CFR 0.152.
 */
package yqloss.awamod.feature.motionblur;

import java.nio.ByteBuffer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import yqloss.awamod.AwaMod;
import yqloss.awamod.config.AwaConfig;

public class MotionBlur {
    private static final Logger LOGGER = LogManager.getLogger(MotionBlur.class);
    private static final double FRAME_120 = 8333333.333333333;
    private static boolean allocated = false;
    private static int lastWidth = -1;
    private static int lastHeight = -1;
    private static long lastNanos = System.nanoTime();
    private static double widthFactor = 1.0;
    private static double heightFactor = 1.0;
    private static int textureId;

    private static void setupTexture(int texture, int width, int height) {
        int size;
        int maxWidthHeight = Math.max(width, height);
        for (size = 16; size < maxWidthHeight; size <<= 1) {
        }
        widthFactor = (double)width / (double)size;
        heightFactor = (double)height / (double)size;
        GlStateManager.func_179144_i((int)texture);
        ByteBuffer buffer = ByteBuffer.allocateDirect(size * size * 4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)size, (int)size, (int)0, (int)6407, (int)5121, (ByteBuffer)buffer);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        LOGGER.info(String.format("initialized texture %d (%dx%d) for %dx%d window size", texture, size, size, width, height));
    }

    private static void initialize(boolean init, int width, int height) {
        if (allocated) {
            GlStateManager.func_179150_h((int)textureId);
            LOGGER.info(String.format("deleted texture %d", textureId));
        }
        allocated = init;
        lastWidth = width;
        lastHeight = height;
        if (allocated) {
            textureId = GlStateManager.func_179146_y();
            MotionBlur.setupTexture(textureId, width, height);
        }
    }

    public static void beforeRender() {
        try {
            if (AwaMod.mc.field_71441_e == null) {
                lastNanos = System.nanoTime();
                MotionBlur.initialize(false, -1, -1);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception);
        }
    }

    private static void takeScreenShot(int width, int height) {
        try {
            if (!AwaConfig.EnableMotionBlur) {
                return;
            }
            if (lastWidth != width || lastHeight != height) {
                MotionBlur.initialize(true, width, height);
            }
            GlStateManager.func_179144_i((int)textureId);
            GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height);
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception);
        }
    }

    public static void renderMotionBlur(int width, int height, ScaledResolution scaledResolution) {
        try {
            if (!AwaConfig.EnableMotionBlur) {
                return;
            }
            if (lastWidth != width || lastHeight != height) {
                MotionBlur.initialize(true, width, height);
            }
            GlStateManager.func_179144_i((int)textureId);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179098_w();
            GlStateManager.func_179097_i();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)MotionBlur.getAlpha()));
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldRenderer = tessellator.func_178180_c();
            double scaledWidth = scaledResolution.func_78327_c();
            double scaledHeight = scaledResolution.func_78324_d();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(0.0, scaledHeight, 0.0).func_181673_a(0.0, 0.0).func_181675_d();
            worldRenderer.func_181662_b(scaledWidth, scaledHeight, 0.0).func_181673_a(widthFactor, 0.0).func_181675_d();
            worldRenderer.func_181662_b(scaledWidth, 0.0, 0.0).func_181673_a(widthFactor, heightFactor).func_181675_d();
            worldRenderer.func_181662_b(0.0, 0.0, 0.0).func_181673_a(0.0, heightFactor).func_181675_d();
            tessellator.func_78381_a();
            MotionBlur.takeScreenShot(width, height);
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception);
        }
    }

    private static double getAlpha() {
        double alpha = AwaConfig.MotionBlurStrength;
        if (AwaConfig.BalancedMotionBlur) {
            long currentNanos = System.nanoTime();
            long diffNanos = currentNanos - lastNanos;
            lastNanos = currentNanos;
            alpha = Math.pow(alpha, (double)diffNanos / 8333333.333333333);
        }
        return MathHelper.func_151237_a((double)alpha, (double)0.0, (double)1.0);
    }
}

