/*
 * Decompiled with CFR 0.152.
 */
package yqloss.yqlossclientmixinkt.util.math;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0019\u001a\u0018\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0086\b\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001c\u0010\u0007\u001a\u00020\u00002\n\u0010\u0006\u001a\u00020\u0002\"\u00020\u0005H\u0086\b\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u001c\u0010\t\u001a\u00020\u00002\n\u0010\u0006\u001a\u00020\u0002\"\u00020\u0005H\u0086\b\u00a2\u0006\u0004\b\t\u0010\b\u001a\u001c\u0010\n\u001a\u00020\u00002\n\u0010\u0006\u001a\u00020\u0002\"\u00020\u0005H\u0086\b\u00a2\u0006\u0004\b\n\u0010\b\u001a\u001c\u0010\f\u001a\u00020\u00022\n\u0010\u000b\u001a\u00020\u0002\"\u00020\u0005H\u0086\b\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0086\b\u00a2\u0006\u0004\b\u000e\u0010\u0004\u001a\u001c\u0010\u000f\u001a\u00020\u00022\n\u0010\u0006\u001a\u00020\u0002\"\u00020\u0005H\u0086\b\u00a2\u0006\u0004\b\u000f\u0010\r\u001a\u001c\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0086\f\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u001c\u0010\u0011\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\f\u00a2\u0006\u0004\b\u0011\u0010\u0014\"\u0014\u0010\u0015\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\"\u0014\u0010\u0017\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016\"\u0014\u0010\u0018\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0016\"\u0014\u0010\u0019\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0016\"\u0014\u0010\u001a\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0016\"\u0014\u0010\u001b\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0016\"\u0016\u0010\u001d\u001a\u00020\u0002*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\r\u00a8\u0006\u001e"}, d2={"", "argb", "", "convertARGBToDoubleArray", "(I)[D", "", "rgb", "convertDoubleArrayToARGB", "([D)I", "convertDoubleArrayToFFRGB", "convertDoubleArrayToRGB", "hsl", "convertHSLToRGB", "([D)[D", "convertRGBToDoubleArray", "convertRGBToHSL", "rgbaSrc", "blendColor", "([D[D)[D", "argbSrc", "(II)I", "V06", "D", "V16", "V26", "V36", "V46", "V56", "getNormalizeColor", "normalizeColor", "yqlossclientmixin-1.8.9-forge"})
@SourceDebugExtension(value={"SMAP\nColorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorUtil.kt\nyqloss/yqlossclientmixinkt/util/math/ColorUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MathUtil.kt\nyqloss/yqlossclientmixinkt/util/math/MathUtilKt\n*L\n1#1,124:1\n102#1:126\n102#1:127\n102#1:128\n81#1,5:130\n102#1:135\n80#1:136\n102#1:137\n91#1:142\n102#1:143\n92#1:144\n93#1,3:146\n91#1:149\n102#1:150\n92#1:151\n93#1,3:153\n102#1:156\n81#1,5:157\n102#1:162\n80#1,6:163\n102#1:169\n80#1:170\n105#1,12:171\n102#1,10:183\n91#1:193\n102#1:194\n92#1:195\n93#1,3:197\n1#2:125\n29#3:129\n29#3:138\n29#3:139\n29#3:140\n29#3:141\n29#3:145\n29#3:152\n29#3:196\n*S KotlinDebug\n*F\n+ 1 ColorUtil.kt\nyqloss/yqlossclientmixinkt/util/math/ColorUtilKt\n*L\n46#1:126\n76#1:127\n85#1:128\n88#1:130,5\n88#1:135\n88#1:136\n91#1:137\n98#1:142\n98#1:143\n98#1:144\n98#1:146,3\n100#1:149\n100#1:150\n100#1:151\n100#1:153,3\n116#1:156\n121#1:157,5\n121#1:162\n121#1:163,6\n121#1:169\n121#1:170\n121#1:171,12\n121#1:183,10\n120#1:193\n120#1:194\n120#1:195\n120#1:197,3\n88#1:129\n92#1:138\n93#1:139\n94#1:140\n95#1:141\n98#1:145\n100#1:152\n120#1:196\n*E\n"})
public final class ColorUtilKt {
    public static final double V06 = 0.0;
    public static final double V16 = 0.16666666666666666;
    public static final double V26 = 0.3333333333333333;
    public static final double V36 = 0.5;
    public static final double V46 = 0.6666666666666666;
    public static final double V56 = 0.8333333333333334;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] convertRGBToHSL(double ... rgb) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        boolean $i$f$convertRGBToHSL = false;
        double[] hsl = new double[rgb.length >= 4 ? 4 : 3];
        double maxRGB = ComparisonsKt.maxOf((double)0.0, (double[])Arrays.copyOf(rgb, rgb.length));
        double minRGB = ComparisonsKt.minOf((double)1.0, (double[])Arrays.copyOf(rgb, rgb.length));
        double delta = maxRGB - minRGB;
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        hsl[2] = (maxRGB + minRGB) / 2.0;
        if (delta > 0.0) {
            void it;
            hsl[1] = delta / Math.min(maxRGB + minRGB, (double)2 - maxRGB - minRGB);
            double d = maxRGB;
            double d2 = d == r ? (g - b) / delta + 6.0 : (d == g ? (b - r) / delta + 2.0 : (d == b ? (r - g) / delta + 4.0 : 0.0));
            int n = 0;
            double[] dArray = hsl;
            boolean bl = false;
            void var24_16 = it / 6.0 % 1.0;
            dArray[n] = var24_16;
        }
        if (rgb.length >= 4) {
            hsl[3] = rgb[3];
        }
        double[] $this$normalizeColor$iv = hsl;
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = $this$normalizeColor$iv.length;
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = Math.max(0.0, Math.min(1.0, $this$normalizeColor$iv[n3]));
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] convertHSLToRGB(double ... hsl) {
        void $this$normalizeColor$iv;
        double[] dArray;
        double[] dArray2;
        Intrinsics.checkNotNullParameter((Object)hsl, (String)"hsl");
        boolean $i$f$convertHSLToRGB = false;
        double h = hsl[0];
        double s = hsl[1];
        double l = hsl[2];
        double c = (1.0 - Math.abs(2.0 * l - 1.0)) * s;
        double x = c * (1.0 - Math.abs(h * 6.0 % 2.0 - 1.0));
        double m = l - c / 2.0;
        double d = h;
        Triple triple = RangesKt.rangeUntil((double)0.0, (double)0.16666666666666666).contains((Comparable)Double.valueOf(d)) ? new Triple((Object)c, (Object)x, (Object)0.0) : (RangesKt.rangeUntil((double)0.16666666666666666, (double)0.3333333333333333).contains((Comparable)Double.valueOf(d)) ? new Triple((Object)x, (Object)c, (Object)0.0) : (RangesKt.rangeUntil((double)0.3333333333333333, (double)0.5).contains((Comparable)Double.valueOf(d)) ? new Triple((Object)0.0, (Object)c, (Object)x) : (RangesKt.rangeUntil((double)0.5, (double)0.6666666666666666).contains((Comparable)Double.valueOf(d)) ? new Triple((Object)0.0, (Object)x, (Object)c) : (RangesKt.rangeUntil((double)0.6666666666666666, (double)0.8333333333333334).contains((Comparable)Double.valueOf(d)) ? new Triple((Object)x, (Object)0.0, (Object)c) : new Triple((Object)c, (Object)0.0, (Object)x)))));
        double rp = ((Number)triple.component1()).doubleValue();
        double gp = ((Number)triple.component2()).doubleValue();
        double bp = ((Number)triple.component3()).doubleValue();
        if (hsl.length >= 4) {
            dArray2 = new double[]{rp + m, gp + m, bp + m, hsl[3]};
            dArray = dArray2;
        } else {
            dArray2 = new double[]{rp + m, gp + m, bp + m};
            dArray = dArray2;
        }
        dArray2 = dArray;
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = ((void)$this$normalizeColor$iv).length;
        double[] dArray3 = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray3[n3] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv[n3]));
        }
        return dArray3;
    }

    @NotNull
    public static final double[] convertARGBToDoubleArray(int argb) {
        boolean $i$f$convertARGBToDoubleArray = false;
        double[] dArray = new double[]{(double)(argb >>> 16 & 0xFF) / 255.0, (double)(argb >>> 8 & 0xFF) / 255.0, (double)(argb & 0xFF) / 255.0, (double)(argb >>> 24 & 0xFF) / 255.0};
        double[] $this$normalizeColor$iv = dArray;
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = $this$normalizeColor$iv.length;
        double[] dArray2 = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray2[n3] = Math.max(0.0, Math.min(1.0, $this$normalizeColor$iv[n3]));
        }
        return dArray2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] convertRGBToDoubleArray(int argb) {
        void $this$normalizeColor$iv$iv;
        boolean $i$f$convertRGBToDoubleArray = false;
        long $this$int$iv = 0xFF000000L;
        boolean $i$f$getInt = false;
        int argb$iv = argb | (int)$this$int$iv;
        boolean $i$f$convertARGBToDoubleArray = false;
        double[] dArray = new double[]{(double)(argb$iv >>> 16 & 0xFF) / 255.0, (double)(argb$iv >>> 8 & 0xFF) / 255.0, (double)(argb$iv & 0xFF) / 255.0, (double)(argb$iv >>> 24 & 0xFF) / 255.0};
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = ((void)$this$normalizeColor$iv$iv).length;
        double[] dArray2 = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray2[n3] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv$iv[n3]));
        }
        return dArray2;
    }

    public static final int convertDoubleArrayToARGB(double ... rgb) {
        int n;
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        boolean $i$f$convertDoubleArrayToARGB = false;
        double[] $this$normalizeColor$iv = rgb;
        boolean $i$f$getNormalizeColor = false;
        int n2 = 0;
        int n3 = $this$normalizeColor$iv.length;
        double[] dArray = new double[n3];
        while (n2 < n3) {
            int n4 = n2++;
            dArray[n4] = Math.max(0.0, Math.min(1.0, $this$normalizeColor$iv[n4]));
        }
        double[] norm = dArray;
        double $this$int$iv = norm[0] * 255.0;
        boolean $i$f$getInt = false;
        int n5 = (int)$this$int$iv << 16;
        $this$int$iv = norm[1] * 255.0;
        $i$f$getInt = false;
        int n6 = n5 | (int)$this$int$iv << 8;
        $this$int$iv = norm[2] * 255.0;
        $i$f$getInt = false;
        int n7 = n6 | (int)$this$int$iv;
        if (rgb.length >= 4) {
            $this$int$iv = norm[3] * 255.0;
            $i$f$getInt = false;
            n = (int)$this$int$iv << 24;
        } else {
            n = 255;
        }
        return n7 | n;
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertDoubleArrayToRGB(double ... rgb) {
        int n;
        void rgb$iv;
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        boolean $i$f$convertDoubleArrayToRGB = false;
        double[] dArray = new double[]{rgb[0], rgb[1], rgb[2], 0.0};
        boolean $i$f$convertDoubleArrayToARGB = false;
        void $this$normalizeColor$iv$iv = rgb$iv;
        boolean $i$f$getNormalizeColor = false;
        int n2 = 0;
        int n3 = ((void)$this$normalizeColor$iv$iv).length;
        double[] dArray2 = new double[n3];
        while (n2 < n3) {
            int n4 = n2++;
            dArray2[n4] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv$iv[n4]));
        }
        double[] norm$iv = dArray2;
        double $this$int$iv$iv = norm$iv[0] * 255.0;
        boolean $i$f$getInt = false;
        int n5 = (int)$this$int$iv$iv << 16;
        $this$int$iv$iv = norm$iv[1] * 255.0;
        $i$f$getInt = false;
        int n6 = n5 | (int)$this$int$iv$iv << 8;
        $this$int$iv$iv = norm$iv[2] * 255.0;
        $i$f$getInt = false;
        int n7 = n6 | (int)$this$int$iv$iv;
        if (((void)rgb$iv).length >= 4) {
            $this$int$iv$iv = norm$iv[3] * 255.0;
            $i$f$getInt = false;
            n = (int)$this$int$iv$iv << 24;
        } else {
            n = 255;
        }
        return n7 | n;
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertDoubleArrayToFFRGB(double ... rgb) {
        int n;
        void rgb$iv;
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        boolean $i$f$convertDoubleArrayToFFRGB = false;
        double[] dArray = new double[]{rgb[0], rgb[1], rgb[2], 1.0};
        boolean $i$f$convertDoubleArrayToARGB = false;
        void $this$normalizeColor$iv$iv = rgb$iv;
        boolean $i$f$getNormalizeColor = false;
        int n2 = 0;
        int n3 = ((void)$this$normalizeColor$iv$iv).length;
        double[] dArray2 = new double[n3];
        while (n2 < n3) {
            int n4 = n2++;
            dArray2[n4] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv$iv[n4]));
        }
        double[] norm$iv = dArray2;
        double $this$int$iv$iv = norm$iv[0] * 255.0;
        boolean $i$f$getInt = false;
        int n5 = (int)$this$int$iv$iv << 16;
        $this$int$iv$iv = norm$iv[1] * 255.0;
        $i$f$getInt = false;
        int n6 = n5 | (int)$this$int$iv$iv << 8;
        $this$int$iv$iv = norm$iv[2] * 255.0;
        $i$f$getInt = false;
        int n7 = n6 | (int)$this$int$iv$iv;
        if (((void)rgb$iv).length >= 4) {
            $this$int$iv$iv = norm$iv[3] * 255.0;
            $i$f$getInt = false;
            n = (int)$this$int$iv$iv << 24;
        } else {
            n = 255;
        }
        return n7 | n;
    }

    @NotNull
    public static final double[] getNormalizeColor(@NotNull double[] $this$normalizeColor) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeColor, (String)"<this>");
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = $this$normalizeColor.length;
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = Math.max(0.0, Math.min(1.0, $this$normalizeColor[n3]));
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] blendColor(@NotNull double[] $this$blendColor, @NotNull double[] rgbaSrc) {
        void $this$normalizeColor$iv;
        Intrinsics.checkNotNullParameter((Object)$this$blendColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rgbaSrc, (String)"rgbaSrc");
        boolean $i$f$blendColor = false;
        double srcR = rgbaSrc[0];
        double srcG = rgbaSrc[1];
        double srcB = rgbaSrc[2];
        double srcA = rgbaSrc[3];
        double dstR = $this$blendColor[0];
        double dstG = $this$blendColor[1];
        double dstB = $this$blendColor[2];
        double dstA = $this$blendColor.length >= 4 ? $this$blendColor[3] : 1.0;
        double resA = srcA + dstA * (1.0 - srcA);
        double srcM = srcA / resA;
        double dstM = dstA * (1.0 - srcA) / resA;
        double[] dArray = new double[]{srcR * srcM + dstR * dstM, srcG * srcM + dstG * dstM, srcB * srcM + dstB * dstM, resA};
        boolean $i$f$getNormalizeColor = false;
        int n = 0;
        int n2 = ((void)$this$normalizeColor$iv).length;
        double[] dArray2 = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray2[n3] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv[n3]));
        }
        return dArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int blendColor(int $this$blendColor, int argbSrc) {
        int n;
        void $this$normalizeColor$iv$iv;
        void $this$blendColor$iv;
        void rgbaSrc$iv;
        void $this$normalizeColor$iv$iv2;
        void $this$normalizeColor$iv$iv3;
        boolean $i$f$blendColor = false;
        boolean $i$f$convertARGBToDoubleArray22 = false;
        double[] dArray = new double[]{(double)($this$blendColor >>> 16 & 0xFF) / 255.0, (double)($this$blendColor >>> 8 & 0xFF) / 255.0, (double)($this$blendColor & 0xFF) / 255.0, (double)($this$blendColor >>> 24 & 0xFF) / 255.0};
        boolean $i$f$getNormalizeColor22 = false;
        int n2 = 0;
        int n3 = ((void)$this$normalizeColor$iv$iv3).length;
        double[] dArray2 = new double[n3];
        while (n2 < n3) {
            int n4 = n2++;
            dArray2[n4] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv$iv3[n4]));
        }
        double[] $i$f$convertARGBToDoubleArray22 = dArray2;
        boolean $i$f$convertARGBToDoubleArray32 = false;
        double[] $i$f$getNormalizeColor22 = new double[]{(double)(argbSrc >>> 16 & 0xFF) / 255.0, (double)(argbSrc >>> 8 & 0xFF) / 255.0, (double)(argbSrc & 0xFF) / 255.0, (double)(argbSrc >>> 24 & 0xFF) / 255.0};
        boolean $i$f$getNormalizeColor = false;
        n3 = 0;
        int n5 = ((void)$this$normalizeColor$iv$iv2).length;
        double[] dArray3 = new double[n5];
        while (n3 < n5) {
            int n6 = n3++;
            dArray3[n6] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv$iv2[n6]));
        }
        double[] $i$f$convertARGBToDoubleArray32 = dArray3;
        boolean $i$f$blendColor2 = false;
        void srcR$iv = rgbaSrc$iv[0];
        void srcG$iv = rgbaSrc$iv[1];
        void srcB$iv = rgbaSrc$iv[2];
        void srcA$iv = rgbaSrc$iv[3];
        void dstR$iv = $this$blendColor$iv[0];
        void dstG$iv = $this$blendColor$iv[1];
        void dstB$iv = $this$blendColor$iv[2];
        double dstA$iv = ((void)$this$blendColor$iv).length >= 4 ? $this$blendColor$iv[3] : 1.0;
        void resA$iv = srcA$iv + dstA$iv * (1.0 - srcA$iv);
        void srcM$iv = srcA$iv / resA$iv;
        double dstM$iv = dstA$iv * (1.0 - srcA$iv) / resA$iv;
        double[] dArray4 = new double[]{srcR$iv * srcM$iv + dstR$iv * dstM$iv, srcG$iv * srcM$iv + dstG$iv * dstM$iv, srcB$iv * srcM$iv + dstB$iv * dstM$iv, resA$iv};
        boolean $i$f$getNormalizeColor3 = false;
        int n7 = 0;
        int n8 = ((void)$this$normalizeColor$iv$iv).length;
        double[] dArray5 = new double[n8];
        while (n7 < n8) {
            int n9 = n7++;
            dArray5[n9] = Math.max(0.0, Math.min(1.0, (double)$this$normalizeColor$iv$iv[n9]));
        }
        double[] dArray6 = dArray5;
        double[] rgb$iv = Arrays.copyOf(dArray6, dArray6.length);
        boolean $i$f$convertDoubleArrayToARGB = false;
        double[] $this$normalizeColor$iv$iv22 = rgb$iv;
        boolean $i$f$getNormalizeColor4 = false;
        int n10 = 0;
        n3 = $this$normalizeColor$iv$iv22.length;
        double[] dArray7 = new double[n3];
        while (n10 < n3) {
            int n11 = n10++;
            dArray7[n11] = Math.max(0.0, Math.min(1.0, $this$normalizeColor$iv$iv22[n11]));
        }
        double[] norm$iv = dArray7;
        double $this$int$iv$iv = norm$iv[0] * 255.0;
        boolean $i$f$getInt = false;
        int n12 = (int)$this$int$iv$iv << 16;
        $this$int$iv$iv = norm$iv[1] * 255.0;
        $i$f$getInt = false;
        int n13 = n12 | (int)$this$int$iv$iv << 8;
        $this$int$iv$iv = norm$iv[2] * 255.0;
        $i$f$getInt = false;
        int n14 = n13 | (int)$this$int$iv$iv;
        if (rgb$iv.length >= 4) {
            $this$int$iv$iv = norm$iv[3] * 255.0;
            $i$f$getInt = false;
            n = (int)$this$int$iv$iv << 24;
        } else {
            n = 255;
        }
        return n14 | n;
    }
}

